---
generated_at: 2026-01-22 19:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **HSTSサポート状況**：フレームワークコードに明示的な記述がなく、未実装と推定
  2. **CSRFトークン機能の未実装**：コード内に実装が見当たらないため未実装と判断
  3. **保存データ暗号化の未実装**：暗号化ユーティリティのコードが見当たらない
  4. **対応SSL/TLSバージョン詳細**：OpenSSLライブラリへの依存を確認したがバージョン詳細は未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Session.pas`
- E-02: `src/Horse.Provider.IOHandleSSL.pas`
- E-03: `src/Horse.Provider.IOHandleSSL.Contract.pas`
- E-04: `src/Horse.Exception.pas`
- E-05: `src/Horse.Core.pas`
- E-06: `src/Horse.Request.pas`
- E-07: `src/Horse.Response.pas`
- E-08: `src/Horse.Commons.pas`
- E-09: `src/Horse.Core.RouterTree.pas`
- E-10: `src/Horse.Core.Param.pas`
- E-11: `src/Horse.Core.Param.Field.pas`
- E-12: `src/Horse.Provider.Console.pas`
- E-13: `src/Horse.Provider.VCL.pas`
- E-14: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証機構はミドルウェアとして提供される設計 | E-05, E-14 | ○ |
| C-02 | horse/basic-auth、horse/jwt等の認証ミドルウェアが存在 | E-14 | ○ |
| C-03 | OnParseAuthenticationイベントが実装されている | E-12, E-13 | ○ |
| C-04 | THorseSessionsクラスによるセッションストア機構 | E-01 | ○ |
| C-05 | セッション固定化対策は未実装 | E-01 | ○ |
| C-06 | 認可機能はフレームワークに内蔵されていない | E-05 | ○ |
| C-07 | ミドルウェアチェーンによるアクセス制御設計 | E-05, E-09 | ○ |
| C-08 | THorseCore.Useでミドルウェア登録が可能 | E-05 | ○ |
| C-09 | SSL/TLS対応（OpenSSL経由） | E-02, E-03 | ○ |
| C-10 | HSTSは未実装 | **根拠なし** | △ |
| C-11 | SSL/TLS設定項目（証明書、鍵、DHパラメータ等） | E-02, E-03 | ○ |
| C-12 | 暗号スイート設定が可能 | E-02 | ○ |
| C-13 | 保存データ暗号化は未実装 | **根拠なし** | △ |
| C-14 | Horse.EnvironmentVariables.pasが存在 | ファイル一覧で確認 | ○ |
| C-15 | XSS対策は未実装 | E-07 | ○ |
| C-16 | CSRF対策は未実装 | **根拠なし** | △ |
| C-17 | THorseCoreParamFieldによる型安全なパラメータ取得 | E-11 | ○ |
| C-18 | AsString、AsInteger等の型変換メソッド | E-11 | ○ |
| C-19 | Required、RequiredMessage等のバリデーション | E-11 | ○ |
| C-20 | バリデーションエラー時にBadRequest(400)が返される | E-11 | ○ |
| C-21 | EHorseExceptionによる構造化エラーレスポンス | E-04 | ○ |
| C-22 | エラーレスポンスにUnit名等の詳細情報が含まれる可能性 | E-04 | ○ |
| C-23 | ログ機能はフレームワーク本体に未実装 | E-05, E-06, E-07 | ○ |
| C-24 | horse/loggerミドルウェアでアクセスログ対応可能 | E-14 | ○ |
| C-25 | パスパラメータ（:param）のサポート | E-09 | ○ |
| C-26 | 正規表現パターンルーティングのサポート | E-09 | ○ |
| C-27 | CSRFトークン生成/検証機能は未実装 | **根拠なし** | △ |
| C-28 | THorseCore.Allで全HTTPメソッドにルート登録可能 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **HSTSサポート状況**: コード内でHSTSに関する明示的な実装が見当たらなかったため未実装と推定したが、Response.AddHeaderを使用すればアプリケーション側で設定可能
  - 候補：追加調査 / アプリケーション実装例の確認 / ドキュメント確認
- **CSRF対策**: フレームワーク内にCSRFトークン関連のコードが見当たらないため未実装と判断
  - 候補：ミドルウェア調査 / サードパーティソリューション確認
- **保存データ暗号化**: フレームワークのスコープ外と判断したが、明示的な設計指針の確認は未実施
  - 候補：設計ドキュメント確認 / 関連ミドルウェア調査
- **対応SSL/TLSバージョン詳細**: OpenSSLライブラリのTIdSSLVersionに依存するが、具体的なバージョン制約は未検証
  - 候補：Indyライブラリドキュメント確認 / OpenSSLバージョン確認

## 5) リスクフラグ（レビュー観点）
- **リスクレベル1（中）**: HSTSが自動設定されないため、アプリケーション開発者が明示的に設定する必要がある
- **リスクレベル1（中）**: CSRFトークン機能がないため、フォームを使用するアプリケーションでは別途対策が必要
- **リスクレベル1（中）**: エラーレスポンスに詳細情報が含まれる可能性があり、本番環境での情報漏洩リスク
- **リスクレベル0（低）**: XSS対策はアプリケーション側で実装が必要（フレームワークとしては一般的）
- **リスクレベル0（低）**: ログ機能はミドルウェアで対応可能（設計上の意図）

## 6) レビュアーチェックリスト（最小）
- [ ] SSL/TLS設定項目が実際のProviderコードと一致しているか確認
- [ ] THorseSessionsのメモリ管理（doOwnsValues）が正しく記述されているか確認
- [ ] EHorseExceptionのJSONレスポンス形式が実装と一致しているか確認
- [ ] 入力バリデーションの型変換メソッド一覧が網羅されているか確認
- [ ] 公式ミドルウェア一覧がREADME.mdと一致しているか確認
- [ ] セキュリティ上の推奨事項が妥当か確認
