# ER図

## 概要

本ドキュメントは、Horse Webフレームワークにおけるメモリ内データ構造間の関係をER図形式で表現しています。

**注意**: Horseは永続化データベースを持たないため、本図はメモリ内オブジェクト間の関係を示すものです。

## メインデータ構造関係図

```mermaid
erDiagram
    THorseCore ||--o| THorseModule : "creates"
    THorseCore ||--|| THorseRouterTree : "owns"
    THorseCore ||--o{ THorseCallback : "manages"

    THorseRouterTree ||--o{ THorseRouterTree : "children"
    THorseRouterTree ||--o{ THorseCallback : "middleware"
    THorseRouterTree ||--o{ THorseCallback : "callbacks"

    THorseRequest ||--|| THorseSessions : "contains"
    THorseRequest ||--o| THorseCoreParam : "headers"
    THorseRequest ||--o| THorseCoreParam : "query"
    THorseRequest ||--o| THorseCoreParam : "params"
    THorseRequest ||--o| THorseCoreParam : "contentFields"
    THorseRequest ||--o| THorseCoreParam : "cookie"

    THorseSessions ||--o{ TSession : "stores"

    THorseCoreParam ||--o{ THorseCoreParamField : "fields"
    THorseCoreParam ||--o{ TStream : "files"
```

## クラス詳細図

```mermaid
classDiagram
    class THorseCore {
        -FRoutes: THorseRouterTree
        -FCallbacks: TList~THorseCallback~
        -FDefaultHorse: THorseCore
        +GetInstance() THorseCore
        +AddCallback(ACallback) THorseCore
        +Get(APath, ACallback) THorseCore
        +Post(APath, ACallback) THorseCore
        +Put(APath, ACallback) THorseCore
        +Delete(APath, ACallback) THorseCore
        +Use(ACallback) THorseCore
        +Routes: THorseRouterTree
    }

    class THorseRouterTree {
        -FPrefix: string
        -FPart: string
        -FTag: string
        -FIsParamsKey: Boolean
        -FRouterRegex: string
        -FIsRouterRegex: Boolean
        -FMiddleware: TList~THorseCallback~
        -FRegexedKeys: TList~string~
        -FCallBack: TObjectDictionary
        -FRoute: TObjectDictionary
        +CreateRouter(APath) THorseRouterTree
        +RegisterRoute(AHTTPType, APath, ACallback)
        +RegisterMiddleware(APath, AMiddleware)
        +Execute(ARequest, AResponse) Boolean
    }

    class THorseRequest {
        -FWebRequest: TWebRequest
        -FHeaders: THorseCoreParam
        -FQuery: THorseCoreParam
        -FParams: THorseCoreParam
        -FContentFields: THorseCoreParam
        -FCookie: THorseCoreParam
        -FBody: TObject
        -FSession: TObject
        -FSessions: THorseSessions
        +Body() string
        +Headers() THorseCoreParam
        +Query() THorseCoreParam
        +Params() THorseCoreParam
        +Cookie() THorseCoreParam
        +Sessions() THorseSessions
    }

    class THorseResponse {
        -FWebResponse: TWebResponse
        -FContent: TObject
        +Send(AContent) THorseResponse
        +Status(AStatus) THorseResponse
        +RedirectTo(ALocation) THorseResponse
        +SendFile(AFileName) THorseResponse
        +Download(AFileName) THorseResponse
        +AddHeader(AName, AValue) THorseResponse
    }

    class THorseSessions {
        -FSessions: TObjectDictionary
        +GetSession(ASessionClass) TSession
        +SetSession(ASessionClass, AInstance) THorseSessions
        +Contains(ASessionClass) Boolean
        +TryGetSession~T~(ASession) Boolean
    }

    class THorseCoreParam {
        -FParams: THorseList
        -FFiles: TDictionary
        -FFields: TDictionary
        -FContent: TStrings
        -FRequired: Boolean
        +Field(AKey) THorseCoreParamField
        +ContainsKey(AKey) Boolean
        +Required(AValue) THorseCoreParam
        +AddStream(AKey, AContent) THorseCoreParam
    }

    class THorseModule {
        -FSelfInstance: PHorseCore
        -FDefaultHorseCoreInstance: PHorseCore
        -FHorseRouterTree: PHorseRouterTree
        +ToHorse() THorseCore
    }

    THorseCore --> THorseRouterTree
    THorseCore --> THorseModule
    THorseRequest --> THorseSessions
    THorseRequest --> THorseCoreParam
    THorseRouterTree --> THorseRouterTree
```

## リクエスト処理フロー

```mermaid
sequenceDiagram
    participant Client
    participant THorse
    participant THorseRouterTree
    participant THorseRequest
    participant THorseResponse
    participant Callback

    Client->>THorse: HTTP Request
    THorse->>THorseRequest: Create(WebRequest)
    THorse->>THorseResponse: Create(WebResponse)
    THorse->>THorseRouterTree: Execute(Request, Response)

    loop Middleware Chain
        THorseRouterTree->>Callback: Execute Middleware
        Callback-->>THorseRouterTree: Next()
    end

    THorseRouterTree->>Callback: Execute Route Handler
    Callback->>THorseRequest: Get Params/Query/Body
    Callback->>THorseResponse: Send/Status/Content

    THorseRouterTree-->>THorse: Result
    THorse-->>Client: HTTP Response
```

## データ構造の所有関係

```mermaid
graph TD
    subgraph Application Lifetime
        A[THorseCore] --> B[THorseRouterTree]
        B --> C[FRoute: Child RouterTrees]
        B --> D[FCallBack: Callbacks Dictionary]
        B --> E[FMiddleware: Middleware List]
    end

    subgraph Request Lifetime
        F[THorseRequest] --> G[THorseSessions]
        F --> H[FHeaders: THorseCoreParam]
        F --> I[FQuery: THorseCoreParam]
        F --> J[FParams: THorseCoreParam]
        F --> K[FContentFields: THorseCoreParam]
        F --> L[FCookie: THorseCoreParam]

        M[THorseResponse] --> N[FContent: TObject]
    end

    style A fill:#f9f,stroke:#333,stroke-width:2px
    style F fill:#bbf,stroke:#333,stroke-width:2px
    style M fill:#bfb,stroke:#333,stroke-width:2px
```

## 列挙型関係図

```mermaid
graph LR
    subgraph TMethodType
        MT1[mtAny]
        MT2[mtGet]
        MT3[mtPut]
        MT4[mtPost]
        MT5[mtHead]
        MT6[mtDelete]
        MT7[mtPatch]
    end

    subgraph THTTPStatus
        HS1[OK = 200]
        HS2[Created = 201]
        HS3[NoContent = 204]
        HS4[BadRequest = 400]
        HS5[NotFound = 404]
        HS6[InternalServerError = 500]
    end

    subgraph TMimeTypes
        MM1[ApplicationJSON]
        MM2[TextHTML]
        MM3[MultiPartFormData]
        MM4[ApplicationOctetStream]
    end

    THorseRouterTree --> TMethodType
    THorseResponse --> THTTPStatus
    THorseRequest --> TMimeTypes
```

## 備考

1. **永続化なし**: 本プロジェクトはWebフレームワークのため、データベースへの永続化機能は含まれていません
2. **メモリ管理**: Delphiのオブジェクト所有関係に基づき、親オブジェクト破棄時に子オブジェクトも自動的に解放されます
3. **スレッド安全性**: 各リクエストは独立したTHorseRequest/THorseResponseインスタンスを持つため、並行処理が可能です
