---
generated_at: 2026-01-22 17:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **サードパーティライブラリとの組み合わせ推奨**: 外部情報に基づく推奨であり、コードからの根拠なし
  2. **スレッド安全性**: 並行処理についてはコードから直接確認できず推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Session.pas` - THorseSessions クラス定義
- E-02: `src/Horse.Core.Param.pas` - THorseCoreParam クラス定義
- E-03: `src/Horse.Core.RouterTree.pas` - THorseRouterTree クラス定義
- E-04: `src/Horse.Core.pas` - THorseCore, THorseModule 定義
- E-05: `src/Horse.Request.pas` - THorseRequest クラス定義
- E-06: `src/Horse.Response.pas` - THorseResponse クラス定義
- E-07: `src/Horse.Commons.pas` - TMethodType, THTTPStatus, TMimeTypes 列挙型定義
- E-08: `README.md` - プロジェクト概要・用途の説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Horseはデータベース機能を持たないWebフレームワークである | E-08, 全ソースコード調査 | ○ |
| C-02 | THorseSessionsはFSessionsフィールドでセッションを管理する | E-01 (line 24) | ○ |
| C-03 | THorseCoreParamはFParams, FFiles, FFields, FContent, FRequiredフィールドを持つ | E-02 (lines 27-31) | ○ |
| C-04 | THorseRouterTreeはFPrefix, FPart, FTag等のフィールドを持つ | E-03 (lines 29-42) | ○ |
| C-05 | THorseModuleはFSelfInstance, FDefaultHorseCoreInstance, FHorseRouterTreeを持つ | E-04 (lines 28-34) | ○ |
| C-06 | THorseRequestはFWebRequest, FHeaders, FQuery等のフィールドを持つ | E-05 (lines 28-36) | ○ |
| C-07 | THorseResponseはFWebResponse, FContentフィールドを持つ | E-06 (lines 26-27) | ○ |
| C-08 | TMethodTypeはmtAny, mtGet, mtPut, mtPost, mtHead, mtDelete, mtPatchを含む | E-07 (line 20) | ○ |
| C-09 | THTTPStatusはHTTPステータスコードを表す列挙型である | E-07 (lines 24-87) | ○ |
| C-10 | TMimeTypesはMIMEタイプを表す列挙型である | E-07 (lines 89-106) | ○ |
| C-11 | THorseRouterTreeは子ルートをFRouteで木構造管理する | E-03 (line 42) | ○ |
| C-12 | THorseRouterTreeのFCallBackはHTTPメソッド別コールバック辞書である | E-03 (line 41) | ○ |
| C-13 | THorseCoreParamはTDictionary<string, string>でパラメータを保持する | E-02 (line 23) | ○ |
| C-14 | THorseSessionsはTObjectDictionary<TSessionClass, TSession>を使用する | E-01 (line 24) | ○ |
| C-15 | THorseRequestのFSessionsはコンストラクタで生成される | E-05 (lines 114-116) | ○ |
| C-16 | THorseRouterTreeはCreateコンストラクタで各コレクションを初期化する | E-03 (lines 119-127) | ○ |
| C-17 | サードパーティDB（FireDAC, UniDAC等）との組み合わせが推奨される | **根拠なし** | △ |
| C-18 | 各リクエストは独立したインスタンスを持ちスレッド安全である | **推定** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: サードパーティデータベースライブラリの推奨について
  - 理由: Horseプロジェクト内にDB連携の具体的な実装やドキュメントが存在しない
  - 候補: 公式ドキュメント / サンプルプロジェクト / コミュニティガイド
- C-18: スレッド安全性について
  - 理由: 並行処理のテストコードやドキュメントが確認できない
  - 候補: マルチスレッドテスト / パフォーマンステスト / 公式ガイド

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: データ構造定義（C-01〜C-16）
  - ソースコードから直接確認可能な内容
- **1（中リスク）**: スレッド安全性の主張（C-18）
  - コード構造からの推定であり、実際の動作検証が必要
- **1（中リスク）**: 外部ライブラリ推奨（C-17）
  - 一般的なベストプラクティスに基づく推奨だが、プロジェクト固有の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスのフィールド定義がソースコードと一致しているか確認
- [ ] 列挙型の値がHorse.Commons.pasの定義と一致しているか確認
- [ ] THorseRouterTreeの木構造管理方法が正確に記述されているか確認
- [ ] メモリライフサイクルの説明が実際のコンストラクタ/デストラクタと整合しているか確認
- [ ] 「データベース機能なし」の説明がプロジェクトの目的と整合しているか確認
