# データベース設計書

## 概要

本ドキュメントは、Horse Webフレームワークプロジェクトにおけるデータ構造を定義しています。

**重要**: Horseは永続化データベースを使用しないWebフレームワークです。外部データベース機能は提供されておらず、データの永続化はアプリケーション側の実装に委ねられています。本設計書では、フレームワーク内部で使用されるメモリ内データ構造について記載します。

## テーブル一覧

Horseフレームワークはデータベーステーブルを持ちませんが、以下のメモリ内データ構造が存在します。

| データ構造名 | 対応クラス/レコード | 説明 |
| --- | --- | --- |
| Sessions | THorseSessions | HTTPリクエスト間でのセッションデータを保持 |
| CoreParam | THorseCoreParam | HTTPリクエストのパラメータ（クエリ、ヘッダ、ボディ）を管理 |
| RouterTree | THorseRouterTree | ルーティング情報を木構造で管理 |
| HorseModule | THorseModule | フレームワークモジュール設定を保持 |

## 各データ構造定義

### 1. THorseSessions

HTTPリクエスト処理中にセッションデータを一時的に保持するためのコンテナクラス。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| FSessions | TObjectDictionary<TSessionClass, TSession> | 不可 | セッションクラスをキーとしたセッションインスタンスの辞書 |

**関連ソース**: `src/Horse.Session.pas`

### 2. THorseCoreParam

HTTPリクエストのパラメータを管理するクラス。クエリパラメータ、ヘッダ、ボディフィールド等を統一的に扱う。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| FParams | TDictionary<string, string> | 不可 | キーバリュー形式のパラメータ辞書 |
| FFiles | TDictionary<String, TStream> | 可 | アップロードされたファイルストリーム |
| FFields | TDictionary<string, THorseCoreParamField> | 可 | パラメータフィールドのキャッシュ |
| FContent | TStrings | 可 | パラメータを文字列リストとして表現 |
| FRequired | Boolean | 不可 | パラメータの必須フラグ |

**関連ソース**: `src/Horse.Core.Param.pas`

### 3. THorseRouterTree

ルーティング情報を木構造で管理するクラス。URLパスの各セグメントをノードとして保持。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| FPrefix | string | 可 | ルーティングプレフィックス |
| FPart | string | 可 | 現在のパスセグメント |
| FTag | string | 可 | パラメータキー名（:param形式の場合） |
| FIsParamsKey | Boolean | 不可 | パラメータキーかどうかのフラグ |
| FRouterRegex | string | 可 | 正規表現パターン |
| FIsRouterRegex | Boolean | 不可 | 正規表現ルートかどうかのフラグ |
| FIsInitialized | Boolean | 不可 | 初期化済みフラグ |
| FMiddleware | TList<THorseCallback> | 不可 | ミドルウェアコールバックのリスト |
| FRegexedKeys | TList<string> | 不可 | 正規表現キーのリスト |
| FCallBack | TObjectDictionary<TMethodType, TList<THorseCallback>> | 不可 | HTTPメソッド別コールバック辞書 |
| FRoute | TObjectDictionary<string, THorseRouterTree> | 不可 | 子ルートの辞書 |

**関連ソース**: `src/Horse.Core.RouterTree.pas`

### 4. THorseModule

フレームワークのモジュール設定を保持するレコード型。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| FSelfInstance | PHorseCore | 不可 | 自身のHorseCoreインスタンスへのポインタ |
| FDefaultHorseCoreInstance | PHorseCore | 不可 | デフォルトHorseCoreインスタンスへのポインタ |
| FHorseRouterTree | PHorseRouterTree | 不可 | ルーターツリーへのポインタ |

**関連ソース**: `src/Horse.Core.pas`

### 5. THorseRequest

HTTPリクエスト情報を保持するクラス。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| FWebRequest | TRequest/TWebRequest | 不可 | 元のWebリクエストオブジェクト |
| FHeaders | THorseCoreParam | 可 | HTTPヘッダパラメータ |
| FQuery | THorseCoreParam | 可 | クエリパラメータ |
| FParams | THorseCoreParam | 可 | URLパスパラメータ |
| FContentFields | THorseCoreParam | 可 | フォームコンテンツフィールド |
| FCookie | THorseCoreParam | 可 | クッキーパラメータ |
| FBody | TObject | 可 | リクエストボディのパース済みオブジェクト |
| FSession | TObject | 可 | セッションオブジェクト |
| FSessions | THorseSessions | 不可 | セッションコンテナ |

**関連ソース**: `src/Horse.Request.pas`

### 6. THorseResponse

HTTPレスポンス情報を保持するクラス。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| FWebResponse | TResponse/TWebResponse | 不可 | 元のWebレスポンスオブジェクト |
| FContent | TObject | 可 | レスポンスコンテンツオブジェクト |

**関連ソース**: `src/Horse.Response.pas`

## 列挙型定義

### TMethodType (FPC環境)

HTTPメソッドを表す列挙型。

| 値 | 説明 |
| --- | --- |
| mtAny | 任意のメソッド |
| mtGet | GET |
| mtPut | PUT |
| mtPost | POST |
| mtHead | HEAD |
| mtDelete | DELETE |
| mtPatch | PATCH |

**関連ソース**: `src/Horse.Commons.pas`

### THTTPStatus

HTTPステータスコードを表す列挙型。

| 値 | コード | 説明 |
| --- | --- | --- |
| Continue | 100 | 処理継続 |
| OK | 200 | 成功 |
| Created | 201 | リソース作成成功 |
| NoContent | 204 | コンテンツなし |
| BadRequest | 400 | 不正なリクエスト |
| Unauthorized | 401 | 認証が必要 |
| Forbidden | 403 | アクセス禁止 |
| NotFound | 404 | リソースが見つからない |
| InternalServerError | 500 | サーバー内部エラー |

（その他多数のステータスコードは`src/Horse.Commons.pas`を参照）

**関連ソース**: `src/Horse.Commons.pas`

### TMimeTypes

MIMEタイプを表す列挙型。

| 値 | 文字列表現 | 説明 |
| --- | --- | --- |
| MultiPartFormData | multipart/form-data | マルチパートフォーム |
| ApplicationXWWWFormURLEncoded | application/x-www-form-urlencoded | URLエンコードフォーム |
| ApplicationJSON | application/json | JSON形式 |
| ApplicationOctetStream | application/octet-stream | バイナリデータ |
| TextPlain | text/plain | プレーンテキスト |
| TextHTML | text/html | HTML |

（その他多数のMIMEタイプは`src/Horse.Commons.pas`を参照）

**関連ソース**: `src/Horse.Commons.pas`

## 備考

### データベース未使用の理由

Horseは軽量なWebフレームワークとして設計されており、以下の理由からデータベース機能を内蔵していません：

1. **単一責任の原則**: HTTPルーティングとミドルウェア処理に特化
2. **柔軟性**: アプリケーション開発者が任意のデータベースライブラリを選択可能
3. **軽量性**: 不要な依存関係を排除してフレームワークを軽量に保つ

### データ永続化について

アプリケーションでデータ永続化が必要な場合は、以下のサードパーティライブラリとの組み合わせが推奨されます：

- FireDAC（Delphi標準）
- UniDAC
- ZeosLib
- mORMot
- その他のDelphiデータベースライブラリ

### メモリ内データのライフサイクル

| データ構造 | ライフサイクル | 備考 |
| --- | --- | --- |
| THorseSessions | リクエスト単位 | 各リクエストで新規作成され、レスポンス後に破棄 |
| THorseCoreParam | リクエスト単位 | THorseRequestと共に生成・破棄 |
| THorseRouterTree | アプリケーション全体 | アプリケーション起動時に構築、終了時に破棄 |
| THorseModule | アプリケーション全体 | シングルトンとして管理 |
