---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な目標値の定義がプロジェクト内に存在しない（READMEの実績値を引用）
  2. **不具合管理方法**：GitHub Issue使用は推測であり、明示的な記載なし
  3. **性能・セキュリティテスト**：手動実施の推測、明示的なテスト計画なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/tests.yml` - GitHub Actions CI設定
- E-02: `tests/src/Console.dpr` - Consoleテストプロジェクト
- E-03: `tests/src/VCL.dpr` - VCLテストプロジェクト
- E-04: `tests/src/DUnitX.groupproj` - テストプロジェクトグループ
- E-05: `tests/src/boss.json` - テスト用依存管理（RESTRequest4D, Jhonson）
- E-06: `tests/src/tests/Tests.Api.Console.pas` - APIテスト（Console）
- E-07: `tests/src/tests/Tests.Api.Vcl.pas` - APIテスト（VCL）
- E-08: `tests/src/tests/Tests.Commons.pas` - 共通ユーティリティテスト
- E-09: `tests/src/tests/Tests.Horse.Core.Param.pas` - パラメータ処理テスト
- E-10: `tests/src/tests/Tests.Horse.Core.Files.pas` - ファイル操作テスト
- E-11: `tests/code-coverage/dcov_execute_console.bat` - カバレッジ実行スクリプト
- E-12: `tests/code-coverage/dcov_units.lst` - カバレッジ対象ユニット一覧
- E-13: `tests/code-coverage/dcov_paths.lst` - カバレッジ対象パス設定
- E-14: `README.md` - プロジェクト概要・カバレッジ実績値

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DUnitXテストフレームワークを使用 | E-02, E-03, E-06, E-07 | ○ |
| C-02 | GitHub Actionsによる継続的インテグレーション | E-01 | ○ |
| C-03 | Console/VCL両環境でのテスト実行 | E-01, E-02, E-03, E-04 | ○ |
| C-04 | HTTPメソッド（GET/POST/PUT/DELETE）テスト | E-06, E-07 | ○ |
| C-05 | パラメータ変換テスト | E-09 | ○ |
| C-06 | MIMEタイプ処理テスト | E-08 | ○ |
| C-07 | ファイル操作テスト | E-10 | ○ |
| C-08 | RESTRequest4D v2.2.6使用 | E-05 | ○ |
| C-09 | Jhonson ^1.1.1使用 | E-05 | ○ |
| C-10 | code-coverage.exeによるカバレッジ計測 | E-11, E-12, E-13 | ○ |
| C-11 | Console環境カバレッジ45% | E-14 | ○ |
| C-12 | VCL環境カバレッジ43% | E-14 | ○ |
| C-13 | カバレッジ目標値の明示的定義 | **根拠なし** | △ |
| C-14 | NUnit XML形式でテストレポート出力 | E-02, E-03 | ○ |
| C-15 | メモリリーク検出有効化 | E-02, E-03 | ○ |
| C-16 | TestCase属性によるパラメータ化テスト | E-09 | ○ |
| C-17 | Setup/TearDownによるテストフィクスチャ管理 | E-09, E-10 | ○ |
| C-18 | masterブランチへのpush/PR時にCI実行 | E-01 | ○ |
| C-19 | windows-latest環境でCI実行 | E-01 | ○ |
| C-20 | actions/checkout@v2使用 | E-01 | ○ |
| C-21 | TestInsight統合（オプション） | E-02, E-03 | ○ |
| C-22 | 不具合管理にGitHub Issue使用 | **根拠なし** | △ |
| C-23 | 性能テストは手動実施 | **根拠なし** | △ |
| C-24 | MaxConnections設定の動作確認テスト | E-06, E-07 | ○ |
| C-25 | SSL対応（VCL-SSL）テスト存在 | E-02（VCL.dprにProviderIOHandleSSL参照あり） | ○ |

## 4) 不足情報（Unknown / Missing）
- **カバレッジ目標値の定義文書**
  - 現状：READMEに実績値（45%/43%）のみ記載
  - 候補：テスト計画書 / プロジェクト要件定義 / CONTRIBUTING.md
- **不具合管理プロセスの定義**
  - 現状：明示的な不具合管理プロセスの記載なし
  - 候補：CONTRIBUTING.md / Issue テンプレート / プロジェクトWiki
- **性能・セキュリティテスト計画**
  - 現状：対応するソースコード（SSL, MaxConnections）は存在するが、テスト計画文書なし
  - 候補：テスト計画書 / 性能要件定義書

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - DUnitX使用、CI/CD連携、テストコード構造
- **1: 中リスク** - カバレッジ目標値（実績値を引用、目標として適切か要確認）
- **1: 中リスク** - 性能・セキュリティテストの実施状況（明示的な計画なし）
- **2: 高リスク** - 該当なし

## 6) レビュアーチェックリスト（最小）
- [ ] カバレッジ目標値45%/43%が組織の品質基準を満たしているか確認
- [ ] 不具合管理プロセスが実際に運用されているか確認（GitHub Issuesの使用状況）
- [ ] 性能・セキュリティテストの実施頻度・方法が適切か確認
- [ ] CI/CDパイプラインで事前ビルド済みexeを使用する運用が適切か確認
- [ ] テストケース数（特にパラメータ処理の60+テスト）の網羅性確認
