# テスト方針書

## 概要

本ドキュメントは、Horse Webフレームワークプロジェクトのテスト方針を定義する。HorseはDelphi/Lazarus向けのExpressインスパイアWebフレームワークであり、DUnitXテストフレームワークを使用した自動テストとGitHub Actionsによる継続的インテグレーションを実施している。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のコンポーネント（パラメータ処理、ファイル操作、共通ユーティリティ）の機能検証 | 開発者 |
| 結合テスト | APIエンドポイントの統合動作検証（HTTPリクエスト/レスポンス処理） | 開発者 |
| システムテスト | Console/VCL両環境でのフレームワーク全体動作確認 | 開発者/QA |
| 受入テスト | 実際のWebアプリケーション開発シナリオでの動作確認 | 利用者/コミュニティ |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | HTTPメソッド（GET/POST/PUT/DELETE）、パラメータ変換、MIMEタイプ処理等の検証 | 開発時・CI実行時 |
| 性能テスト | MaxConnections設定の動作確認 | 開発時（手動） |
| セキュリティテスト | SSL対応（VCL-SSL）の動作確認 | 開発時（手動） |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発中のテスト実行 | Delphi IDE + DUnitX + Windows |
| GitHub Actions (CI) | 自動テスト実行 | windows-latest + Console.exe / VCL.exe |
| コードカバレッジ環境 | カバレッジ計測 | code-coverage.exe + Windows |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| DUnitX | Delphiユニットテストフレームワーク | テストフレームワーク本体（バージョン明示なし） |
| RESTRequest4D | HTTPリクエストテスト用ライブラリ | v2.2.6 (boss依存管理) |
| Jhonson | JSONパース用ライブラリ | ^1.1.1 (boss依存管理) |
| code-coverage.exe | Delphiコードカバレッジ計測ツール | カバレッジHTML出力対応 |
| GitHub Actions | CI/CD自動化 | actions/checkout@v2 |
| TestInsight | IDE統合テスト実行（オプション） | TESTINSIGHT定義による有効化 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| Console環境カバレッジ | 45%（現状実績値） |
| VCL環境カバレッジ | 43%（現状実績値） |

注：README.mdに記載の実績値に基づく。明示的な目標値の定義はプロジェクト内に存在しない。

## テストデータ

### テストデータの準備方針

- **HTTPリクエストデータ**: テストコード内でJSON文字列として直接定義
  - 例：`'{"value": "POST request test"}'`
- **パラメータテストデータ**: DUnitXのTestCase属性を使用したパラメータ化テスト
  - 例：`[TestCase('TrueValue1', 'True,true,true')]`
- **ファイルテストデータ**: プロジェクト内の実ファイル（`src/Horse.pas`）を使用
- **ストリームテストデータ**: TStringStreamを使用した動的生成

### テストフィクスチャ

- `Setup`プロシージャでテストデータの初期化
- `TearDown`プロシージャでリソースの解放（メモリリーク検出有効：`ReportMemoryLeaksOnShutdown := True`）

## 不具合管理

- **不具合追跡**: GitHubのIssue機能を使用（推測：明示的な記載なし）
- **テスト失敗時の動作**:
  - CI環境では`System.ExitCode := EXIT_ERRORS`でビルド失敗を通知
  - `Assert.Fail`メソッドによる明示的なテスト失敗
  - `Assert.WillRaiseWithMessage`による例外検証

## CI/CD連携

### GitHub Actions設定

```yaml
name: tests

on:
  push:
    branches: [ master ]
  pull_request:
    branches: [ master ]

jobs:
  test:
    runs-on: windows-latest
    steps:
    - uses: actions/checkout@v2
    - name: Launch Console Tests
      run: ./tests/Console.exe
    - name: Launch VCL Tests
      run: ./tests/VCL.exe
```

### CI/CDパイプラインの特徴

- **トリガー**: masterブランチへのpush/pull_request時に自動実行
- **実行環境**: Windows最新版（windows-latest）
- **テスト実行**: 事前ビルド済みのConsole.exeとVCL.exeを順次実行
- **テストレポート**: NUnit XML形式で出力（`TDUnitXXMLNUnitFileLogger`使用）

### コードカバレッジ計測

- `tests/code-coverage/`ディレクトリにカバレッジ設定を配置
- `dcov_execute_console.bat`および`dcov_execute_vcl.bat`でローカル実行
- HTML形式でカバレッジレポートを出力

## 備考

### テスト対象ユニット一覧

カバレッジ対象として定義されているユニット（`dcov_units.lst`より）：
- Horse.Commons
- Horse.Constants
- Horse.Core.Group / Horse.Core.Group.Contract
- Horse.Core / Horse.Core.Route / Horse.Core.Route.Contract
- Horse.Core.RouterTree
- Horse.Exception
- Horse.HTTP / Horse
- Horse.Provider.Abstract / Apache / CGI / Console / Daemon / VCL / ISAPI
- Horse.WebModule / Horse.Proc

### テストプロジェクト構成

| プロジェクト | 説明 |
| --- | --- |
| Console.dpr | コンソールアプリケーション用テストスイート |
| VCL.dpr | VCLアプリケーション用テストスイート |
| DUnitX.groupproj | テストプロジェクトグループ（Console + VCL） |

### テストケース概要

| テストファイル | 対象 | テストケース数 |
| --- | --- | --- |
| Tests.Api.Console.pas | API統合テスト（Console環境） | 7テスト |
| Tests.Api.Vcl.pas | API統合テスト（VCL環境） | 7テスト |
| Tests.Commons.pas | MIMEタイプ変換 | 1テスト |
| Tests.Horse.Core.Param.pas | パラメータ処理 | 60+テスト |
| Tests.Horse.Core.Files.pas | ファイル操作 | 3テスト |
