---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 4
  claims_with_evidence: 4
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：4 / 4、根拠なし：0
- 優先レビュー（高）
  - 該当なし（すべてのClaimに根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/delphi/daemon/Daemon.dpr` - Delphi Daemonサンプルプログラム
- E-02: `src/Horse.Provider.Daemon.pas` - Delphiデーモンプロバイダー実装
- E-03: `samples/delphi/winsvc/WinSvc.dpr` - Delphi Windows Serviceサンプルプログラム
- E-04: `samples/delphi/winsvc/src/Main.Service.pas` - Delphi Windows Serviceメインユニット
- E-05: `samples/lazarus/daemon/daemon.lpr` - FPC Daemonサンプルプログラム
- E-06: `src/Horse.Provider.FPC.Daemon.pas` - FPCデーモンプロバイダー実装
- E-07: `samples/lazarus/winsvc/WinSvc.lpr` - FPC Windows Serviceサンプルプログラム
- E-08: `samples/lazarus/winsvc/daemonmain.pas` - FPC Windows Serviceメインユニット
- E-09: `samples/lazarus/winsvc/daemonmanager.pas` - FPC Daemonマネージャーユニット

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Delphi Daemon: POSIX環境向けのバックグラウンドデーモンプロセス。fork()によるプロセス分離とシグナルハンドリング（SIGTERM/SIGHUP）を実装 | E-01, E-02 | ○ |
| C-02 | Delphi WinSvc: Windows Service（TService）としてHTTPサーバーを実行。ServiceStart/ServiceStopイベントでHorseサーバーの開始・停止を制御 | E-03, E-04 | ○ |
| C-03 | FPC Daemon: Free Pascal環境向けのバックグラウンドデーモン。THTTPServerThreadによるマルチスレッドHTTPサーバーを実装 | E-05, E-06 | ○ |
| C-04 | FPC WinSvc: Free Pascal環境向けのWindows Service。DaemonAppフレームワークを使用し、TDaemon_Mainクラスでサービスライフサイクルを管理 | E-07, E-08, E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。すべてのClaimについてソースコードによる根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのバッチ/デーモン情報はソースコードから直接抽出されており、実装との整合性が確認されています。

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ/デーモンの分類（デーモン/Windowsサービス）が正しいか確認
- [ ] 各バッチの説明がソースコードの実装内容と一致しているか確認
- [ ] 備考欄の参照ファイルパスが正しいか確認
- [ ] HORSE_DAEMONコンパイルディレクティブの必要性が正しく記載されているか確認
