# バッチ設計書 1-Delphi Daemon

## 概要

本ドキュメントは、Delphi環境向けPOSIXバックグラウンドデーモンプロセスの設計仕様を記載したバッチ設計書です。Horseフレームワークを使用したHTTPサーバーをデーモンとして常駐実行するための仕組みを定義します。

### 本バッチの処理概要

本バッチは、POSIX環境（Linux/macOS等）上でDelphiアプリケーションをバックグラウンドデーモンプロセスとして動作させるための実装です。Horseフレームワークを活用し、RESTful HTTPサーバーをデーモン化して常駐実行させます。

**業務上の目的・背景**：Webアプリケーションやマイクロサービスをサーバー上で継続的に稼働させる必要がある場合に、プロセスをデーモン化することでターミナルセッション終了後も処理を継続できます。特にPOSIX準拠のUnix系OS上で、Delphiで開発されたHTTPサーバーを本番運用する際に必要となる基盤機能を提供します。

**バッチの実行タイミング**：システム起動時またはオペレーターによる手動起動時。デーモンとして常駐するため、一度起動すると明示的に停止されるまで継続実行されます。

**主要な処理内容**：
1. HORSE_DAEMONコンパイルディレクティブを有効化してデーモンモードでビルド
2. fork()によるプロセス分離でバックグラウンドプロセス化
3. シグナルハンドリング（SIGTERM/SIGHUP）の設定
4. THorseインスタンスの初期化とルーティング設定（/ping エンドポイント）
5. THorse.Listenによるデフォルトポートでのリクエスト待ち受け開始

**前後の処理との関連**：本デーモンは独立したサービスとして動作し、前提となるバッチは存在しません。ただし、OS起動スクリプト（systemd、init.d等）から呼び出されることを想定しています。

**影響範囲**：本デーモンが使用するポート（デフォルト9000番）へのHTTPリクエストを処理します。同一ポートを使用する他のサービスとは競合する可能性があります。

## バッチ種別

常駐デーモン / HTTPサービス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 常駐（システム起動時に1回起動） |
| 実行時刻 | システム起動時または手動起動時 |
| 実行曜日 | 該当なし（常駐） |
| 実行日 | 該当なし（常駐） |
| トリガー | システム起動 / 手動起動 / systemd等 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| POSIX環境 | Linux、macOS等のPOSIX準拠OSが必要 |
| HORSE_DAEMONディレクティブ | コンパイル時にHORSE_DAEMONを定義する必要あり |
| ポート利用可能 | デフォルトポート（9000番等）が他プロセスに使用されていないこと |

### 実行可否判定

- 指定ポートが利用可能であること
- 必要なライブラリ（Horse）が正しくリンクされていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ポート番号 | Integer | No | 9000 | リッスンするポート番号 |
| ホスト | String | No | 0.0.0.0 | バインドするホストアドレス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| HTTPリクエスト | HTTP | クライアントからのHTTPリクエスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| HTTPレスポンス | HTTP | クライアントへのHTTPレスポンス |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. プログラム起動
   └─ HORSE_DAEMONディレクティブによりデーモンモードで起動
2. ルーティング設定
   └─ THorse.Get('/ping', ...) でエンドポイント登録
3. サーバー起動
   └─ THorse.Listen でHTTPサーバー開始
4. リクエスト待ち受け
   └─ 無限ループでHTTPリクエストを処理
5. シグナル受信時
   └─ SIGTERM/SIGHUPで適切にシャットダウン
```

### フローチャート

```mermaid
flowchart TD
    A[デーモン起動] --> B[ルーティング設定]
    B --> C[THorse.Get 登録]
    C --> D[THorse.Listen]
    D --> E{リクエスト受信}
    E -->|/ping| F[pong レスポンス]
    F --> E
    E -->|SIGTERM| G[サーバー停止]
    G --> H[デーモン終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EADDRINUSE | ポート競合 | 指定ポートが既に使用中 | 他プロセスを停止するか別ポートを指定 |
| EACCES | 権限エラー | 特権ポート（1024未満）を使用 | sudo実行または非特権ポートを使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（サーバー起動失敗時は即終了） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ログを確認しエラー原因を特定
2. ポート競合の場合は競合プロセスを特定し停止
3. 権限エラーの場合は実行ユーザーの権限を確認
4. デーモンを再起動

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（DB操作なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 制限なし（常駐サービス） |
| 目標処理時間 | リクエストあたり100ms以下 |
| メモリ使用量上限 | 256MB以下 |

## 排他制御

- 同一ポートでの複数インスタンス起動は不可
- PIDファイルによる二重起動防止を推奨

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | デーモン起動時 | 起動完了メッセージ、リッスンポート |
| 進捗ログ | リクエスト処理時 | アクセスログ（任意設定） |
| 終了ログ | デーモン終了時 | 終了メッセージ |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| プロセス死活 | 停止検知 | 運用担当者 |
| レスポンス時間 | 5秒以上 | 運用担当者 |

## 備考

- 本バッチはサンプル実装であり、実運用時には適切なログ出力・監視設定の追加が推奨される
- ソースファイル: `samples/delphi/daemon/Daemon.dpr`
- コンパイル時にHORSE_DAEMONディレクティブを定義する必要がある
