# バッチ設計書 3-FPC Daemon

## 概要

本ドキュメントは、Free Pascal（Lazarus）環境向けバックグラウンドデーモンの設計仕様を記載したバッチ設計書です。対話式コマンド制御機能を備えたHTTPサーバーをデーモンとして実行するための仕組みを定義します。

### 本バッチの処理概要

本バッチは、Free Pascal（Lazarus）環境でHorseフレームワークを活用したHTTPサーバーをデーモンプロセスとして動作させる実装です。START/STOP/TERMINATEコマンドによるコンソール操作でサーバーの起動・停止を制御できるインタラクティブなデーモンを提供します。

**業務上の目的・背景**：Free Pascal/Lazarus環境でWebアプリケーションやAPIサーバーを開発・運用する際に、デーモン化によるバックグラウンド実行が必要となります。本バッチは、開発時のデバッグや運用時の柔軟な制御を可能にするコマンドインターフェースを備えたデーモン実装を提供します。また、HORSE_DAEMONディレクティブを有効化することで、完全なバックグラウンドデーモンとして動作させることも可能です。

**バッチの実行タイミング**：開発環境ではコンソールから手動起動、本番環境ではシステム起動時に起動スクリプト経由で実行されます。STARTコマンドでHTTPサーバーを開始し、TERMINATE（またはSIGTERM）で終了します。

**主要な処理内容**：
1. HORSE_DAEMONコンパイルディレクティブの設定（本番デーモンモード時）
2. THorse.Get('/ping', @GetPing)によるルーティング設定
3. メインループでコマンド入力待ち（START/STOP/TERMINATE）
4. STARTコマンド：THorse.Listen(9000, @OnListen)でポート9000でHTTPサーバー開始
5. STOPコマンド：THorse.StopListenでHTTPサーバー一時停止
6. TERMINATEコマンド：メインループ終了によるプログラム終了
7. OnListenコールバックでサーバー状態をコンソール出力

**前後の処理との関連**：独立したサービスとして動作し、前提となるバッチはありません。Unix系OSではinit.d/systemd等から起動することを想定しています。

**影響範囲**：ポート9000（設定可能）へのHTTPリクエストを処理します。同一ポートを使用する他のサービスとは競合する可能性があります。

## バッチ種別

対話式デーモン / HTTPサービス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 常駐（手動起動後、コマンドで制御） |
| 実行時刻 | 手動起動時またはシステム起動時 |
| 実行曜日 | 該当なし（常駐） |
| 実行日 | 該当なし（常駐） |
| トリガー | 手動起動 / システム起動スクリプト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| POSIX環境 | Linux、macOS等のPOSIX準拠OS（cthreadsサポート） |
| HORSE_DAEMONディレクティブ | 完全デーモンモード時はコンパイル時に定義が必要 |
| ポート9000利用可能 | デフォルトポート9000が他プロセスに使用されていないこと |

### 実行可否判定

- 指定ポートが利用可能であること
- Horseライブラリが正しくリンクされていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ポート番号 | Integer | No | 9000 | リッスンするポート番号（コード内定数） |
| コマンド | String | Yes | - | START/STOP/TERMINATE |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 標準入力 | テキスト | コマンド入力（START/STOP/TERMINATE） |
| HTTPリクエスト | HTTP | クライアントからのHTTPリクエスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | サーバー状態メッセージ |
| HTTPレスポンス | HTTP | クライアントへのHTTPレスポンス |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. プログラム起動
   └─ 初期化、ルーティング設定
2. THorse.Get('/ping', @GetPing)
   └─ /pingエンドポイント登録
3. コマンドプロンプト表示
   └─ "COMMANDS: START, STOP, TERMINATE"
4. コマンド入力待ちループ
   └─ ReadLn(sCMD) でコマンド読み取り
5. STARTコマンド処理
   └─ THorse.Listen(9000, @OnListen) でサーバー起動
6. STOPコマンド処理
   └─ THorse.StopListen でサーバー停止
7. TERMINATEコマンド処理
   └─ bTerminated := True でループ終了
8. プログラム終了
```

### フローチャート

```mermaid
flowchart TD
    A[プログラム起動] --> B[ルーティング設定]
    B --> C[コマンド表示]
    C --> D{コマンド入力待ち}
    D -->|START| E[THorse.Listen 9000]
    E --> F[OnListen コールバック]
    F --> D
    D -->|STOP| G[THorse.StopListen]
    G --> D
    D -->|TERMINATE| H[bTerminated = True]
    H --> I[プログラム終了]
    E --> J{HTTPリクエスト}
    J -->|/ping| K[pong レスポンス]
    K --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EADDRINUSE | ポート競合 | ポート9000が既に使用中 | 他プロセスを停止するかポート番号を変更 |
| EACCES | 権限エラー | 特権ポート使用時 | sudo実行または非特権ポートを使用 |
| 不正コマンド | 入力エラー | 未定義コマンド入力 | 無視して次のコマンド待ち |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（コマンド再入力で対応） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. コンソール出力でエラー状態を確認
2. ポート競合の場合は競合プロセスを特定し停止
3. STOPコマンド後に再度STARTコマンドを実行
4. 必要に応じてプログラムを再起動

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（DB操作なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 制限なし（常駐サービス） |
| 目標処理時間 | リクエストあたり100ms以下 |
| メモリ使用量上限 | 256MB以下 |

## 排他制御

- 同一ポートでの複数インスタンス起動は不可
- THorse.IsRunningプロパティでサーバー状態を確認可能

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | STARTコマンド実行時 | "Server is running on {host}:{port}" |
| 停止ログ | STOPコマンド実行時 | "Server stopped" |
| 終了ログ | TERMINATEコマンド実行時 | プログラム終了 |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| プロセス死活 | 停止検知 | 運用担当者 |
| レスポンス時間 | 5秒以上 | 運用担当者 |

## 備考

- 本バッチはサンプル実装であり、実運用時には適切なログ出力・監視設定の追加が推奨される
- ソースファイル: `samples/lazarus/daemon/daemon.lpr`
- コンパイル時にHORSE_DAEMONディレクティブを定義することで完全デーモンモードで動作
- UNIX環境ではUseCThreadsディレクティブでcthreadsを有効化可能
