# バッチ設計書 4-FPC WinSvc

## 概要

本ドキュメントは、Free Pascal（Lazarus）環境向けWindows Serviceの設計仕様を記載したバッチ設計書です。DaemonAppフレームワークを使用し、TDaemon_MainクラスでWindowsサービスとしてのライフサイクルを管理するHTTPサーバーの仕組みを定義します。

### 本バッチの処理概要

本バッチは、Free Pascal/LazarusのDaemonAppフレームワークを活用してWindows ServiceとしてHTTPサーバーを実装します。TDaemonクラスを継承したTDaemon_Mainにより、Windowsサービスとしてのライフサイクル管理（作成・開始・シャットダウン）を行い、HorseフレームワークによるHTTPサーバー機能をマルチスレッドで提供します。

**業務上の目的・背景**：Free Pascal/Lazarus環境でも、Windows Server上で安定的にHTTPサーバーやWebアプリケーションを運用するためには、Windowsサービスとして登録・管理することが求められます。本バッチは、Lazarusで開発されたHTTPサーバーをWindowsサービス化し、サーバー再起動時の自動起動、サービス管理コンソールからの一元管理、イベントログへの記録といったWindows標準の運用管理機能を活用可能にする基盤を提供します。

**バッチの実行タイミング**：Windowsサービスとして登録後、システム起動時に自動起動（自動起動設定の場合）、または手動起動。Service Control Manager（services.msc）やコマンドラインから制御されます。

**主要な処理内容**：
1. Application.Initializeによるアプリケーション初期化
2. DaemonManagerによるデーモンマッパー登録（RegisterDaemonMapper）
3. TDaemon_Mainのインスタンス生成とデーモンクラス登録（RegisterDaemonClass）
4. DataModuleCreateイベントでルーティング設定（THorse.Get）
5. DataModuleStartイベントでTThread.CreateAnonymousThread(@RunHorse).StartによりHTTPサーバーを別スレッドで開始
6. DataModuleShutDownイベントでTHorse.StopListenによりHTTPサーバー停止

**前後の処理との関連**：独立したサービスとして動作し、前提となるバッチはありません。Windowsのサービス依存関係設定により、他サービスへの依存を設定可能です。

**影響範囲**：ポート9000（設定可能）へのHTTPリクエストを処理します。Windowsファイアウォール設定、ネットワーク構成に影響を受けます。

## バッチ種別

Windowsサービス / HTTPサービス

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 常駐（サービス登録後、自動または手動起動） |
| 実行時刻 | システム起動時（自動起動の場合）または手動 |
| 実行曜日 | 該当なし（常駐） |
| 実行日 | 該当なし（常駐） |
| トリガー | Windows SCM / net start / sc start |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows 7以降、Windows Server 2008 R2以降 |
| サービス登録 | 事前にサービスとしてインストールが必要 |
| 管理者権限 | サービス登録・制御には管理者権限が必要 |
| ポート利用可能 | ポート9000がファイアウォールで許可されていること |

### 実行可否判定

- サービスがWindowsに正しく登録されていること
- 指定ポートが利用可能であること
- 実行ユーザー（サービスアカウント）に適切な権限があること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ポート番号 | Integer | No | 9000 | リッスンするポート番号（コード内定数） |
| ホスト | String | No | 0.0.0.0 | バインドするホストアドレス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| HTTPリクエスト | HTTP | クライアントからのHTTPリクエスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| HTTPレスポンス | HTTP | クライアントへのHTTPレスポンス |
| Windowsイベントログ | EventLog | サービス状態変更等のログ |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. サービス起動要求
   └─ Windows SCMからの起動シグナル受信
2. Application.Initialize
   └─ lazdaemonappの初期化
3. RegisterDaemonMapper
   └─ TDaemon_Managerの登録
4. RegisterDaemonClass
   └─ TDaemon_Mainの登録
5. DataModuleCreateイベント
   └─ THorse.Get('ping', @Ping) ルーティング設定
6. DataModuleStartイベント
   └─ TThread.CreateAnonymousThread(@RunHorse).Start
   └─ 別スレッドでTHorse.Listen(9000)実行
7. Application.Run
   └─ サービスメインループ（リクエスト処理）
8. DataModuleShutDownイベント（停止要求時）
   └─ THorse.StopListen でサーバー停止
```

### フローチャート

```mermaid
flowchart TD
    A[SCMから起動要求] --> B[Application.Initialize]
    B --> C[RegisterDaemonMapper]
    C --> D[RegisterDaemonClass]
    D --> E[DataModuleCreate]
    E --> F[ルーティング設定]
    F --> G[DataModuleStart]
    G --> H[別スレッド起動]
    H --> I[THorse.Listen 9000]
    I --> J{サービス実行中}
    J -->|HTTPリクエスト| K[リクエスト処理 /ping]
    K --> J
    J -->|停止要求| L[DataModuleShutDown]
    L --> M[THorse.StopListen]
    M --> N[サービス終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行いません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | - |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1053 | サービス応答なし | 起動タイムアウト | サービス起動処理の見直し |
| 1067 | プロセス異常終了 | 内部エラー発生 | イベントログ確認、デバッグ |
| EADDRINUSE | ポート競合 | ポート9000が既に使用中 | 競合プロセス停止または別ポート使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | SCM設定に依存（回復オプション） |
| リトライ間隔 | SCM設定に依存 |
| リトライ対象エラー | サービス異常終了 |

### 障害時対応

1. Windowsイベントログでエラー詳細を確認
2. サービスの回復オプション設定を確認
3. ポート競合の場合は競合プロセスを特定
4. サービスを手動で再起動

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（DB操作なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 制限なし（常駐サービス） |
| 目標処理時間 | リクエストあたり100ms以下 |
| メモリ使用量上限 | 256MB以下 |

## 排他制御

- 同一サービス名での複数インスタンス起動は不可（SCMにより制御）
- 同一ポートでの複数プロセス起動は不可

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サービス起動時 | Windowsイベントログに起動記録 |
| 進捗ログ | リクエスト処理時 | アクセスログ（任意設定） |
| 終了ログ | サービス停止時 | Windowsイベントログに停止記録 |
| エラーログ | エラー発生時 | Windowsイベントログにエラー記録 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| サービス状態 | 停止検知 | 運用担当者 |
| レスポンス時間 | 5秒以上 | 運用担当者 |
| イベントログエラー | エラー発生 | 運用担当者 |

## 備考

- 本バッチはサンプル実装であり、実運用時には適切なログ出力・監視設定の追加が推奨される
- ソースファイル:
  - `samples/lazarus/winsvc/WinSvc.lpr` - メインプログラム
  - `samples/lazarus/winsvc/daemonmain.pas` - デーモンメイン実装
  - `samples/lazarus/winsvc/daemonmanager.pas` - デーモンマネージャ実装
- DaemonAppフレームワーク（lazdaemonapp）を使用
- HTTPサーバーは別スレッドで実行されるため、サービス開始時にブロックしない設計
- HORSE_DAEMONディレクティブをコンパイル時に定義することで完全デーモンモードで動作
