---
generated_at: 2026-01-22 18:16:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：2-Delphi WinSvc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（レスポンス時間）**：具体的な数値の根拠が不明
  2. **パフォーマンス要件（メモリ使用量）**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/delphi/winsvc/WinSvc.dpr` - メインプログラムファイル
- E-02: `samples/delphi/winsvc/src/Main.Service.pas` - サービス実装ファイル
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Windows Service（TService）として動作する | E-02 (行9), E-03 | ○ |
| C-02 | Vcl.SvcMgrを使用する | E-01 (行4), E-03 | ○ |
| C-03 | TMainServiceクラスがTServiceを継承 | E-02 (行9) | ○ |
| C-04 | ServiceCreateでルーティング設定 | E-02 (行36-43) | ○ |
| C-05 | ServiceStartでTHorse.Listen呼び出し | E-02 (行45-49) | ○ |
| C-06 | ServiceStopでTHorse.StopListen呼び出し | E-02 (行51-55) | ○ |
| C-07 | /pingエンドポイントがpongを返す | E-02 (行38-42) | ○ |
| C-08 | Started := Trueで起動完了通知 | E-02 (行48) | ○ |
| C-09 | Stopped := Trueで停止完了通知 | E-02 (行54) | ○ |
| C-10 | ServiceControllerプロシージャ実装 | E-02 (行26-29) | ○ |
| C-11 | GetServiceController関数実装 | E-02 (行31-34) | ○ |
| C-12 | Application.CreateFormでサービス生成 | E-01 (行26) | ○ |
| C-13 | Horseフレームワークを使用 | E-02 (行22) | ○ |
| C-14 | レスポンス時間100ms以下 | **根拠なし** | △ |
| C-15 | メモリ使用量256MB以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-14, C-15）の具体的数値はソースコード・設計書から読み取れない
  - 候補：運用要件定義書 / 性能試験結果 / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サービスライフサイクル管理の実装はソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値であり、実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceStart/ServiceStopイベントの動作を確認したか
- [ ] パフォーマンス要件の妥当性を検証したか
- [ ] Windowsサービス登録・アンインストール手順を確認したか
- [ ] サービスアカウントの権限設定を確認したか
- [ ] ファイアウォール設定を確認したか
