---
generated_at: 2026-01-22 18:17:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：3-FPC Daemon

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（レスポンス時間）**：具体的な数値の根拠が不明
  2. **パフォーマンス要件（メモリ使用量）**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/lazarus/daemon/daemon.lpr` - メインソースファイル
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Free Pascal（Lazarus）環境向けデーモン | E-02 | ○ |
| C-02 | HORSE_DAEMONコンパイルディレクティブが必要 | E-01 (行28), E-02 | ○ |
| C-03 | THorse.Get('/ping', @GetPing)でルーティング設定 | E-01 (行29) | ○ |
| C-04 | START/STOP/TERMINATEコマンドで制御 | E-01 (行31, 35-39) | ○ |
| C-05 | STARTでTHorse.Listen(9000)呼び出し | E-01 (行36) | ○ |
| C-06 | STOPでTHorse.StopListen呼び出し | E-01 (行37) | ○ |
| C-07 | TERMINATEでbTerminated := True | E-01 (行38) | ○ |
| C-08 | GetPingプロシージャでpongを返す | E-01 (行11-14) | ○ |
| C-09 | OnListenコールバックでサーバー状態出力 | E-01 (行16-22) | ○ |
| C-10 | THorse.IsRunningでサーバー状態確認 | E-01 (行18, 20) | ○ |
| C-11 | ポート9000でリッスン | E-01 (行36) | ○ |
| C-12 | cthreadsを使用可能 | E-01 (行6-8) | ○ |
| C-13 | レスポンス時間100ms以下 | **根拠なし** | △ |
| C-14 | メモリ使用量256MB以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-13, C-14）の具体的数値はソースコード・設計書から読み取れない
  - 候補：運用要件定義書 / 性能試験結果 / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド制御機能はソースコードで確認可能
- 0: 低リスク - OnListenコールバックの動作もソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値であり、実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] START/STOP/TERMINATEコマンドの動作を確認したか
- [ ] パフォーマンス要件の妥当性を検証したか
- [ ] HORSE_DAEMONディレクティブ有無による動作差異を確認したか
- [ ] cthreadsの有効化条件を確認したか
- [ ] 本番環境での起動スクリプト設定を計画したか
