---
generated_at: 2026-01-22 18:18:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：4-FPC WinSvc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（レスポンス時間）**：具体的な数値の根拠が不明
  2. **パフォーマンス要件（メモリ使用量）**：具体的な数値の根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `samples/lazarus/winsvc/WinSvc.lpr` - メインプログラムファイル
- E-02: `samples/lazarus/winsvc/daemonmain.pas` - デーモンメイン実装
- E-03: `samples/lazarus/winsvc/daemonmanager.pas` - デーモンマネージャ実装
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Free Pascal（Lazarus）環境向けWindows Service | E-04 | ○ |
| C-02 | DaemonAppフレームワークを使用 | E-01 (行7), E-04 | ○ |
| C-03 | TDaemon_MainクラスがTDaemonを継承 | E-02 (行11) | ○ |
| C-04 | RegisterDaemonClassでデーモンクラス登録 | E-02 (行25-28) | ○ |
| C-05 | RegisterDaemonMapperでマッパー登録 | E-03 (行19-22) | ○ |
| C-06 | DataModuleCreateでルーティング設定 | E-02 (行43-46) | ○ |
| C-07 | DataModuleStartで別スレッドでサーバー起動 | E-02 (行53-56) | ○ |
| C-08 | DataModuleShutDownでTHorse.StopListen | E-02 (行48-51) | ○ |
| C-09 | TThread.CreateAnonymousThread使用 | E-02 (行55) | ○ |
| C-10 | RunHorseプロシージャでTHorse.Listen(9000) | E-02 (行30-34) | ○ |
| C-11 | Pingプロシージャでpongを返す | E-02 (行36-39) | ○ |
| C-12 | THorse.Get('ping', @Ping)でエンドポイント登録 | E-02 (行45) | ○ |
| C-13 | Application.InitializeとApplication.Run使用 | E-01 (行10-11) | ○ |
| C-14 | HORSE_DAEMONディレクティブが必要 | E-02 (行32) | ○ |
| C-15 | レスポンス時間100ms以下 | **根拠なし** | △ |
| C-16 | メモリ使用量256MB以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-15, C-16）の具体的数値はソースコード・設計書から読み取れない
  - 候補：運用要件定義書 / 性能試験結果 / システム設計書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - デーモンライフサイクル管理の実装はソースコードで確認可能
- 0: 低リスク - マルチスレッド実装もソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は推定値であり、実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] DataModuleCreate/Start/ShutDownイベントの動作を確認したか
- [ ] パフォーマンス要件の妥当性を検証したか
- [ ] マルチスレッド実装の安全性を確認したか
- [ ] DaemonAppフレームワークのサービス登録手順を確認したか
- [ ] ファイアウォール設定を確認したか
- [ ] HORSE_DAEMONディレクティブの影響を確認したか
