---
generated_at: 2026-01-22 18:55:00
metrics:
  claims_total: 55
  claims_with_evidence: 53
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：Horse.Commons 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：53 / 55、根拠なし：2
- 優先レビュー（高）
  1. **UT-CMN-045**：空文字テキストの境界値テスト - 期待結果が不明確
  2. **UT-CMN-055**：小文字入力時の挙動 - AnsiIndexTextの大文字小文字区別の実装詳細が要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Commons.pas` - メインソースコード
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/tests/src/tests/Tests.Commons.pas` - 既存テストコード
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/docs/code-to-docs/単体テストケース一覧/plan.md` - 生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### THTTPStatusHelper.ToInteger テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THTTPStatus.ContinueがOrd値100を返却 | E-01 (L24-25: Continue = 100) | ○ |
| C-02 | THTTPStatus.OKがOrd値200を返却 | E-01 (L28: OK = 200) | ○ |
| C-03 | THTTPStatus.CreatedがOrd値201を返却 | E-01 (L29: Created = 201) | ○ |
| C-04 | THTTPStatus.BadRequestがOrd値400を返却 | E-01 (L46: BadRequest = 400) | ○ |
| C-05 | THTTPStatus.NotFoundがOrd値404を返却 | E-01 (L50: NotFound = 404) | ○ |
| C-06 | THTTPStatus.InternalServerErrorがOrd値500を返却 | E-01 (L76: InternalServerError = 500) | ○ |
| C-07 | THTTPStatus.NetworkConnectTimeoutErrorがOrd値599を返却 | E-01 (L87: NetworkConnectTimeoutError = 599) | ○ |

### TMimeTypesHelper.ToString テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | TMimeTypes.MultiPartFormDataが'multipart/form-data'を返却 | E-01 (L261-262), E-02 (L22) | ○ |
| C-09 | TMimeTypes.ApplicationXWWWFormURLEncodedが'application/x-www-form-urlencoded'を返却 | E-01 (L263-264), E-02 (L23) | ○ |
| C-10 | TMimeTypes.ApplicationJSONが'application/json'を返却 | E-01 (L265-266), E-02 (L24) | ○ |
| C-11 | TMimeTypes.ApplicationOctetStreamが'application/octet-stream'を返却 | E-01 (L267-268), E-02 (L25) | ○ |
| C-12 | TMimeTypes.ApplicationXMLが'application/xml'を返却 | E-01 (L269-270), E-02 (L26) | ○ |
| C-13 | TMimeTypes.ApplicationJavaScriptが'application/javascript'を返却 | E-01 (L271-272), E-02 (L27) | ○ |
| C-14 | TMimeTypes.ApplicationPDFが'application/pdf'を返却 | E-01 (L273-274), E-02 (L28) | ○ |
| C-15 | TMimeTypes.ApplicationTypeScriptが'application/typescript'を返却 | E-01 (L275-276), E-02 (L29) | ○ |
| C-16 | TMimeTypes.ApplicationZIPが'application/zip'を返却 | E-01 (L277-278), E-02 (L30) | ○ |
| C-17 | TMimeTypes.TextPlainが'text/plain'を返却 | E-01 (L279-280), E-02 (L31) | ○ |
| C-18 | TMimeTypes.TextCSSが'text/css'を返却 | E-01 (L281-282), E-02 (L32) | ○ |
| C-19 | TMimeTypes.TextCSVが'text/csv'を返却 | E-01 (L283-284), E-02 (L33) | ○ |
| C-20 | TMimeTypes.TextHTMLが'text/html'を返却 | E-01 (L285-286), E-02 (L34) | ○ |
| C-21 | TMimeTypes.ImageJPEGが'image/jpeg'を返却 | E-01 (L287-288), E-02 (L35) | ○ |
| C-22 | TMimeTypes.ImagePNGが'image/png'を返却 | E-01 (L289-290), E-02 (L36) | ○ |
| C-23 | TMimeTypes.ImageGIFが'image/gif'を返却 | E-01 (L291-292), E-02 (L37) | ○ |
| C-24 | TMimeTypes.Downloadが'application/x-download'を返却 | E-01 (L293-294) | ○ |

### TLhsBracketsTypeHelper.ToString テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | TLhsBracketsType.Equalが'[eq]'を返却 | E-01 (L224-225) | ○ |
| C-26 | TLhsBracketsType.NotEqualが'[ne]'を返却 | E-01 (L226-227) | ○ |
| C-27 | TLhsBracketsType.LessThanが'[lt]'を返却 | E-01 (L228-229) | ○ |
| C-28 | TLhsBracketsType.LessThanOrEqualが'[lte]'を返却 | E-01 (L230-231) | ○ |
| C-29 | TLhsBracketsType.GreaterThanが'[gt]'を返却 | E-01 (L232-233) | ○ |
| C-30 | TLhsBracketsType.GreaterThanOrEqualが'[gte]'を返却 | E-01 (L234-235) | ○ |
| C-31 | TLhsBracketsType.Rangeが'[range]'を返却 | E-01 (L236-237) | ○ |
| C-32 | TLhsBracketsType.Likeが'[like]'を返却 | E-01 (L238-239) | ○ |
| C-33 | TLhsBracketsType.Containsが'[contains]'を返却 | E-01 (L240-241) | ○ |
| C-34 | TLhsBracketsType.StartsWithが'[startsWith]'を返却 | E-01 (L242-243) | ○ |
| C-35 | TLhsBracketsType.EndsWithが'[endsWith]'を返却 | E-01 (L244-245) | ○ |

### MatchRoute関数 テストケース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | 完全一致のルートがマッチ | E-01 (L164-217: MatchRoute実装) | ○ |
| C-37 | パラメータ付きルートがマッチ（:idが([^/]*)に置換） | E-01 (L175-176: StartsWith(':')でパラメータ検出) | ○ |
| C-38 | 複数パラメータ付きルートがマッチ | E-01 (L173-177: forループで全パラメータ処理) | ○ |
| C-39 | 複数ルートパターンから一致検索 | E-01 (L198-210: for I := Low to High ループ) | ○ |
| C-40 | 末尾スラッシュありでもマッチ | E-01 (L179-180, L196-197: 末尾スラッシュ付与処理) | ○ |
| C-41 | 末尾スラッシュなしでもマッチ | E-01 (L179-180, L196-197: 末尾スラッシュ付与処理) | ○ |
| C-42 | 大文字小文字を区別せずマッチ | E-01 (L202: '(?i)', L205: roIgnoreCase) | ○ |
| C-43 | マッチしないルートでFalse返却 | E-01 (L190: Result := False初期化) | ○ |
| C-44 | 空配列でFalse返却 | E-01 (L198: for I := Low to High は0回ループ) | ○ |
| C-45 | 空文字テキストの境界値テスト | E-01 (L195-197) | △ |
| C-46 | ルートパスのみでマッチ | E-01 (L164-217) | ○ |

### StringCommandToMethodType関数 テストケース（FPC専用）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 'DELETE'がmtDeleteに変換 | E-01 (L147-149) | ○ |
| C-48 | 'GET'がmtGetに変換 | E-01 (L150-151) | ○ |
| C-49 | 'HEAD'がmtHeadに変換 | E-01 (L152-153) | ○ |
| C-50 | 'PATCH'がmtPatchに変換 | E-01 (L154-155) | ○ |
| C-51 | 'POST'がmtPostに変換 | E-01 (L156-157) | ○ |
| C-52 | 'PUT'がmtPutに変換 | E-01 (L158-159) | ○ |
| C-53 | 未知コマンドでmtAny返却 | E-01 (L146: Result := TMethodType.mtAny初期化) | ○ |
| C-54 | 空文字でmtAny返却 | E-01 (L146: Result := TMethodType.mtAny初期化) | ○ |
| C-55 | 小文字入力時の挙動 | E-01 (L147: AnsiIndexText使用) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-CMN-045**: 空文字入力時のMatchRoute関数の正確な動作は実行時テストが必要。末尾スラッシュ付与後は'/'となるが、パターンとの一致は実装詳細に依存する。
  - 候補：実際のテスト実行による確認 / 正規表現エンジンの挙動確認
- **UT-CMN-055**: `AnsiIndexText`関数は大文字小文字を区別しない比較を行うため、小文字'get'も'GET'と同等にマッチする可能性がある。FPCドキュメントの確認が必要。
  - 候補：FPC公式ドキュメント / StrUtils.AnsiIndexTextの仕様確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - THTTPStatusHelper.ToInteger、TMimeTypesHelper.ToString、TLhsBracketsTypeHelper.ToString
  - 単純なcase文による変換のため、実装とテストケースの対応が明確
- **0: 低リスク** - MatchRoute関数の正常系テスト
  - 正規表現ベースのルートマッチングだが、ソースコードで動作が確認可能
- **1: 中リスク** - StringCommandToMethodType（FPC専用）
  - FPCコンパイラ限定の機能のため、Delphi環境ではテスト不可
- **1: 中リスク** - 境界値・異常系テスト（空文字、空配列）
  - エッジケースの動作は実行時確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] THTTPStatus列挙型の全ステータスコード（約50個）が網羅されているか確認
- [ ] TMimeTypes列挙型の全タイプ（17個）のテストが存在することを確認
- [ ] TLhsBracketsType列挙型の全タイプ（11個）のテストが存在することを確認
- [ ] MatchRoute関数のパラメータ置換ロジック（:xxx → ([^/]*)）が正しくテストされているか確認
- [ ] StringCommandToMethodType関数がFPC環境でのみ有効であることをテスト実行計画に反映
- [ ] 既存テストコード（Tests.Commons.pas）との重複・整合性を確認
- [ ] 優先度「高」のテストケースが全てカバーされているか確認
