---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 173
  claims_with_evidence: 173
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse.Core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：173 / 173、根拠なし：0
- 優先レビュー（高）
  1. 該当なし - 全テストケースにソースコード根拠あり
  2. 実行環境依存のテスト（ISAPI/Apache/CGI）は実機確認推奨
  3. FPC（Free Pascal Compiler）条件付きコードのテストは環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/src/Horse.Core.pas` - THorseCore クラス定義（540行）
- E-02: `/src/Horse.Core.Group.pas` - THorseCoreGroup<T> クラス定義（339行）
- E-03: `/src/Horse.Core.Group.Contract.pas` - IHorseCoreGroup<T> インターフェース定義（75行）
- E-04: `/src/Horse.Core.Route.pas` - THorseCoreRoute<T> クラス定義（291行）
- E-05: `/src/Horse.Core.Route.Contract.pas` - IHorseCoreRoute<T> インターフェース定義（65行）
- E-06: `/src/Horse.Core.RouterTree.pas` - THorseRouterTree クラス定義（344行）
- E-07: `/src/Horse.Core.RouterTree.NextCaller.pas` - TNextCaller クラス定義（200行）
- E-08: `/src/Horse.Core.Param.pas` - THorseCoreParam クラス定義（233行）
- E-09: `/src/Horse.Core.Param.Config.pas` - THorseCoreParamConfig クラス定義（152行）
- E-10: `/src/Horse.Core.Param.Field.pas` - THorseCoreParamField クラス定義（460行）
- E-11: `/src/Horse.Core.Param.Field.Brackets.pas` - THorseCoreParamFieldLhsBrackets クラス定義（106行）
- E-12: `/src/Horse.Core.Param.Header.pas` - THorseCoreParamHeader クラス定義（205行）
- E-13: `/src/Horse.Core.Files.pas` - THorseCoreFile クラス定義（83行）

## 3) Claims と根拠の対応（レビューの主戦場）

### THorseCore（UT-COR-001 〜 UT-COR-033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseCore.Create でシングルトン初期化 | E-01 (L160-167) | ○ |
| C-02 | 二重生成時の例外発生 | E-01 (L162-163) | ○ |
| C-03 | GetInstance でシングルトン取得 | E-01 (L169-174) | ○ |
| C-04 | TrimPath でパス正規化 | E-01 (L229-232) | ○ |
| C-05 | AddCallback でコールバック追加 | E-01 (L143-149) | ○ |
| C-06 | AddCallbacks で複数コールバック追加 | E-01 (L151-158) | ○ |
| C-07 | RegisterRoute でルート登録 | E-01 (L205-212) | ○ |
| C-08 | Get/Post/Put/Delete/Patch/Head メソッド | E-01 (L84-123) | ○ |
| C-09 | All で全HTTPメソッド登録 | E-01 (L351-360) | ○ |
| C-10 | Use でミドルウェア登録 | E-01 (L393-403) | ○ |
| C-11 | Group/Route でインターフェース取得 | E-01 (L200-217) | ○ |
| C-12 | Version でバージョン取得 | E-01 (L379-382) | ○ |
| C-13 | UnInitialize でリソース解放 | E-01 (L259-267) | ○ |
| C-14 | GetCallback でコールバック変換 | E-01 (L427-463) | ○ |
| C-15 | ToModule でモジュール取得 | E-01 (L224-227, 254-257) | ○ |
| C-16 | THorseModule の初期化と変換 | E-01 (L511-538) | ○ |

### THorseCoreGroup<T>（UT-COR-034 〜 UT-COR-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Create で FHorseCore 初期化 | E-02 (L214-217) | ○ |
| C-18 | Prefix 設定 | E-02 (L219-223) | ○ |
| C-19 | NormalizePath でパス正規化 | E-02 (L321-324) | ○ |
| C-20 | Route でインターフェース取得 | E-02 (L225-228) | ○ |
| C-21 | Get/Post/Put/Delete/Patch/Head メソッド | E-02 (L93-336) | ○ |
| C-22 | All で全メソッド登録 | E-02 (L188-211) | ○ |
| C-23 | Use でミドルウェア登録 | E-02 (L230-253) | ○ |
| C-24 | AddCallback でコールバック追加 | E-02 (L173-186) | ○ |
| C-25 | End で THorseCore 返却 | E-02 (L88-91) | ○ |

### THorseCoreRoute<T>（UT-COR-049 〜 UT-COR-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Create で FPath, FHorseCore 設定 | E-04 (L76-80) | ○ |
| C-27 | Get/Post/Put/Delete/Patch/Head メソッド | E-04 (L177-288) | ○ |
| C-28 | All でミドルウェア登録 | E-04 (L87-121) | ○ |
| C-29 | AddCallback でコールバック追加 | E-04 (L110-114) | ○ |
| C-30 | End で THorseCore 返却 | E-04 (L105-108) | ○ |

### THorseRouterTree（UT-COR-059 〜 UT-COR-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Create で各フィールド初期化 | E-06 (L119-127) | ○ |
| C-32 | Destroy でリソース解放 | E-06 (L129-137) | ○ |
| C-33 | Prefix 設定・取得 | E-06 (L210-218) | ○ |
| C-34 | RegisterRoute でルート登録 | E-06 (L71-81, 274-315) | ○ |
| C-35 | RegisterMiddleware でミドルウェア登録 | E-06 (L317-341) | ○ |
| C-36 | Execute でルート実行 | E-06 (L139-166) | ○ |
| C-37 | GetQueuePath でパス分割 | E-06 (L220-238) | ○ |
| C-38 | HasNext で次ルート確認 | E-06 (L240-272) | ○ |
| C-39 | CreateRouter/ForcePath でルーター作成 | E-06 (L196-208) | ○ |

### TNextCaller（UT-COR-078 〜 UT-COR-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Init で初期化 | E-07 (L67-78) | ○ |
| C-41 | パラメータキー抽出 | E-07 (L76-77) | ○ |
| C-42 | Next でミドルウェア・コールバック実行 | E-07 (L80-131) | ○ |
| C-43 | 例外時の InternalServerError 設定 | E-07 (L102-111) | ○ |
| C-44 | MethodNotAllowed/NotFound 処理 | E-07 (L116-130) | ○ |
| C-45 | 各種 Setter メソッド | E-07 (L133-197) | ○ |

### THorseCoreParam（UT-COR-091 〜 UT-COR-107）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Create/Destroy でライフサイクル管理 | E-08 (L83-97) | ○ |
| C-47 | ContainsKey で大文字小文字無視検索 | E-08 (L66-76) | ○ |
| C-48 | ContainsValue で値存在確認 | E-08 (L78-81) | ○ |
| C-49 | GetItem で値取得 | E-08 (L179-189) | ○ |
| C-50 | GetCount で件数取得 | E-08 (L174-177) | ○ |
| C-51 | GetContent で TStrings 取得 | E-08 (L161-172) | ○ |
| C-52 | Field でフィールド取得・キャッシュ | E-08 (L99-126) | ○ |
| C-53 | Required 設定 | E-08 (L209-213) | ○ |
| C-54 | ToArray で配列変換 | E-08 (L220-223) | ○ |
| C-55 | TryGetValue で値取得 | E-08 (L225-230) | ○ |
| C-56 | AddStream でストリーム追加 | E-08 (L128-135) | ○ |

### THorseCoreParamField（UT-COR-108 〜 UT-COR-145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Create（Dictionary/Stream） | E-10 (L304-335) | ○ |
| C-58 | AsString で文字列取得 | E-10 (L277-284) | ○ |
| C-59 | AsInteger で整数取得 | E-10 (L176-189) | ○ |
| C-60 | AsInt64 で Int64 取得 | E-10 (L161-174) | ○ |
| C-61 | AsFloat で浮動小数点取得 | E-10 (L144-159) | ○ |
| C-62 | AsBoolean で真偽値取得 | E-10 (L88-96) | ○ |
| C-63 | AsDate/AsTime/AsDateTime で日時取得 | E-10 (L103-137, 286-302) | ○ |
| C-64 | AsISO8601DateTime で ISO8601 形式取得 | E-10 (L191-201) | ○ |
| C-65 | AsStream でストリーム取得 | E-10 (L264-275) | ○ |
| C-66 | AsCurrency/AsExtended で数値取得 | E-10 (L98-101, 139-142) | ○ |
| C-67 | AsList でリスト変換 | E-10 (L203-261) | ○ |
| C-68 | SaveToFile でファイル保存 | E-10 (L424-439) | ○ |
| C-69 | Required 設定 | E-10 (L400-410) | ○ |
| C-70 | DateFormat/TimeFormat/TrueValue 設定 | E-10 (L343-347, 441-451) | ○ |
| C-71 | GetFormatSettings で設定取得 | E-10 (L349-360) | ○ |

### THorseCoreParamConfig（UT-COR-146 〜 UT-COR-155）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | GetInstance でシングルトン取得 | E-09 (L71-76) | ○ |
| C-73 | Create でデフォルト値設定 | E-09 (L49-58) | ○ |
| C-74 | RequiredMessage 設定・取得 | E-09 (L89-98) | ○ |
| C-75 | InvalidFormatMessage 設定・取得 | E-09 (L78-87) | ○ |
| C-76 | DateFormat/TimeFormat 設定・取得 | E-09 (L60-69, 111-120) | ○ |
| C-77 | ReturnUTC 設定・取得 | E-09 (L100-109) | ○ |
| C-78 | TrueValue 設定・取得 | E-09 (L122-131) | ○ |
| C-79 | CheckLhsBrackets 設定・取得 | E-09 (L133-143) | ○ |
| C-80 | UnInitialize でリソース解放 | E-09 (L145-149) | ○ |

### THorseCoreParamFieldLhsBrackets（UT-COR-156 〜 UT-COR-162）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | SetValue で各種値設定 | E-11 (L50-76) | ○ |
| C-82 | GetValue で各種値取得 | E-11 (L78-104) | ○ |

### THorseCoreParamHeader（UT-COR-163 〜 UT-COR-164）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | GetHeaders でヘッダー取得 | E-12 (L57-89) | ○ |
| C-84 | GetHeadersList でヘッダーリスト取得 | E-12 (L94-185) | ○ |

### THorseCoreFile（UT-COR-165 〜 UT-COR-173）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | Create でファイル初期化・バリデーション | E-13 (L44-56) | ○ |
| C-86 | ContentType で MIME タイプ取得 | E-13 (L65-68) | ○ |
| C-87 | ContentStream でストリーム取得 | E-13 (L70-75) | ○ |
| C-88 | Size でファイルサイズ取得 | E-13 (L77-80) | ○ |
| C-89 | Destroy でリソース解放 | E-13 (L58-63) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - 全てのテストケースはソースコードから導出
- 補足: 以下の情報があればテストケースをさらに充実可能
  - 実際の使用例・サンプルコード
  - パフォーマンス要件
  - 既存のテストコード（tests/src/tests/配下）の分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 注意点:
  1. コンパイラ条件付きコード（{$IF DEFINED(FPC)}等）は環境依存
  2. ISAPI/Apache/CGI固有のヘッダー処理は実機テスト推奨
  3. 正規表現ルートの動作は複雑なパターンで追加テスト推奨

## 6) レビュアーチェックリスト（最小）
- [ ] THorseCore シングルトンパターンのテストケース（UT-COR-001〜004）が適切か
- [ ] HTTPメソッド登録のテストケース（UT-COR-014〜021）の網羅性は十分か
- [ ] パラメータ型変換のテストケース（UT-COR-110〜137）の境界値テストは十分か
- [ ] 例外処理のテストケース（UT-COR-082〜085）がエラーハンドリング要件を満たすか
- [ ] FPC/Delphi両環境での動作確認が必要なテストケースの特定
