---
generated_at: 2026-01-22 19:05:00
metrics:
  claims_total: 46
  claims_with_evidence: 46
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse.Exception 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：46 / 46、根拠なし：0
- 優先レビュー（高）
  1. **UT-EXC-038**：メモリリークテストは実行環境依存の検証が必要
  2. **UT-EXC-037/029**：JSON変換はDelphi/FPCのコンパイラバージョンによる分岐あり
  3. **UT-EXC-039**：メソッドチェーンの組み合わせパターンは網羅的に検証推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Exception.pas` - EHorseExceptionクラス定義（201行）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Exception.Interrupted.pas` - EHorseCallbackInterruptedクラス定義（34行）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Commons.pas` - THTTPStatus、TMessageType型定義（298行）

## 3) Claims と根拠の対応（レビューの主戦場）

### EHorseException - コンストラクタ・ファクトリ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create初期値（FError=空、FStatus=InternalServerError、FCode=0） | E-01:63-68行 | ○ |
| C-02 | NewメソッドでCreate呼び出し | E-01:70-73行 | ○ |

### EHorseException - Error プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-03 | Error setterでFErrorとSelf.Message両方に設定 | E-01:124-129行 | ○ |
| C-04 | Error setterで空文字許容 | E-01:124-129行（制約なし） | ○ |
| C-05 | Error getterでFError返却 | E-01:119-122行 | ○ |

### EHorseException - Status プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | Status setterでFStatus設定・Self返却 | E-01:136-140行 | ○ |
| C-07 | Status 100系（Continue）設定可能 | E-03:25行（THTTPStatus.Continue=100） | ○ |
| C-08 | Status 500系（NetworkConnectTimeoutError）設定可能 | E-03:87行（THTTPStatus.NetworkConnectTimeoutError=599） | ○ |
| C-09 | Status getterでFStatus返却 | E-01:131-134行 | ○ |

### EHorseException - Type プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | Type setterでFType設定・Self返却 | E-01:86-90行 | ○ |
| C-11 | Type Default値設定可能 | E-03:108行（TMessageType.Default） | ○ |
| C-12 | Type getterでFType返却 | E-01:81-84行 | ○ |

### EHorseException - Title プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | Title setterでFTitle設定・Self返却 | E-01:142-146行 | ○ |
| C-14 | Title setter空文字許容 | E-01:142-146行（制約なし） | ○ |
| C-15 | Title getterでFTitle返却 | E-01:148-151行 | ○ |

### EHorseException - Code プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | Code setterでFCode設定・Self返却 | E-01:75-79行 | ○ |
| C-17 | Code setter 0値設定可能 | E-01:75-79行（制約なし） | ○ |
| C-18 | Code setter負値設定可能 | E-01:75-79行（Integer型、制約なし） | ○ |
| C-19 | Code getterでFCode返却 | E-01:92-95行 | ○ |

### EHorseException - Hint プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | Hint setterでFHint設定・Self返却 | E-01:153-157行 | ○ |
| C-21 | Hint setter空文字許容 | E-01:153-157行（制約なし） | ○ |
| C-22 | Hint getterでFHint返却 | E-01:159-162行 | ○ |

### EHorseException - Unit プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | Unit setterでFUnit設定・Self返却 | E-01:102-106行 | ○ |
| C-24 | Unit setter空文字許容 | E-01:102-106行（制約なし） | ○ |
| C-25 | Unit getterでFUnit返却 | E-01:97-100行 | ○ |

### EHorseException - Detail プロパティ

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Detail setterでFDetail設定・Self返却 | E-01:113-117行 | ○ |
| C-27 | Detail setter空文字許容 | E-01:113-117行（制約なし） | ○ |
| C-28 | Detail getterでFDetail返却 | E-01:108-111行 | ○ |

### EHorseException - JSON変換

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | ToJSONObject全プロパティ出力 | E-01:176-199行 | ○ |
| C-30 | ToJSONObject最小構成（errorのみ） | E-01:189行（errorは常に出力） | ○ |
| C-31 | ToJSONObject Type=Defaultでtypeキー非出力 | E-01:180-181行（条件分岐） | ○ |
| C-32 | ToJSONObject Code=0でcodeキー非出力 | E-01:186-187行（条件分岐） | ○ |
| C-33 | ToJSONObject Title空白のみでtitleキー非出力 | E-01:183-184行（Trim.IsEmpty判定） | ○ |
| C-34 | ToJSONObject Hint空白のみでhintキー非出力 | E-01:191-192行（Trim.IsEmpty判定） | ○ |
| C-35 | ToJSONObject Unit空白のみでunitキー非出力 | E-01:194-195行（Trim.IsEmpty判定） | ○ |
| C-36 | ToJSONObject Detail空白のみでdetailキー非出力 | E-01:197-198行（Trim.IsEmpty判定） | ○ |
| C-37 | ToJSON文字列変換 | E-01:164-174行 | ○ |
| C-38 | ToJSONでTJSONObject解放 | E-01:171-173行（try-finally-Free） | ○ |

### EHorseException - その他

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | メソッドチェーン対応 | E-01:全setter（Result := Self返却） | ○ |
| C-40 | Exception継承 | E-01:21行（class(Exception)） | ○ |
| C-45 | 例外としてraise可能 | E-01:21行（Exception派生クラス） | ○ |

### EHorseCallbackInterrupted

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | 引数なしCreateでメッセージ空 | E-02:24-27行（inherited Create(EmptyStr)） | ○ |
| C-42 | メッセージ付きCreateで設定 | E-02:29-32行（inherited Create(AMessage)） | ○ |
| C-43 | 空文字メッセージ許容 | E-02:29-32行（制約なし） | ○ |
| C-44 | Exception継承 | E-02:17行（class(Exception)） | ○ |
| C-46 | 例外としてraise可能 | E-02:17行（Exception派生クラス） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（全テストケースに根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいている
- 注意点:
  - JSON変換テスト（UT-EXC-029〜038）はDelphi/FPCのコンパイラバージョンによる分岐がある（E-01:170行、181行等）
  - メモリリークテスト（UT-EXC-038）は実行環境でのメモリ監視が必要

## 6) レビュアーチェックリスト（最小）
- [ ] EHorseExceptionの全8プロパティ（Error, Status, Type, Title, Code, Hint, Unit, Detail）のgetter/setterテストが網羅されているか
- [ ] ToJSONObject/ToJSONの条件分岐（空文字、デフォルト値）がテストケースでカバーされているか
- [ ] EHorseCallbackInterruptedの2つのコンストラクタがテストされているか
- [ ] メソッドチェーン（フルエントインターフェース）のテストが含まれているか
- [ ] Exception継承・raise可能性のテストが含まれているか
