---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 45
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse.Mime 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：45 / 45、根拠なし：0
- 優先レビュー（高）
  1. **スレッドセーフティテスト（UT-MIM-023）**：実際のマルチスレッドテストの実装方法は要検討
  2. **境界値テスト（UT-MIM-020, 027）**：空文字列入力時の実際の挙動確認が必要
  3. **未登録拡張子のフォールバック処理**：コード上の挙動は明確だが実行確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/src/Horse.Mime.pas` 行1-27（THorseMimeTypesクラス定義）
- E-02: `/src/Horse.Mime.pas` 行42-62（THorseMimeTypesExtクラス定義）
- E-03: `/src/Horse.Mime.pas` 行66-90（GetExtType/GetFileType実装）
- E-04: `/src/Horse.Mime.pas` 行94-103（Create/Destroyコンストラクタ）
- E-05: `/src/Horse.Mime.pas` 行105-132（クラスコンストラクタ/デストラクタ/GetDefault）
- E-06: `/src/Horse.Mime.pas` 行134-153（NormalizeExt/GetExtType/GetFileType実装）
- E-07: `/src/Horse.Mime.pas` 行155-1161（InitializeFileType - MIMEタイプ辞書登録）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseMimeTypes.GetFileTypeでファイル名からMIMEタイプ取得 | E-03（行79-90） | ○ |
| C-02 | HTMLファイルのMIMEタイプが'text/html' | E-07（行1034-1035） | ○ |
| C-03 | JPGファイルのMIMEタイプが'image/jpeg' | E-07（行952-954） | ○ |
| C-04 | CSSファイルのMIMEタイプが'text/css' | E-07（行1032） | ○ |
| C-05 | JSファイルのMIMEタイプが'application/javascript' | E-07（行190） | ○ |
| C-06 | PDFファイルのMIMEタイプが'application/pdf' | E-07（行243） | ○ |
| C-07 | XMLファイルのMIMEタイプが'application/xml' | E-07（行880-881） | ○ |
| C-08 | ZIPファイルのMIMEタイプが'application/zip' | E-07（行893） | ○ |
| C-09 | PNGファイルのMIMEタイプが'image/png' | E-07（行956） | ○ |
| C-10 | MP4ファイルのMIMEタイプが'video/mp4' | E-07（行1111-1113） | ○ |
| C-11 | MP3ファイルのMIMEタイプが'audio/mpeg' | E-07（行905） | ○ |
| C-12 | 未知の拡張子でデフォルトMIMEタイプ返却 | E-06（行146-147） | ○ |
| C-13 | 拡張子なしファイルでデフォルトMIMEタイプ返却 | E-06（行145-147） | ○ |
| C-14 | 大文字拡張子でも正しく処理される | E-06（行136: ToLower） | ○ |
| C-15 | パス付きファイル名の処理 | E-06（行136: ExtractFileExt） | ○ |
| C-16 | GetExtTypeで拡張子からMIMEタイプ取得 | E-03（行66-77） | ○ |
| C-17 | ドットなし拡張子の処理 | E-06（行136-138） | ○ |
| C-18 | GetExtTypeでの大文字拡張子処理 | E-06（行136: ToLower） | ○ |
| C-19 | GetExtTypeで未知の拡張子処理 | E-06（行146-147） | ○ |
| C-20 | 空文字列でデフォルトMIMEタイプ返却 | E-06（行145-147） | ○ |
| C-21 | GetDefaultでシングルトン取得 | E-05（行116-132） | ○ |
| C-22 | 複数回呼び出しで同一インスタンス | E-05（行118-131） | ○ |
| C-23 | スレッドセーフなインスタンス生成 | E-05（行120-129: FLock.Enter/Leave） | ○ |
| C-24 | NormalizeExtで拡張子正規化 | E-06（行134-139） | ○ |
| C-25 | ドット付き拡張子からドット除去 | E-06（行137-138） | ○ |
| C-26 | 前後の空白除去（Trim） | E-06（行136: Trim） | ○ |
| C-27 | 空文字列で空文字列返却 | E-06（行136-138） | ○ |
| C-28 | THorseMimeTypesExt.GetExtTypeの動作 | E-06（行141-148） | ○ |
| C-29 | 未登録拡張子でのフォールバック | E-06（行147） | ○ |
| C-30 | THorseMimeTypesExt.GetFileTypeの動作 | E-06（行150-153） | ○ |
| C-31 | 複数ドット含むファイル名の処理 | E-06（行136: ExtractFileExt） | ○ |
| C-32 | Createコンストラクタで辞書生成 | E-04（行94-97） | ○ |
| C-33 | Destroyデストラクタでリソース解放 | E-04（行99-103） | ○ |
| C-34 | InitializeFileTypeで辞書初期化 | E-07（行155-1161） | ○ |
| C-35 | Office文書のMIMEタイプ登録 | E-07（行595-602） | ○ |
| C-36 | Webフォント形式の登録 | E-07（行776-785） | ○ |
| C-37 | クラスコンストラクタでCriticalSection生成 | E-05（行105-108） | ○ |
| C-38 | クラスデストラクタでリソース解放 | E-05（行110-114） | ○ |
| C-39 | GIF画像のMIMEタイプ | E-07（行950） | ○ |
| C-40 | SVG画像のMIMEタイプ | E-07（行959-960） | ○ |
| C-41 | WebP画像のMIMEタイプ | E-07（行983） | ○ |
| C-42 | WebMビデオのMIMEタイプ | E-07（行1140） | ○ |
| C-43 | Markdown未登録の確認 | E-07（全体） | ○ |
| C-44 | BSONのMIMEタイプ | E-07（行163） | ○ |
| C-45 | ExtractFileExt依存の動作確認 | E-06（行136, 152） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - THorseMimeTypesは単純なMIMEタイプ辞書ラッパーであり、ビジネスロジックを含まない
- **1: 中リスク** - スレッドセーフティ（TCriticalSection使用）の実際の動作確認
- **0: 低リスク** - デフォルトMIMEタイプ（application/octet-stream）のフォールバックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] UT-MIM-023のスレッドセーフティテストの実装方針が適切か
- [ ] 全てのMIMEタイプ（約1000件）のうち、主要なものがテストケースに含まれているか
- [ ] 境界値テスト（空文字列、null等）の網羅性が十分か
- [ ] コンパイラディレクティブ（UseTHorseMimeTypesExt）によるコード分岐がテストカバレッジに影響しないか
- [ ] FPCとDelphiの両方で動作確認が必要かどうか検討

---

## 補足：モジュール構造

### THorseMimeTypes（公開クラス）
- `GetFileType(AFileName)`: ファイル名からMIMEタイプを取得
- `GetExtType(AFileExt)`: 拡張子からMIMEタイプを取得

### THorseMimeTypesExt（内部クラス・シングルトン）
- `Default`: シングルトンインスタンスプロパティ
- `GetDefault`: スレッドセーフなインスタンス取得
- `GetFileType(AFileName)`: GetExtTypeへの委譲
- `GetExtType(AFileExt)`: 辞書検索
- `NormalizeExt(AFileExt)`: 拡張子の正規化（小文字化、ドット除去）
- `InitializeFileType`: 約1000件のMIMEタイプ登録

### 特記事項
1. コンパイラディレクティブ`UseTHorseMimeTypesExt`により、Delphi Tokyo以降では`System.Net.Mime.TMimeTypes`を使用
2. FPCまたはDelphi 32.0以下では内部実装の`THorseMimeTypesExt`を使用
3. 未登録拡張子は全て`application/octet-stream`を返却
