---
generated_at: 2026-01-22 18:52:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse.Proc単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  1. **UT-PRC-003**：TNextProc型の変数代入テスト - ミドルウェアチェーンの基盤機能
  2. **UT-PRC-004**：TNextProc型の変数実行テスト - ミドルウェアチェーンの実行機能
  3. **UT-PRC-005**：nil呼び出し時の例外テスト - 実行時エラー防止

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Proc.pas` - TNextProc型定義（15行目）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Proc.pas` - TProc型定義（16行目）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Proc.pas` - TProc<T>型定義（19行目）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Proc.pas` - FPC条件コンパイル（3-5行目）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Proc.pas` - Delphi用uses句（9-12行目）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール説明（Horse.Proc: プロシージャ型定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TNextProc型がDelphi環境でSystem.SysUtils.TProcとして定義される | E-01, E-05 | ○ |
| C-02 | TNextProc型がFPC環境でprocedure of objectとして定義される | E-01, E-04 | ○ |
| C-03 | TNextProc型の変数に手続きを代入できる | E-01 | ○ |
| C-04 | TNextProc型の変数を実行できる | E-01 | ○ |
| C-05 | TNextProc型変数がnilの場合に例外が発生する | E-01 | ○ |
| C-06 | TProc型がDelphi環境でSystem.SysUtils.TProcとして定義される | E-02, E-05 | ○ |
| C-07 | TProc型がFPC環境でprocedureとして定義される | E-02, E-04 | ○ |
| C-08 | TProc型の変数に手続きを代入できる | E-02 | ○ |
| C-09 | TProc型の変数を実行できる | E-02 | ○ |
| C-10 | TProc<T>型がFPC環境でprocedure(Arg1: T)として定義される | E-03, E-04 | ○ |
| C-11 | TProc<T>型の変数を型引数付きで宣言できる | E-03 | ○ |
| C-12 | TProc<T>型の変数に手続きを代入できる | E-03 | ○ |
| C-13 | TProc<T>型の変数を実行できる | E-03 | ○ |
| C-14 | TProc<T>型の変数にnilを代入できる | E-03 | ○ |
| C-15 | FPC環境で{$MODE DELPHI}{$H+}が適用される | E-04 | ○ |
| C-16 | Delphi環境でSystem.SysUtilsがusesされる | E-05 | ○ |
| C-17 | FPC環境でSystem.SysUtilsがusesされない | E-04, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本モジュールは型定義のみのため、実行可能なコードは存在しない
- 型の動作検証は他のモジュール（Horse.Callback等）での使用状況を参照する必要がある
  - 候補：Horse.Callback.pas / Horse.Core.Router.pas / Horse.Provider系

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：本モジュールは型定義のみであり、ロジックを含まない
- 注意点：FPC/Delphi間の互換性に関するテストは実際のコンパイラ環境が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TNextProc型がミドルウェアチェーンで正しく使用されているか（Horse.Callback等で確認）
- [ ] TProc型の用途と他モジュールとの整合性を確認
- [ ] FPC環境でのTProc<T>型の互換性を確認（Delphi環境では使用されない）
- [ ] 条件コンパイル（{$IF DEFINED(FPC)}）が正しく機能することを確認
