---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 128
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse.Provider 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当箇所が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：128 / 128、根拠なし：0
- 優先レビュー（高）
  1. **デーモンプロセスのfork処理（UT-PRV-052〜054）**：OSレベルの動作確認が必要
  2. **シグナル処理（UT-PRV-055〜056）**：実環境でのテストが必要
  3. **SSL設定（UT-PRV-031〜034, UT-PRV-067〜086）**：セキュリティ関連の重要機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.Abstract.pas`（行1-77）
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.Console.pas`（行1-336）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.VCL.pas`（行1-302）
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.Daemon.pas`（行1-371）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.CGI.pas`（行1-51）
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.Apache.pas`（行1-109）
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.ISAPI.pas`（行1-59）
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.IOHandleSSL.pas`（行1-162）
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.IOHandleSSL.Contract.pas`（行1-38）
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.FPC.CGI.pas`（行1-92）
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.FPC.LCL.pas`（行1-300）
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.FPC.HTTPApplication.pas`（行1-177）
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.FPC.Apache.pas`（行1-132）
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.FPC.Daemon.pas`（行1-288）
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Provider.FPC.FastCGI.pas`（行1-150）

## 3) Claims と根拠の対応（レビューの主戦場）

### THorseProviderAbstract（基底クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-PRV-001) | GetOnListenでFOnListenが返却される | E-01: 行51-54 | ○ |
| C-02 (UT-PRV-002) | SetOnListenでFOnListenに値が設定される | E-01: 行61-64 | ○ |
| C-03 (UT-PRV-003) | SetOnListenにnilを設定可能 | E-01: 行61-64 | ○ |
| C-04 (UT-PRV-004) | GetOnStopListenでFOnStopListenが返却される | E-01: 行56-59 | ○ |
| C-05 (UT-PRV-005) | SetOnStopListenでFOnStopListenに値が設定される | E-01: 行66-69 | ○ |
| C-06 (UT-PRV-006) | DoOnListenでFOnListenが実行される | E-01: 行39-43 | ○ |
| C-07 (UT-PRV-007) | FOnListen=nil時にDoOnListenでエラーにならない | E-01: 行41 (Assigned確認) | ○ |
| C-08 (UT-PRV-008) | DoOnStopListenでFOnStopListenが実行される | E-01: 行45-49 | ○ |
| C-09 (UT-PRV-009) | FOnStopListen=nil時にDoOnStopListenでエラーにならない | E-01: 行47 (Assigned確認) | ○ |
| C-10 (UT-PRV-010) | StopListenで例外がスローされる | E-01: 行71-74 | ○ |

### THorseProvider(Console) - プロパティ関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 (UT-PRV-011) | GetPortでFPortが返却される | E-02: 行153-156 | ○ |
| C-12 (UT-PRV-012) | SetPortでFPortに値が設定される | E-02: 行319-322 | ○ |
| C-13 (UT-PRV-013) | GetDefaultPortでDEFAULT_PORTが返却される | E-02: 行118-121 | ○ |
| C-14 (UT-PRV-014) | GetHostでFHostが返却される | E-02: 行123-126 | ○ |
| C-15 (UT-PRV-015) | SetHostでFHostに値が設定される | E-02: 行294-297 | ○ |
| C-16 (UT-PRV-016) | SetHostでTrim処理される | E-02: 行296 | ○ |
| C-17 (UT-PRV-017) | GetDefaultHostでDEFAULT_HOSTが返却される | E-02: 行113-116 | ○ |
| C-18 (UT-PRV-018) | GetMaxConnectionsでFMaxConnectionsが返却される | E-02: 行149-151 | ○ |
| C-19 (UT-PRV-019) | SetMaxConnectionsでFMaxConnectionsに値が設定される | E-02: 行314-317 | ○ |
| C-20 (UT-PRV-020) | GetListenQueueでFListenQueueが返却される | E-02: 行143-146 | ○ |
| C-21 (UT-PRV-021) | SetListenQueueでFListenQueueに値が設定される | E-02: 行309-312 | ○ |
| C-22 (UT-PRV-022) | GetKeepConnectionAliveでFKeepConnectionAliveが返却される | E-02: 行128-131 | ○ |
| C-23 (UT-PRV-023) | SetKeepConnectionAliveでFKeepConnectionAliveに値が設定される | E-02: 行299-302 | ○ |
| C-24 (UT-PRV-024) | IsRunningでFRunning=TrueならTrueが返却される | E-02: 行133-136 | ○ |
| C-25 (UT-PRV-025) | IsRunningでFRunning=FalseならFalseが返却される | E-02: 行133-136 | ○ |

### THorseProvider(Console) - WebBroker・SSL関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 (UT-PRV-026) | HTTPWebBrokerIsNilでnil時にTrueが返却される | E-02: 行89-92 | ○ |
| C-27 (UT-PRV-027) | HTTPWebBrokerIsNilで初期化済み時にFalseが返却される | E-02: 行89-92 | ○ |
| C-28 (UT-PRV-028) | GetDefaultHTTPWebBrokerでnil時に新規生成される | E-02: 行78-87 | ○ |
| C-29 (UT-PRV-029) | GetDefaultHTTPWebBrokerで既存インスタンスが返却される | E-02: 行78-87 | ○ |
| C-30 (UT-PRV-030) | GetIOHandleSSLでインターフェースが返却される | E-02: 行138-141 | ○ |
| C-31 (UT-PRV-031) | SetIOHandleSSLで値が設定される | E-02: 行304-307 | ○ |
| C-32 (UT-PRV-032) | GetDefaultHorseProviderIOHandleSSLでnil時に新規生成される | E-02: 行106-111 | ○ |
| C-33 (UT-PRV-033) | OnQuerySSLPortでSSL有効時にVUseSSL=True | E-02: 行94-97 | ○ |
| C-34 (UT-PRV-034) | OnQuerySSLPortでSSL無効時にVUseSSL=False | E-02: 行94-97 | ○ |
| C-35 (UT-PRV-035) | OnAuthenticationでVHandled=True | E-02: 行289-292 | ○ |

### THorseProvider(Console) - サーバー起動・停止
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 (UT-PRV-036) | InternalListenでデフォルト設定でサーバー起動 | E-02: 行174-238 | ○ |
| C-37 (UT-PRV-037) | InternalListenで指定設定でサーバー起動 | E-02: 行174-238 | ○ |
| C-38 (UT-PRV-038) | InternalListenでMaxConnectionsが適用される | E-02: 行189-193 | ○ |
| C-39 (UT-PRV-039) | InternalListenでSSL設定時にSSLハンドラ初期化 | E-02: 行198-199 | ○ |
| C-40 (UT-PRV-040) | InternalListenでカスタムホスト時にBindings設定 | E-02: 行202-208 | ○ |
| C-41 (UT-PRV-041) | InternalStopListenでサーバー停止 | E-02: 行240-253 | ○ |
| C-42 (UT-PRV-042) | InternalStopListenで未起動時に例外スロー | E-02: 行251-252 | ○ |
| C-43 (UT-PRV-043) | Listen(4パラメータ)で全設定されサーバー起動 | E-02: 行265-272 | ○ |
| C-44 (UT-PRV-044) | Listen(3パラメータ)でポートとコールバック設定 | E-02: 行284-287 | ○ |
| C-45 (UT-PRV-045) | Listen(3パラメータ)でホストとコールバック設定 | E-02: 行274-277 | ○ |
| C-46 (UT-PRV-046) | Listen(2パラメータ)でコールバックのみ設定 | E-02: 行279-282 | ○ |
| C-47 (UT-PRV-047) | InitServerIOHandlerSSLOpenSSLでSSL設定適用 | E-02: 行158-172 | ○ |
| C-48 (UT-PRV-048) | GetDefaultEventでnil時に新規生成 | E-02: 行99-104 | ○ |
| C-49 (UT-PRV-049) | UnInitializeでリソース解放 | E-02: 行324-329 | ○ |

### THorseProvider(VCL)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 (UT-PRV-050) | VCL環境でサーバー起動 | E-03: 行169-213 | ○ |
| C-51 (UT-PRV-051) | VCL環境でサーバー停止 | E-03: 行215-226 | ○ |

### THorseProvider(Daemon) - デーモン化処理
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 (UT-PRV-052) | デーモンプロセスがフォークされる | E-04: 行195-280 | ○ |
| C-53 (UT-PRV-053) | fork失敗時に例外スロー | E-04: 行207-208 | ○ |
| C-54 (UT-PRV-054) | setsid失敗時に例外スロー | E-04: 行211-212 | ○ |
| C-55 (UT-PRV-055) | SIGTERMでサーバー停止 | E-04: 行93-100 | ○ |
| C-56 (UT-PRV-056) | SIGHUPでリロードログ出力 | E-04: 行101-104 | ○ |

### THorseProvider(CGI/Apache/ISAPI)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 (UT-PRV-057) | CGIアプリケーション初期化・実行 | E-05: 行28-34 | ○ |
| C-58 (UT-PRV-058) | CGIでコールバック付き起動 | E-05: 行42-47 | ○ |
| C-59 (UT-PRV-059) | Apache GetMaxConnections | E-06: 行77-80 | ○ |
| C-60 (UT-PRV-060) | Apache SetMaxConnections | E-06: 行82-85 | ○ |
| C-61 (UT-PRV-061) | Apache GetHandlerName | E-06: 行87-90 | ○ |
| C-62 (UT-PRV-062) | Apache SetHandlerName | E-06: 行92-95 | ○ |
| C-63 (UT-PRV-063) | Apache GetDefaultModule | E-06: 行97-100 | ○ |
| C-64 (UT-PRV-064) | Apache SetDefaultModule | E-06: 行102-105 | ○ |
| C-65 (UT-PRV-065) | Apacheモジュール初期化・実行 | E-06: 行46-62 | ○ |
| C-66 (UT-PRV-066) | ISAPIアプリケーション初期化・実行 | E-07: 行35-42 | ○ |

### THorseProviderIOHandleSSL
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 (UT-PRV-067) | Createでデフォルト値初期化 | E-08: 行83-88 | ○ |
| C-68 (UT-PRV-068) | Newでインスタンス生成 | E-08: 行123-126 | ○ |
| C-69 (UT-PRV-069) | Active(Boolean)でフルーエント設定 | E-08: 行50-54 | ○ |
| C-70 (UT-PRV-070) | Active取得 | E-08: 行56-59 | ○ |
| C-71 (UT-PRV-071) | CertFile(string)でフルーエント設定 | E-08: 行61-65 | ○ |
| C-72 (UT-PRV-072) | CertFile取得 | E-08: 行78-81 | ○ |
| C-73 (UT-PRV-073) | RootCertFile(string)でフルーエント設定 | E-08: 行139-143 | ○ |
| C-74 (UT-PRV-074) | RootCertFile取得 | E-08: 行145-148 | ○ |
| C-75 (UT-PRV-075) | KeyFile(string)でフルーエント設定 | E-08: 行101-105 | ○ |
| C-76 (UT-PRV-076) | KeyFile取得 | E-08: 行107-110 | ○ |
| C-77 (UT-PRV-077) | Method(TIdSSLVersion)でフルーエント設定 | E-08: 行112-116 | ○ |
| C-78 (UT-PRV-078) | Method取得 | E-08: 行118-121 | ○ |
| C-79 (UT-PRV-079) | SSLVersions(TIdSSLVersions)でフルーエント設定 | E-08: 行155-159 | ○ |
| C-80 (UT-PRV-080) | SSLVersions取得 | E-08: 行150-153 | ○ |
| C-81 (UT-PRV-081) | DHParamsFile(string)でフルーエント設定 | E-08: 行95-99 | ○ |
| C-82 (UT-PRV-082) | DHParamsFile取得 | E-08: 行90-93 | ○ |
| C-83 (UT-PRV-083) | CipherList(string)でフルーエント設定 | E-08: 行72-76 | ○ |
| C-84 (UT-PRV-084) | CipherList取得 | E-08: 行67-70 | ○ |
| C-85 (UT-PRV-085) | OnGetPassword(TPasswordEvent)でフルーエント設定 | E-08: 行128-132 | ○ |
| C-86 (UT-PRV-086) | OnGetPassword取得 | E-08: 行134-137 | ○ |

### THorseProvider(FPC.CGI)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 (UT-PRV-087) | CGIApplicationIsNilでnil時にTrue | E-10: 行50-53 | ○ |
| C-88 (UT-PRV-088) | GetDefaultCGIApplicationでnil時にApplication設定 | E-10: 行43-48 | ○ |
| C-89 (UT-PRV-089) | DoGetModuleでTHorseWebModule設定 | E-10: 行74-77 | ○ |
| C-90 (UT-PRV-090) | FPC CGIアプリケーション初期化・実行 | E-10: 行60-72 | ○ |

### THorseProvider(FPC.LCL)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 (UT-PRV-091) | GetDefaultHTTPServerThreadでnil時に新規生成 | E-11: 行88-93 | ○ |
| C-92 (UT-PRV-092) | LCLサーバーデフォルト起動 | E-11: 行125-143 | ○ |
| C-93 (UT-PRV-093) | ListenQueue=0時にデフォルト値15設定 | E-11: 行134-135 | ○ |
| C-94 (UT-PRV-094) | LCLサーバー停止 | E-11: 行145-155 | ○ |
| C-95 (UT-PRV-095) | LCLサーバー未起動時に例外 | E-11: 行153-154 | ○ |
| C-96 (UT-PRV-096) | THTTPServerThread Create | E-11: 行220-228 | ○ |
| C-97 (UT-PRV-097) | THTTPServerThread Destroy | E-11: 行230-237 | ○ |
| C-98 (UT-PRV-098) | StartServer | E-11: 行239-243 | ○ |
| C-99 (UT-PRV-099) | StopServer | E-11: 行245-249 | ○ |
| C-100 (UT-PRV-100) | Execute | E-11: 行251-263 | ○ |
| C-101 (UT-PRV-101) | DoTerminate | E-11: 行265-269 | ○ |
| C-102 (UT-PRV-102) | OnRequestでルーティング成功 | E-11: 行271-296 | ○ |
| C-103 (UT-PRV-103) | OnRequestで404応答 | E-11: 行282-284 | ○ |
| C-104 (UT-PRV-104) | OnRequestで例外再スロー | E-11: 行286-288 | ○ |
| C-105 (UT-PRV-105) | OnRequestでEHorseCallbackInterrupted握りつぶし | E-11: 行287 | ○ |

### THorseProvider(FPC.HTTPApplication)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 (UT-PRV-106) | HTTPApplicationIsNilでnil時にTrue | E-12: 行67-70 | ○ |
| C-107 (UT-PRV-107) | GetDefaultHTTPApplicationでnil時にApplication設定 | E-12: 行60-65 | ○ |
| C-108 (UT-PRV-108) | DoGetModuleでTHorseWebModule設定 | E-12: 行122-125 | ○ |
| C-109 (UT-PRV-109) | FPC HTTPApplication初期化・実行 | E-12: 行97-120 | ○ |
| C-110 (UT-PRV-110) | ListenQueue=0時にデフォルト値15設定 | E-12: 行106-107 | ○ |

### THorseProvider(FPC.Apache)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 (UT-PRV-111) | ApacheApplicationIsNilでnil時にTrue | E-13: 行83-86 | ○ |
| C-112 (UT-PRV-112) | GetDefaultApacheApplicationでnil時にApplication設定 | E-13: 行56-61 | ○ |
| C-113 (UT-PRV-113) | GetModuleName | E-13: 行78-81 | ○ |
| C-114 (UT-PRV-114) | SetModuleName | E-13: 行73-76 | ○ |
| C-115 (UT-PRV-115) | DoGetModuleでTHorseWebModule設定 | E-13: 行104-107 | ○ |
| C-116 (UT-PRV-116) | FPC Apacheモジュール初期化 | E-13: 行88-102 | ○ |

### THorseProvider(FPC.Daemon)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-117 (UT-PRV-117) | GetDefaultHTTPServerThreadでnil時に新規生成 | E-14: 行86-91 | ○ |
| C-118 (UT-PRV-118) | FPC Daemonサーバー起動 | E-14: 行133-151 | ○ |
| C-119 (UT-PRV-119) | FPC Daemonサーバー停止 | E-14: 行202-212 | ○ |
| C-120 (UT-PRV-120) | THTTPServerThread(Daemon) Create | E-14: 行241-249 | ○ |
| C-121 (UT-PRV-121) | Execute でHostName設定 | E-14: 行271-284 | ○ |
| C-122 (UT-PRV-122) | OnRequestでルーティング | E-14: 行214-239 | ○ |

### THorseProvider(FPC.FastCGI)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 (UT-PRV-123) | FastCGIApplicationIsNilでnil時にTrue | E-15: 行61-64 | ○ |
| C-124 (UT-PRV-124) | GetDefaultFastCGIApplicationでnil時にApplication設定 | E-15: 行54-59 | ○ |
| C-125 (UT-PRV-125) | GetDefaultPortで-1が返却される | E-15: 行71-74 | ○ |
| C-126 (UT-PRV-126) | DoGetModuleでTHorseWebModule設定 | E-15: 行105-108 | ○ |
| C-127 (UT-PRV-127) | FPC FastCGI初期化・実行 | E-15: 行86-103 | ○ |

### IHorseProviderIOHandleSSL
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-128 (UT-PRV-128) | インターフェースGUID定義 | E-09: 行14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。すべてのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 2（高）**: デーモン化処理（fork, setsid）- OS依存の動作確認が必要
- **リスクレベル 2（高）**: シグナル処理（SIGTERM, SIGHUP）- 実環境テストが必要
- **リスクレベル 2（高）**: SSL/TLS設定 - セキュリティ上の重要機能
- **リスクレベル 1（中）**: マルチスレッド処理（THTTPServerThread）- 競合状態の確認が必要
- **リスクレベル 1（中）**: 条件コンパイル（FPC, HORSE_VCL等）- 各環境での動作確認が必要
- **リスクレベル 0（低）**: 単純なGetter/Setter - 自動生成テストで十分

## 6) レビュアーチェックリスト（最小）
- [ ] デーモン化処理（UT-PRV-052〜056）のテストケースが実環境で検証可能か確認
- [ ] SSL設定（UT-PRV-067〜086）のテストケースが証明書ファイルのモック化を考慮しているか確認
- [ ] マルチスレッド処理（UT-PRV-096〜105, UT-PRV-120〜122）の競合状態テストが含まれているか確認
- [ ] 各プロバイダー（Console, VCL, Daemon, CGI, Apache, ISAPI）の環境固有テストが分離されているか確認
- [ ] FPC（Free Pascal）固有のプロバイダーがDelphi版と同等のカバレッジを持つか確認
- [ ] 例外処理（UT-PRV-010, UT-PRV-042, UT-PRV-053〜054, UT-PRV-095）のテストケースが適切なメッセージを検証しているか確認
