---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 49
  claims_with_evidence: 49
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse.Request 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：49 / 49、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースがソースコードに基づいて作成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Request.pas` - THorseRequestクラス定義
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Commons.pas` - TMethodType、TMimeTypes定義
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Session.pas` - THorseSessionsクラス定義
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Core.Param.pas` - THorseCoreParamクラス定義
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Horse.Core.Param.Header.pas` - THorseCoreParamHeader.GetHeaders

## 3) Claims と根拠の対応（レビューの主戦場）

### コンストラクタ・デストラクタ関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create: WebRequestが正しく保持される | E-01 (L112-116) | ○ |
| C-02 | Create: THorseSessionsが初期化される | E-01 (L115) | ○ |
| C-03 | Destroy: 全フィールドが解放される | E-01 (L118-135) | ○ |
| C-04 | Destroy: 未初期化フィールドも安全に解放 | E-01 (L120-133) Assigned判定 | ○ |

### Body関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | Body(string): リクエストボディを文字列取得 | E-01 (L75-78) FWebRequest.Content | ○ |
| C-06 | Body(string): 空のボディも取得可能 | E-01 (L77) Contentプロパティ依存 | ○ |
| C-07 | Body<T>: ジェネリック型で取得 | E-01 (L88-91) T(FBody)キャスト | ○ |
| C-08 | Body<T>: 未設定時nil返却 | E-01 (L90) FBodyがnil時の挙動 | ○ |
| C-09 | Body(TObject): オブジェクト設定 | E-01 (L80-86) | ○ |
| C-10 | Body(TObject): 既存オブジェクト解放 | E-01 (L83-84) Assigned+Free | ○ |

### Session関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | Session<T>: ジェネリック型で取得 | E-01 (L325-328) T(FSession)キャスト | ○ |
| C-12 | Session<T>: 未設定時nil返却 | E-01 (L327) FSessionがnil時 | ○ |
| C-13 | Session(TObject): オブジェクト設定 | E-01 (L319-323) | ○ |
| C-40 | Sessions: THorseSessionsインスタンス返却 | E-01 (L330-333) | ○ |

### Headers関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | Headers: 初回アクセス時に初期化 | E-01 (L137-147) not Assigned判定 | ○ |
| C-15 | Headers: 2回目以降は既存インスタンス | E-01 (L141) if not Assigned | ○ |
| C-16 | Headers: Required=False設定 | E-01 (L144) .Required(False) | ○ |

### Query関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | Query: 初回アクセス時に初期化 | E-01 (L307-312) not Assigned判定 | ○ |
| C-18 | Query: 2回目以降は既存インスタンス | E-01 (L308) if not Assigned | ○ |
| C-19 | InitializeQuery: クエリ文字列パース | E-01 (L243-259) Pos, Copy使用 | ○ |
| C-20 | InitializeQuery: 同一キー値結合 | E-01 (L254-257) カンマ結合ロジック | ○ |
| C-21 | InitializeQuery: 空クエリ処理 | E-01 (L248-249) forループスキップ | ○ |
| C-22 | InitializeQuery: 空値処理 | E-01 (L252-253) Copy処理 | ○ |

### Params関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | Params: 初回アクセス時に初期化 | E-01 (L300-305) not Assigned判定 | ○ |
| C-24 | Params: Required=True設定 | E-01 (L240) .Required(True) | ○ |

### Cookie関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Cookie: 初回アクセス時に初期化 | E-01 (L105-110) not Assigned判定 | ○ |
| C-26 | InitializeCookie: Cookie文字列パース | E-01 (L222-236) Split(['='])使用 | ○ |
| C-27 | InitializeCookie: 空Cookie処理 | E-01 (L231) forループスキップ | ○ |

### ContentFields関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | ContentFields: 初回アクセス時に初期化 | E-01 (L98-103) not Assigned判定 | ○ |
| C-29 | InitializeContentFields: multipart/form-dataパース | E-01 (L169-220) IsMultipartForm判定 | ○ |
| C-30 | InitializeContentFields: application/x-www-form-urlencodedパース | E-01 (L169-220) IsFormURLEncoded判定 | ○ |
| C-31 | InitializeContentFields: ファイルストリーム追加 | E-01 (L183-184) AddStream呼出 | ○ |
| C-32 | InitializeContentFields: 対象外ContentType時は空 | E-01 (L180-181) CanLoadContentFields判定 | ○ |

### ContentType判定関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | CanLoadContentFields: multipart時True | E-01 (L93-96) IsMultipartForm | ○ |
| C-34 | CanLoadContentFields: urlencoded時True | E-01 (L93-96) IsFormURLEncoded | ○ |
| C-35 | CanLoadContentFields: その他時False | E-01 (L93-96) or条件 | ○ |
| C-36 | IsMultipartForm: multipart判定 | E-01 (L278-293) StrLIComp使用 | ○ |
| C-37 | IsMultipartForm: 大文字小文字無視 | E-01 (L285, 290) StrLIComp | ○ |
| C-38 | IsFormURLEncoded: urlencoded判定 | E-01 (L261-276) StrLIComp使用 | ○ |
| C-39 | IsFormURLEncoded: 大文字小文字無視 | E-01 (L268, 273) StrLIComp | ○ |

### その他メソッド

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | MethodType: Delphi版HTTPメソッド取得 | E-01 (L295-298) FWebRequest.MethodType | ○ |
| C-42 | MethodType: FPC版HTTPメソッド取得 | E-01 (L297) StringCommandToMethodType | ○ |
| C-43 | ContentType: Content-Typeヘッダー取得 | E-01 (L154-157) FWebRequest.ContentType | ○ |
| C-44 | ContentType: 未設定時空文字 | E-01 (L156) プロパティ依存 | ○ |
| C-45 | Host: Hostヘッダー取得 | E-01 (L149-152) FWebRequest.Host | ○ |
| C-46 | PathInfo: パス情報取得 | E-01 (L159-167) | ○ |
| C-47 | PathInfo: 空時スラッシュ付加 | E-01 (L164-165) EmptyStr判定でLPrefix='/' | ○ |
| C-48 | PathInfo: 非空時そのまま返却 | E-01 (L166) LPrefix + PathInfo | ○ |
| C-49 | RawWebRequest: 元のWebRequest返却 | E-01 (L314-317) FWebRequest返却 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全テストケースはソースコード `Horse.Request.pas` の実装から直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全てのテストケースがソースコードの実装に基づいており、根拠が明確です

### 注意点
- **FPC/Delphi条件コンパイル**: ソースコードには `{$IF DEFINED(FPC)}` による条件分岐が多数存在します。テスト実行時は両方の環境での動作確認が推奨されます（UT-REQ-041, UT-REQ-042）
- **コンパイラバージョン依存**: `{$IF CompilerVersion <= 30}` 等の分岐があるため、古いバージョンでのテストも考慮が必要です（InitializeContentFields内）
- **遅延初期化パターン**: Headers, Query, Params, Cookie, ContentFieldsは全て遅延初期化されるため、初回アクセス前後の状態確認が重要です

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全publicメソッドを網羅しているか確認
- [ ] 境界値テスト（空文字、nil、空配列）が適切に定義されているか確認
- [ ] FPC/Delphi両環境での動作を考慮したテストケースか確認
- [ ] メモリ管理（Create/Destroy、Body設定時の既存オブジェクト解放）のテストが含まれているか確認
- [ ] 遅延初期化パターンの初回/2回目アクセスのテストが含まれているか確認
- [ ] InitializeQuery, InitializeCookieのパースロジックが正しくテストされているか確認
