---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：Horse.WebModule 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **UT-WBM-024**：境界値テスト - Requestがnilの場合の挙動が未定義
  2. **UT-WBM-025**：境界値テスト - Responseがnilの場合の挙動が未定義

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/src/Horse.WebModule.pas` - メインソースファイル（117行）
- E-02: `/src/Horse.WebModule.dfm` - Delphiフォーム定義ファイル（11行）
- E-03: `/src/Horse.WebModule.lfm` - Lazarusフォーム定義ファイル（9行）
- E-04: `/src/Horse.Core.pas` - THorseCoreクラス定義（540行）
- E-05: `/src/Horse.Exception.Interrupted.pas` - EHorseCallbackInterrupted例外クラス（34行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-WBM-001) | コンストラクタでTHorseCoreインスタンスが取得される | E-01 (76行目: FHorse := THorseCore.GetInstance) | ○ |
| C-02 (UT-WBM-002) | コンストラクタでFInstanceにSelfが設定される | E-01 (77行目: FInstance := Self) | ○ |
| C-03 (UT-WBM-003) | Delphiモードで親クラスのCreateが呼び出される | E-01 (74行目: inherited) | ○ |
| C-04 (UT-WBM-004) | FPCモードでCreateNewが呼び出される | E-01 (72行目: inherited CreateNew(AOwner, 0)) | ○ |
| C-05 (UT-WBM-005) | GetInstanceでFInstanceが返却される | E-01 (64-67行目) | ○ |
| C-06 (UT-WBM-006) | Create前にGetInstanceを呼び出した場合nilが返却される | E-01 (66行目: Result := FInstance、初期値nil) | ○ |
| C-07 (UT-WBM-007) | HandledがTrueに設定される | E-01 (93行目: Handled := True) | ○ |
| C-08 (UT-WBM-008) | THorseRequestが生成される | E-01 (94行目: LRequest := THorseRequest.Create(Request)) | ○ |
| C-09 (UT-WBM-009) | THorseResponseが生成される | E-01 (95行目: LResponse := THorseResponse.Create(Response)) | ○ |
| C-10 (UT-WBM-010) | FHorse.Routes.Executeが呼び出される | E-01 (98行目: FHorse.Routes.Execute(LRequest, LResponse)) | ○ |
| C-11 (UT-WBM-011) | THorseRequestが解放される | E-01 (107行目: LRequest.Free) | ○ |
| C-12 (UT-WBM-012) | THorseResponseが解放される | E-01 (108行目: LResponse.Free) | ○ |
| C-13 (UT-WBM-013) | Body<TObject>とContentが同一の場合Content(nil)が呼び出される | E-01 (105-106行目) | ○ |
| C-14 (UT-WBM-014) | Body<TObject>とContentが異なる場合Content(nil)が呼び出されない | E-01 (105行目: if文の条件) | ○ |
| C-15 (UT-WBM-015) | EHorseCallbackInterruptedは再スローしない | E-01 (100-102行目), E-05 | ○ |
| C-16 (UT-WBM-016) | EHorseCallbackInterrupted以外の例外は再スローされる | E-01 (101-102行目: if not ... then raise) | ○ |
| C-17 (UT-WBM-017) | 例外発生時もfinallyブロックでリソースが解放される | E-01 (104-108行目: try-finally構造) | ○ |
| C-18 (UT-WBM-018) | FPCモードでHandlerActionに委譲される | E-01 (80-84行目: DoOnRequest) | ○ |
| C-19 (UT-WBM-019) | Horseプロパティの読み取り | E-01 (33行目: property Horse: THorseCore read FHorse) | ○ |
| C-20 (UT-WBM-020) | Horseプロパティの書き込み | E-01 (33行目: property Horse: THorseCore ... write FHorse) | ○ |
| C-21 (UT-WBM-021) | FPCモードでRegisterHTTPModuleが呼び出される | E-01 (113-114行目: initialization節) | ○ |
| C-22 (UT-WBM-022) | DefaultHandlerアクションが定義されている | E-02 (4-8行目: Actions定義) | ○ |
| C-23 (UT-WBM-023) | DefaultHandlerがデフォルトアクションに設定されている | E-02 (5行目: Default = True) | ○ |
| C-24 (UT-WBM-024) | Requestがnilの場合の挙動 | **根拠なし** | △ |
| C-25 (UT-WBM-025) | Responseがnilの場合の挙動 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **nilパラメータに対する境界値テスト**：ソースコードにはRequestやResponseがnilの場合のガード処理が明示的に記述されていないため、実際の挙動は実行時に確認が必要
  - 候補：THorseRequest.Create / THorseResponse.Create の実装を確認 / 統合テストで検証

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：全体的に単純なWebModule実装であり、主要なロジックはTHorseCoreに委譲されている
- **1（中リスク）**：リソース管理（try-finally）が適切に実装されているが、循環参照チェック（105行目）の意図について確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] UT-WBM-015/016：EHorseCallbackInterruptedの例外処理が期待通り動作するか確認
- [ ] UT-WBM-013/014：Body<TObject>とContentの比較ロジックの意図を確認（循環参照防止？）
- [ ] UT-WBM-024/025：nil入力に対する境界値テストの実装方針を決定
- [ ] FPC/Delphiの条件コンパイルが正しくテストされるか確認（両環境でのテスト実行が必要）
