---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 224
  claims_with_evidence: 224
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Horse単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の対応するメソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：主要なクラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：ソースコード上に対応するメソッド/クラスが確認できる
- 状態「△」：推測または間接的な根拠のみ

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各モジュールのカバレッジを確認
3. 「不足情報」で補完が必要なテスト観点を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：224 / 224、根拠なし：0
- 優先レビュー（高）
  1. **THorseCore系テスト（UT-HOR-123〜143）**：フレームワークのコア機能
  2. **THorseRequest/Response系テスト（UT-HOR-032〜069）**：HTTP処理の基盤
  3. **THorseRouterTree系テスト（UT-HOR-145〜161）**：ルーティング機能

## 2) 参照した情報（Evidence一覧）
> ソースコードファイルから直接抽出した根拠

- E-01: `src/Horse.pas` - メインユニット、THorseCore, THorseModule定義
- E-02: `src/Horse.Commons.pas` - THTTPStatus, TMimeTypes, TLhsBracketsType, TMethodType定義
- E-03: `src/Horse.Callback.pas` - THorseCallback型定義
- E-04: `src/Horse.Constants.pas` - DEFAULT_HOST, DEFAULT_PORT, START_RUNNING定数
- E-05: `src/Horse.EnvironmentVariables.pas` - THorseEnvironmentVariables定義（CGI用）
- E-06: `src/Horse.Exception.pas` - EHorseException例外クラス
- E-07: `src/Horse.Exception.Interrupted.pas` - EHorseCallbackInterrupted例外クラス
- E-08: `src/Horse.Mime.pas` - THorseMimeTypes、MIMEタイプマッピング定義
- E-09: `src/Horse.Proc.pas` - TProc型定義（FPC用）
- E-10: `src/Horse.Request.pas` - THorseRequest、リクエスト処理
- E-11: `src/Horse.Response.pas` - THorseResponse、レスポンス処理
- E-12: `src/Horse.Session.pas` - THorseSessions、セッション管理
- E-13: `src/Horse.WebModule.pas` - THorseWebModule、Webモジュール
- E-14: `src/Horse.Rtti.pas` - THorseRtti、RTTI処理
- E-15: `src/Horse.Rtti.Helper.pas` - THorseRttiTypeHelper、RTTIヘルパー
- E-16: `src/Horse.Core.pas` - THorseCore、フレームワークコア
- E-17: `src/Horse.Core.Param.pas` - THorseCoreParam、パラメータ処理
- E-18: `src/Horse.Core.Param.Config.pas` - THorseCoreParamConfig、パラメータ設定
- E-19: `src/Horse.Core.Param.Field.pas` - THorseCoreParamField、フィールド処理
- E-20: `src/Horse.Core.Param.Field.Brackets.pas` - THorseCoreParamFieldLhsBrackets、LHSブラケット
- E-21: `src/Horse.Core.Param.Header.pas` - THorseCoreParamHeader、ヘッダー処理
- E-22: `src/Horse.Core.Route.pas` - THorseCoreRoute、ルートビルダー
- E-23: `src/Horse.Core.Route.Contract.pas` - IHorseCoreRoute、ルートインターフェース
- E-24: `src/Horse.Core.Group.pas` - THorseCoreGroup、グループビルダー
- E-25: `src/Horse.Core.Group.Contract.pas` - IHorseCoreGroup、グループインターフェース
- E-26: `src/Horse.Core.Files.pas` - THorseCoreFile、ファイル処理
- E-27: `src/Horse.Core.RouterTree.pas` - THorseRouterTree、ルーティングツリー
- E-28: `src/Horse.Core.RouterTree.NextCaller.pas` - TNextCaller、次のコールバック呼び出し
- E-29: `src/Horse.Provider.Abstract.pas` - THorseProviderAbstract、プロバイダー基底
- E-30: `src/Horse.Provider.Console.pas` - THorseProvider（Console版）
- E-31: `src/Horse.Provider.VCL.pas` - THorseProvider（VCL版）
- E-32: `src/Horse.Provider.CGI.pas` - THorseProvider（CGI版）
- E-33: `src/Horse.Provider.ISAPI.pas` - THorseProvider（ISAPI版）
- E-34: `src/Horse.Provider.Apache.pas` - THorseProvider（Apache版）
- E-35: `src/Horse.Provider.Daemon.pas` - THorseProvider（Daemon版）
- E-36: `src/Horse.Provider.IOHandleSSL.pas` - THorseProviderIOHandleSSL、SSL処理
- E-37: `src/Horse.Provider.IOHandleSSL.Contract.pas` - IHorseProviderIOHandleSSL、SSLインターフェース
- E-38: `src/Horse.Provider.FPC.HTTPApplication.pas` - THorseProvider（FPC HTTP版）
- E-39: `src/Horse.Provider.FPC.LCL.pas` - THorseProvider（FPC LCL版）、THTTPServerThread
- E-40: `src/Horse.Provider.FPC.CGI.pas` - THorseProvider（FPC CGI版）
- E-41: `src/Horse.Provider.FPC.Apache.pas` - THorseProvider（FPC Apache版）
- E-42: `src/Horse.Provider.FPC.FastCGI.pas` - THorseProvider（FPC FastCGI版）
- E-43: `src/Horse.Provider.FPC.Daemon.pas` - THorseProvider（FPC Daemon版）
- E-44: `src/ThirdParty.Posix.Syslog.pas` - Syslog関数（POSIX）
- E-45: `src/Web.WebConst.pas` - HTTPステータス定数

## 3) Claims と根拠の対応（レビューの主戦場）

### Horse.Commons（UT-HOR-001〜014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THTTPStatus.ToInteger | E-02 | ○ |
| C-02 | THTTPStatus各ステータス変換 | E-02 | ○ |
| C-03 | TMimeTypes.ToString | E-02 | ○ |
| C-04 | TLhsBracketsType.ToString | E-02 | ○ |
| C-05 | MatchRoute関数 | E-02 | ○ |
| C-06 | StringCommandToMethodType | E-02 | ○ |

### Horse.Exception（UT-HOR-015〜026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 | EHorseException.Create初期化 | E-06 | ○ |
| C-08 | Error/Status/Title/Hint/Unit/Detail設定 | E-06 | ○ |
| C-09 | ToJSON/ToJSONObject | E-06 | ○ |
| C-10 | EHorseException.Newファクトリ | E-06 | ○ |
| C-11 | EHorseCallbackInterrupted | E-07 | ○ |

### Horse.Mime（UT-HOR-027〜031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | THorseMimeTypes.GetFileType | E-08 | ○ |
| C-13 | THorseMimeTypes.GetExtType | E-08 | ○ |
| C-14 | デフォルトMIMEタイプ | E-08 | ○ |

### Horse.Request（UT-HOR-032〜049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | THorseRequest.Create | E-10 | ○ |
| C-16 | Body/Body<T> | E-10 | ○ |
| C-17 | Headers/Query/Params/ContentFields/Cookie | E-10 | ○ |
| C-18 | Session<T> | E-10 | ○ |
| C-19 | MethodType/ContentType/PathInfo/Host | E-10 | ○ |
| C-20 | IsMultipartForm/IsFormURLEncoded | E-10 | ○ |

### Horse.Response（UT-HOR-050〜069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | THorseResponse.Create | E-11 | ○ |
| C-22 | Send/Send<T> | E-11 | ○ |
| C-23 | Status設定（Integer/THTTPStatus） | E-11 | ○ |
| C-24 | AddHeader/RemoveHeader | E-11 | ○ |
| C-25 | ContentType/RedirectTo | E-11 | ○ |
| C-26 | SendFile/Download/Render | E-11 | ○ |

### Horse.Session（UT-HOR-070〜077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | THorseSessions.Create | E-12 | ○ |
| C-28 | SetSession/GetSession | E-12 | ○ |
| C-29 | Contains/TryGetSession | E-12 | ○ |

### Horse.Core.Param（UT-HOR-078〜091）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | THorseCoreParam.Create | E-17 | ○ |
| C-31 | Required/ContainsKey/ContainsValue | E-17 | ○ |
| C-32 | Items/Field/ToArray/TryGetValue | E-17 | ○ |
| C-33 | Count/Content/AddStream | E-17 | ○ |

### Horse.Core.Param.Field（UT-HOR-092〜114）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | AsString/AsInteger/AsInt64/AsFloat | E-19 | ○ |
| C-35 | AsBoolean/AsDate/AsDateTime/AsTime | E-19 | ○ |
| C-36 | AsISO8601DateTime/AsStream/AsList | E-19 | ○ |
| C-37 | SaveToFile/Required/DateFormat/TimeFormat | E-19 | ○ |
| C-38 | 型変換エラー処理 | E-19 | ○ |

### Horse.Core.Param.Field.Brackets（UT-HOR-115〜116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | THorseCoreParamFieldLhsBrackets.SetValue/GetValue | E-20 | ○ |

### Horse.Core.Param.Config（UT-HOR-117〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | THorseCoreParamConfig.GetInstance | E-18 | ○ |
| C-41 | DateFormat/TimeFormat/RequiredMessage | E-18 | ○ |
| C-42 | ReturnUTC/CheckLhsBrackets | E-18 | ○ |

### Horse.Core（UT-HOR-123〜144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | THorseCore.Create/GetInstance | E-16, E-01 | ○ |
| C-44 | Get/Post/Put/Delete/Patch/Head/All | E-16 | ○ |
| C-45 | Use（ミドルウェア） | E-16 | ○ |
| C-46 | AddCallback/AddCallbacks | E-16 | ○ |
| C-47 | Route/Group/Routes/Version | E-16 | ○ |
| C-48 | THorseModule | E-01 | ○ |

### Horse.Core.RouterTree（UT-HOR-145〜161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | THorseRouterTree.Create | E-27 | ○ |
| C-50 | RegisterRoute/RegisterMiddleware | E-27 | ○ |
| C-51 | Execute（ルート実行） | E-27 | ○ |
| C-52 | Prefix/GetPrefix/CreateRouter | E-27 | ○ |
| C-53 | TNextCaller.Init/Next | E-28 | ○ |

### Horse.Core.Route（UT-HOR-162〜168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | THorseCoreRoute.Create | E-22 | ○ |
| C-55 | Get/Post/Put/Delete/All/End | E-22 | ○ |

### Horse.Core.Group（UT-HOR-169〜175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | THorseCoreGroup.Create | E-24 | ○ |
| C-57 | Prefix/Route/Get/Post/Use/End | E-24 | ○ |

### Horse.Core.Files（UT-HOR-176〜181）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | THorseCoreFile.Create | E-26 | ○ |
| C-59 | ContentStream/ContentType/Size | E-26 | ○ |

### Horse.Rtti（UT-HOR-182〜187）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | THorseRtti.Create/GetInstance/GetType | E-14 | ○ |
| C-61 | THorseRttiTypeHelper.FieldValueAsObject | E-15 | ○ |

### Horse.WebModule（UT-HOR-188〜192）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | THorseWebModule.Create/GetInstance | E-13 | ○ |
| C-63 | HandlerAction | E-13 | ○ |

### Horse.EnvironmentVariables（UT-HOR-193〜194）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | THorseEnvironmentVariables.GetEnvironmentVariable | E-05 | ○ |
| C-65 | THorseEnvironmentVariables.GetEnvironmentVariables | E-05 | ○ |

### Horse.Core.Param.Header（UT-HOR-195）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | THorseCoreParamHeader.GetHeaders | E-21 | ○ |

### Horse.Provider（UT-HOR-196〜222）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | THorseProviderAbstract.DoOnListen/DoOnStopListen | E-29 | ○ |
| C-68 | THorseProviderIOHandleSSL各メソッド | E-36 | ○ |
| C-69 | THorseProvider(Console).Listen/StopListen | E-30 | ○ |
| C-70 | THorseProvider設定（Port/Host/MaxConnections） | E-30 | ○ |

### ThirdParty.Posix.Syslog（UT-HOR-223〜224）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Syslog関数 | E-44 | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし** - 全テストケースに対してソースコード上の根拠が確認できました

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されています

### 補足事項
1. **プラットフォーム依存コード**: FPC（Free Pascal Compiler）とDelphi両対応のため、条件コンパイル（`{$IF DEFINED(FPC)}`等）が多用されています。テスト実行時は対象プラットフォームを明確にする必要があります。

2. **プロバイダー多様性**: Console, VCL, CGI, ISAPI, Apache, Daemon, FPC各種など複数のプロバイダーが存在します。テストは使用するプロバイダーに応じて選択的に実行する必要があります。

3. **外部依存**: SSL機能（`IdSSLOpenSSL`）、Indy HTTP（`IdHTTPWebBrokerBridge`）等の外部ライブラリに依存するテストは、対応するライブラリがインストールされている環境でのみ実行可能です。

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPステータスコード変換（UT-HOR-001〜003）が全ステータスをカバーしているか
- [ ] MIMEタイプ判定（UT-HOR-027〜031）が主要なファイル形式をカバーしているか
- [ ] リクエスト/レスポンス処理（UT-HOR-032〜069）の境界値テストが十分か
- [ ] パラメータ型変換（UT-HOR-092〜114）のエラー処理が網羅されているか
- [ ] ルーティング（UT-HOR-145〜161）のパターンマッチングが網羅されているか
- [ ] SSL設定（UT-HOR-199〜209）のセキュリティ観点が考慮されているか
- [ ] プロバイダー（UT-HOR-210〜222）の起動/停止シーケンスが適切か
