---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Web.WebConst 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 6行目 - `sDuplicateActionName`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 8-10行目 - `sCannotGenerateSessionId`（条件付きコンパイル）
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 12行目 - `sOnlyOneDispatcher`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 14-18行目 - `sOnlyOneSessionManager`, `sOnlyOneAuthenticator`, `sOnlyOneAuthorizer`（条件付きコンパイル）
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 20-25行目 - HTTP項目ラベル定数群
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 27行目 - `sResNotFound`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 29-31行目 - テーブル関連定数
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 33-48行目 - `sInternalApplicationError`（HTMLテンプレート）
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 50-58行目 - Webファイル拡張子・ディレクトリ関連定数
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/horse-master/src/Web.WebConst.pas` 60-66行目 - URLエンコード・ファクトリ関連定数（条件付きコンパイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sDuplicateActionNameが'Duplicate action name'を返却 | E-01 | ○ |
| C-02 | sCannotGenerateSessionIdが'Cannot generate session ID'を返却 | E-02 | ○ |
| C-03 | sOnlyOneDispatcherが'Only one WebDispatcher per form/data module'を返却 | E-03 | ○ |
| C-04 | sOnlyOneSessionManagerが'Only one SessionManager per form/data module'を返却 | E-04 | ○ |
| C-05 | sOnlyOneAuthenticatorが'Only one Authenticator per form/data module'を返却 | E-04 | ○ |
| C-06 | sOnlyOneAuthorizerが'Only one Authorizer per form/data module'を返却 | E-04 | ○ |
| C-07 | sHTTPItemNameが'Name'を返却 | E-05 | ○ |
| C-08 | sHTTPItemURIが'PathInfo'を返却 | E-05 | ○ |
| C-09 | sHTTPItemEnabledが'Enabled'を返却 | E-05 | ○ |
| C-10 | sHTTPItemDefaultが'Default'を返却 | E-05 | ○ |
| C-11 | sHTTPItemProducerが'Producer'を返却 | E-05 | ○ |
| C-12 | sHTTPItemMethodが'Method'を返却 | E-05 | ○ |
| C-13 | sResNotFoundがフォーマット文字列として機能 | E-06 | ○ |
| C-14 | sTooManyColumnsが'Too many table columns'を返却 | E-07 | ○ |
| C-15 | sFieldNameColumnが'Field Name'を返却 | E-07 | ○ |
| C-16 | sFieldTypeColumnが'Field Type'を返却 | E-07 | ○ |
| C-17 | sInternalApplicationErrorがHTML形式エラーページを返却 | E-08 | ○ |
| C-18 | sInternalApplicationErrorにフォーマットパラメータ適用可能 | E-08 | ○ |
| C-19 | sWebFileExtensionItemExtensionsが'Extensions'を返却 | E-09 | ○ |
| C-20 | sWebFileExtensionItemMimeTypeが'Mime Type'を返却 | E-09 | ○ |
| C-21 | sDuplicateMimeTypesがフォーマット文字列として機能 | E-09 | ○ |
| C-22 | sWebFileDirectoryItemMaskが'Directory Mask'を返却 | E-09 | ○ |
| C-23 | sWebFileDirectoryItemActionが'Action'を返却 | E-09 | ○ |
| C-24 | sWebFileExtensionsItemDisplayNameがフォーマット文字列として機能 | E-09 | ○ |
| C-25 | sWebDirectoryIncludeが'Include'を返却 | E-09 | ○ |
| C-26 | sWebDirectoryExcludeが'Exclude'を返却 | E-09 | ○ |
| C-27 | sWebDirectoryItemDisplayNameがフォーマット文字列として機能 | E-09 | ○ |
| C-28 | sErrorDecodingURLTextが'Error decoding URL text'を返却 | E-10 | ○ |
| C-29 | sInvalidURLEncodedCharが'Invalid URL encoded char'を返却 | E-10 | ○ |
| C-30 | sInvalidHTMLEncodedCharが'Invalid HTML encoded char'を返却 | E-10 | ○ |
| C-31 | sFactoryAlreadyRegisteredが'Factory already registered'を返却 | E-10 | ○ |
| C-32 | sAppFactoryAlreadyRegisteredが'App factory already registered'を返却 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目：なし
- 補足：Web.WebConstは純粋な定数定義ユニットであり、すべてのテストケースはソースコードの定数定義に直接対応している

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールは定数定義のみで構成されており、ビジネスロジックを含まない
- 0: 低リスク - 条件付きコンパイル（CompilerVersion条件）の存在を考慮したテストケースを作成済み
- 0: 低リスク - フォーマット文字列（%s, %0:s, %1:s）を含む定数についてはFormat関数適用テストを追加済み

## 6) レビュアーチェックリスト（最小）
- [ ] 定数値がソースコードと一致しているか確認
- [ ] 条件付きコンパイル（$IF CompilerVersion > 36.0, $IF DEFINED(FPC)）の前提条件が正確か確認
- [ ] フォーマット文字列のパラメータ数・位置が正しいか確認（%s, %0:s, %1:s）
- [ ] sInternalApplicationErrorのHTMLテンプレートが有効なHTMLとして構成されているか確認
- [ ] 多言語対応（ローカライズ）の必要性がある場合、resourcestringが適切に使用されているか確認
