---
generated_at: 2026-01-22 19:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **UAT-040（パフォーマンスシナリオ）**：同時接続の具体的な仕様がコードから明確に読み取れない
  2. **UAT-041（互換性シナリオ）**：全Delphiバージョンでの動作確認はドキュメントベース
  3. **UAT-035/036/037（デプロイメントシナリオ）**：外部依存のテスト環境が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット、THorseクラス定義
- E-02: `src/Horse.Core.pas` - コアロジック、HTTPメソッド登録
- E-03: `src/Horse.Request.pas` - リクエスト処理、パラメータ取得
- E-04: `src/Horse.Response.pas` - レスポンス処理、ステータスコード設定
- E-05: `src/Horse.Commons.pas` - HTTPステータス、MIMEタイプ定義
- E-06: `src/Horse.Core.RouterTree.pas` - ルーティングロジック
- E-07: `src/Horse.Core.Group.pas` - ルートグループ機能
- E-08: `src/Horse.Core.Route.pas` - ルート定義インターフェース
- E-09: `src/Horse.Provider.Console.pas` - コンソールプロバイダー
- E-10: `src/Horse.Provider.VCL.pas` - VCLプロバイダー
- E-11: `src/Horse.Exception.pas` - カスタム例外クラス
- E-12: `src/Horse.Session.pas` - セッション管理
- E-13: `src/Horse.Core.Param.pas` - パラメータ処理
- E-14: `tests/src/tests/Tests.Api.Console.pas` - テストコード
- E-15: `tests/src/controllers/Controllers.Api.pas` - サンプルAPI実装
- E-16: `samples/delphi/console/Console.dpr` - サンプルアプリケーション
- E-17: `README.md` - プロジェクトドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サーバー起動（THorse.Listen）が正常に動作する | E-09, E-16 | ○ |
| C-02 | VCLアプリケーションでのサーバー起動が可能 | E-10 | ○ |
| C-03 | GETリクエストが処理できる | E-02, E-14, E-15 | ○ |
| C-04 | POSTリクエストが処理できる | E-02, E-14, E-15 | ○ |
| C-05 | PUTリクエストが処理できる | E-02, E-15 | ○ |
| C-06 | DELETEリクエストが処理できる | E-02, E-15 | ○ |
| C-07 | PATCHリクエストが処理できる | E-02 | ○ |
| C-08 | HEADリクエストが処理できる | E-02 | ○ |
| C-09 | パスパラメータが取得できる | E-03, E-06, E-15 | ○ |
| C-10 | クエリパラメータが取得できる | E-03 | ○ |
| C-11 | ルートグループ機能が動作する | E-07, E-15 | ○ |
| C-12 | グローバルミドルウェアが適用される | E-02, E-06 | ○ |
| C-13 | パス指定ミドルウェアが動作する | E-06 | ○ |
| C-14 | 複数ミドルウェアチェーンが順序通り実行される | E-06 | ○ |
| C-15 | リクエストボディが取得できる | E-03 | ○ |
| C-16 | レスポンス送信が正常に動作する | E-04 | ○ |
| C-17 | HTTPステータスコードが設定できる | E-04, E-05 | ○ |
| C-18 | カスタムヘッダーが設定できる | E-04 | ○ |
| C-19 | リダイレクト処理が正常に動作する | E-04 | ○ |
| C-20 | ファイル送信が動作する | E-04 | ○ |
| C-21 | ファイルダウンロードが動作する | E-04 | ○ |
| C-22 | HTMLレンダリングが動作する | E-04 | ○ |
| C-23 | マルチパートフォームが処理できる | E-03 | ○ |
| C-24 | セッションオブジェクトが設定できる | E-03, E-12 | ○ |
| C-25 | 複数セッションが管理できる | E-12 | ○ |
| C-26 | カスタム例外が正しくレスポンスされる | E-11 | ○ |
| C-27 | 例外の詳細情報がJSON化される | E-11 | ○ |
| C-28 | ポート・ホスト設定が反映される | E-09, E-14 | ○ |
| C-29 | 最大接続数が設定できる | E-09, E-14 | ○ |
| C-30 | Keep-Alive設定が反映される | E-09 | ○ |
| C-31 | SSL/TLSが有効化できる | E-09 | ○ |
| C-32 | サーバー停止が正常に動作する | E-09, E-14 | ○ |
| C-33 | コールバック付きサーバー起動が動作する | E-09, E-14 | ○ |
| C-34 | Lazarus/FPCで動作する | E-01, E-17 | ○ |
| C-35 | Apache統合が可能 | E-01 | ○ |
| C-36 | CGIとして動作する | E-01 | ○ |
| C-37 | Windowsサービスとして動作する | E-01 | ○ |
| C-38 | 存在しないルートで404が返る | E-06 | ○ |
| C-39 | 許可されていないメソッドで適切なエラーが返る | E-06 | ○ |
| C-40 | 同時接続が適切に処理される | **根拠なし** | △ |
| C-41 | 複数Delphiバージョンで動作する | E-17 | △ |
| C-42 | ワイルドカードルートが動作する | E-06 | ○ |
| C-43 | Cookieが取得できる | E-03 | ○ |
| C-44 | リクエストヘッダーが取得できる | E-03 | ○ |
| C-45 | Content-Typeが設定できる | E-04 | ○ |
| C-46 | ライブラリバージョンが取得できる | E-02 | ○ |
| C-47 | モジュール変換が動作する | E-02, E-14 | ○ |
| C-48 | URLエンコードフォームが処理できる | E-03 | ○ |
| C-49 | Allメソッドで全HTTPメソッドに対応できる | E-02 | ○ |
| C-50 | コールバック中断が正しく動作する | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス仕様**：同時接続数の上限や処理性能に関する具体的な仕様がコードから明確に読み取れない
  - 候補：負荷テスト結果 / ベンチマーク資料 / パフォーマンス要件定義書
- **互換性テスト結果**：全対応Delphiバージョンでの動作確認結果
  - 候補：CI/CDテスト結果 / 互換性テストレポート
- **デプロイメント手順**：Apache/CGI/Windowsサービス統合の詳細手順
  - 候補：デプロイメントガイド / 運用マニュアル
- **負荷テストシナリオ**：具体的な負荷テスト条件と期待値
  - 候補：非機能要件定義書 / SLA文書
- **セキュリティテスト仕様**：SSL/TLS設定の詳細なテスト手順
  - 候補：セキュリティ要件定義書 / 暗号化設定ガイド

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - UAT-040（パフォーマンステスト）: 具体的な性能基準がないため、テスト合否判定が曖昧になる可能性
- **1: 中リスク** - UAT-041（互換性テスト）: 全Delphiバージョンでのテスト環境構築が必要
- **1: 中リスク** - UAT-031（SSL/TLS）: 証明書管理やセキュリティ設定の詳細仕様が不明確
- **0: 低リスク** - デプロイメント関連テスト（UAT-035/036/037）: 外部環境依存のため実行環境の準備が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UAT-001〜UAT-006）のテスト手順が実行可能か確認
- [ ] パスパラメータ・クエリパラメータの取得テスト（UAT-009/010）が実際のコードと整合しているか確認
- [ ] ミドルウェアテスト（UAT-012〜014）のチェーン動作が正しく理解されているか確認
- [ ] 例外処理テスト（UAT-026/027）のJSON出力形式が実装と一致しているか確認
- [ ] SSL/TLS設定テスト（UAT-031）の証明書ファイルパスと設定項目が正しいか確認
- [ ] パフォーマンステスト（UAT-040）の具体的な合格基準を定義すること
- [ ] 互換性テスト（UAT-041）の対象バージョン一覧がREADMEと一致しているか確認
