---
generated_at: 2026-01-22 00:00:00
metrics:
  claims_total: 55
  claims_with_evidence: 52
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：52 / 55、根拠なし：3
- 優先レビュー（高）
  1. **BR-054**：モジュールエクスポート機能の詳細仕様が不明確
  2. **BR-055**：バージョン定数の具体的な値が確認できず
  3. **BR-038**：LHS Brackets機能の実際の利用シナリオが不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインユニット、型定義とプロバイダー切替
- E-02: `src/Horse.Core.pas` - コアルーティング機能（Get/Post/Put/Delete/Patch/Head/All/Use）
- E-03: `src/Horse.Core.RouterTree.pas` - ルーターツリー実装、動的パラメータ処理
- E-04: `src/Horse.Core.Route.pas` - ルートチェーン実装
- E-05: `src/Horse.Core.Group.pas` - グループ化機能実装
- E-06: `src/Horse.Request.pas` - リクエスト処理（Body/Query/Params/Headers/Cookie/ContentFields）
- E-07: `src/Horse.Response.pas` - レスポンス処理（Send/Status/SendFile/Download/Render/Redirect）
- E-08: `src/Horse.Core.Param.pas` - パラメータ管理、型変換
- E-09: `src/Horse.Core.Param.Config.pas` - パラメータ設定（DateFormat/TimeFormat/RequiredMessage）
- E-10: `src/Horse.Core.Param.Field.Brackets.pas` - LHS Brackets実装
- E-11: `src/Horse.Provider.Console.pas` - コンソールプロバイダー（Listen/StopListen/MaxConnections/SSL設定）
- E-12: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（OnListen/OnStopListen）
- E-13: `src/Horse.Exception.pas` - カスタム例外（ToJSON/ToJSONObject）
- E-14: `src/Horse.Session.pas` - セッション管理
- E-15: `src/Horse.Commons.pas` - 共通定義（THTTPStatus/TMimeTypes/TMethodType）
- E-16: `src/Horse.Core.Files.pas` - ファイル処理
- E-17: `src/Horse.Callback.pas` - コールバック型定義
- E-18: `README.md` - プロジェクト概要、クイックスタート、ミドルウェア一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 HTTPメソッド別ルーティング登録 | E-02 (Get/Post/Put/Delete/Patch/Head/All関数) | ○ |
| C-02 | BR-002 動的パスパラメータ対応 | E-03 (FIsParamsKey, FTag) | ○ |
| C-03 | BR-003 ルートグループ化 | E-05 (THorseCoreGroup, Prefix) | ○ |
| C-04 | BR-004 ルートチェーン登録 | E-04 (THorseCoreRoute) | ○ |
| C-05 | BR-005 グローバルミドルウェア登録 | E-02 (Use関数, FMiddleware) | ○ |
| C-06 | BR-006 パス別ミドルウェア登録 | E-02, E-03 (Use(Path, Callback), RegisterMiddleware) | ○ |
| C-07 | BR-007 ミドルウェアチェーン実行 | E-03, E-17 (TNextCaller, THorseCallback) | ○ |
| C-08 | BR-008 リクエストボディ取得 | E-06 (Body関数) | ○ |
| C-09 | BR-009 クエリパラメータ取得 | E-06 (Query関数, InitializeQuery) | ○ |
| C-10 | BR-010 パスパラメータ取得 | E-06 (Params関数) | ○ |
| C-11 | BR-011 HTTPヘッダー取得 | E-06 (Headers関数) | ○ |
| C-12 | BR-012 Cookie取得 | E-06 (Cookie関数, InitializeCookie) | ○ |
| C-13 | BR-013 フォームデータ取得 | E-06 (ContentFields, IsMultipartForm, IsFormURLEncoded) | ○ |
| C-14 | BR-014 ファイルアップロード処理 | E-06, E-08 (AddStream) | ○ |
| C-15 | BR-015 セッション管理 | E-06, E-14 (Session, THorseSessions) | ○ |
| C-16 | BR-016 テキストレスポンス送信 | E-07 (Send(string)) | ○ |
| C-17 | BR-017 オブジェクトレスポンス送信 | E-07 (Send<T>) | ○ |
| C-18 | BR-018 HTTPステータスコード設定 | E-07 (Status関数) | ○ |
| C-19 | BR-019 レスポンスヘッダー追加 | E-07 (AddHeader) | ○ |
| C-20 | BR-020 レスポンスヘッダー削除 | E-07 (RemoveHeader) | ○ |
| C-21 | BR-021 リダイレクト処理 | E-07 (RedirectTo, THTTPStatus.SeeOther) | ○ |
| C-22 | BR-022 ファイルレスポンス送信（インライン） | E-07 (SendFile, Content-Disposition: inline) | ○ |
| C-23 | BR-023 ファイルダウンロードレスポンス | E-07 (Download, Content-Disposition: attachment) | ○ |
| C-24 | BR-024 HTMLレンダリング | E-07 (Render, TMimeTypes.TextHTML) | ○ |
| C-25 | BR-025 Content-Type設定 | E-07 (ContentType関数) | ○ |
| C-26 | BR-026 サーバー起動 | E-11 (Listen, InternalListen) | ○ |
| C-27 | BR-027 サーバー停止 | E-11 (StopListen, InternalStopListen) | ○ |
| C-28 | BR-028 起動状態確認 | E-11 (IsRunning, FRunning) | ○ |
| C-29 | BR-029 最大接続数設定 | E-11 (MaxConnections, FMaxConnections) | ○ |
| C-30 | BR-030 接続キュー設定 | E-11 (ListenQueue, FListenQueue) | ○ |
| C-31 | BR-031 Keep-Alive設定 | E-11 (KeepConnectionAlive, FKeepConnectionAlive) | ○ |
| C-32 | BR-032 SSL/TLS対応 | E-11 (IHorseProviderIOHandleSSL, InitServerIOHandlerSSLOpenSSL) | ○ |
| C-33 | BR-033 SSL証明書設定 | E-11 (CertFile, RootCertFile, KeyFile) | ○ |
| C-34 | BR-034 SSL暗号スイート設定 | E-11 (CipherList, Method, SSLVersions) | ○ |
| C-35 | BR-035 必須パラメータ検証 | E-08, E-09 (Required, FRequired, RequiredMessage) | ○ |
| C-36 | BR-036 パラメータ型変換 | E-08 (THorseCoreParamField各種メソッド) | ○ |
| C-37 | BR-037 パラメータ存在チェック | E-08 (ContainsKey, ContainsValue) | ○ |
| C-38 | BR-038 LHS Brackets対応 | E-10 (THorseCoreParamFieldLhsBrackets) | △ |
| C-39 | BR-039 日付フォーマット設定 | E-09 (DateFormat, FDateFormat) | ○ |
| C-40 | BR-040 時刻フォーマット設定 | E-09 (TimeFormat, FTimeFormat) | ○ |
| C-41 | BR-041 UTC返却設定 | E-09 (ReturnUTC, FReturnUTC) | ○ |
| C-42 | BR-042 Boolean真値設定 | E-09 (TrueValue, FTrueValue) | ○ |
| C-43 | BR-043 検証メッセージ設定 | E-09 (RequiredMessage, InvalidFormatMessage) | ○ |
| C-44 | BR-044 カスタム例外発生 | E-13 (EHorseException, Status/Error/Code/Detail) | ○ |
| C-45 | BR-045 例外JSON変換 | E-13 (ToJSON, ToJSONObject) | ○ |
| C-46 | BR-046 コールバック中断例外 | E-01 (EHorseCallbackInterrupted) | ○ |
| C-47 | BR-047 MIMEタイプ判定 | E-16 (THorseMimeTypes.GetFileType) | ○ |
| C-48 | BR-048 MIMEタイプ定数 | E-15 (TMimeTypes, TMimeTypesHelper.ToString) | ○ |
| C-49 | BR-049 HTTPステータス定数 | E-15 (THTTPStatus, THTTPStatusHelper.ToInteger) | ○ |
| C-50 | BR-050 マルチプラットフォーム対応 | E-01 (条件コンパイル、各種プロバイダーユニット参照) | ○ |
| C-51 | BR-051 イベントコールバック | E-12 (OnListen, OnStopListen, DoOnListen, DoOnStopListen) | ○ |
| C-52 | BR-052 ファイル読込 | E-16 (THorseCoreFile, ContentStream, Size) | ○ |
| C-53 | BR-053 ルートプレフィックス設定 | E-03 (Prefix, FPrefix, GetPrefix) | ○ |
| C-54 | BR-054 モジュールエクスポート | E-02 (THorseModule, ToModule) | △ |
| C-55 | BR-055 バージョン情報取得 | E-02 (Version, HORSE_VERSION) | △ |

## 4) 不足情報（Unknown / Missing）
- **BR-038（LHS Brackets対応）**：コード上で実装は確認できるが、実際の利用例やドキュメントが見当たらない
  - 候補：README.md / サンプルコード / 外部ミドルウェア
- **BR-054（モジュールエクスポート）**：THorseModuleの実装は存在するが、具体的な使用例が不明
  - 候補：サンプルコード / テストコード / 外部ドキュメント
- **BR-055（バージョン情報取得）**：Version関数は存在するが、HORSE_VERSION定数の定義場所が確認できず
  - 候補：Horse.Constants.pas（未読）/ ビルド時生成

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：BR-001〜BR-037, BR-039〜BR-053
  - コード上で明確に実装が確認でき、機能仕様が明確
- **1（中リスク）**：BR-038, BR-054, BR-055
  - 実装は存在するが、利用シナリオや詳細仕様の確認が必要
- **2（高リスク）**：なし
  - 全ての業務要件について、少なくともコード上での実装根拠が存在

## 6) レビュアーチェックリスト（最小）
- [ ] BR-038のLHS Brackets機能が実際に利用されているか確認
- [ ] BR-054のモジュールエクスポート機能の使用例を確認
- [ ] HORSE_VERSION定数の定義場所と現在のバージョン値を確認
- [ ] 各プロバイダー（VCL/Console/CGI/ISAPI/Apache/Daemon）の個別動作確認
- [ ] SSL/TLS設定の実際の動作テスト
- [ ] サードパーティミドルウェアとの互換性確認
