---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 56
  claims_with_evidence: 56
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：56 / 56、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全ての機能についてソースコードで根拠を確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.pas` - メインエントリポイント、型定義
- E-02: `src/Horse.Core.pas` - コアルーティング機能（Get, Post, Put, Delete, Patch, Head, All, Use等）
- E-03: `src/Horse.Request.pas` - リクエスト処理機能（Body, Query, Params, Headers, Cookie, ContentFields, Session）
- E-04: `src/Horse.Response.pas` - レスポンス処理機能（Send, Status, SendFile, Download, Render, RedirectTo, AddHeader等）
- E-05: `src/Horse.Provider.Console.pas` - Consoleプロバイダー（Listen, StopListen, Port, Host, MaxConnections, SSL設定）
- E-06: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー基底クラス
- E-07: `src/Horse.Core.RouterTree.pas` - ルーティングツリー（パスパラメータ、正規表現ルーティング）
- E-08: `src/Horse.Core.Group.pas` - ルートグループ機能
- E-09: `src/Horse.Core.Route.pas` - ルート定義機能
- E-10: `src/Horse.Core.Param.pas` - パラメータ処理機能
- E-11: `src/Horse.Exception.pas` - 例外クラス定義
- E-12: `src/Horse.Commons.pas` - HTTPステータス、MIMEタイプ定義
- E-13: `src/Horse.Session.pas` - セッション管理機能
- E-14: `src/Horse.Core.Files.pas` - ファイル処理機能
- E-15: `README.md` - プロジェクト概要、対応プラットフォーム情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET リクエスト処理 | E-02 | ○ |
| C-02 | POST リクエスト処理 | E-02 | ○ |
| C-03 | PUT リクエスト処理 | E-02 | ○ |
| C-04 | DELETE リクエスト処理 | E-02 | ○ |
| C-05 | PATCH リクエスト処理 | E-02 | ○ |
| C-06 | HEAD リクエスト処理 | E-02 | ○ |
| C-07 | ALL リクエスト処理 | E-02 | ○ |
| C-08 | ミドルウェア登録 | E-02 | ○ |
| C-09 | コールバック追加 | E-02 | ○ |
| C-10 | リクエストボディ取得 | E-03 | ○ |
| C-11 | クエリパラメータ取得 | E-03 | ○ |
| C-12 | パスパラメータ取得 | E-03 | ○ |
| C-13 | ヘッダー取得 | E-03 | ○ |
| C-14 | Cookie取得 | E-03 | ○ |
| C-15 | ContentFields取得 | E-03 | ○ |
| C-16 | セッション管理 | E-03, E-13 | ○ |
| C-17 | テキストレスポンス送信 | E-04 | ○ |
| C-18 | ステータスコード設定 | E-04 | ○ |
| C-19 | ファイル送信 | E-04 | ○ |
| C-20 | ファイルダウンロード | E-04 | ○ |
| C-21 | HTMLレンダリング | E-04 | ○ |
| C-22 | リダイレクト | E-04 | ○ |
| C-23 | ヘッダー追加 | E-04 | ○ |
| C-24 | ヘッダー削除 | E-04 | ○ |
| C-25 | Content-Type設定 | E-04 | ○ |
| C-26 | サーバー起動 | E-05 | ○ |
| C-27 | サーバー停止 | E-05 | ○ |
| C-28 | ポート設定 | E-05 | ○ |
| C-29 | ホスト設定 | E-05 | ○ |
| C-30 | 最大接続数設定 | E-05 | ○ |
| C-31 | SSL/TLS設定 | E-05 | ○ |
| C-32 | ルートグループ化 | E-08 | ○ |
| C-33 | ルート定義 | E-09 | ○ |
| C-34 | プレフィックス設定 | E-08 | ○ |
| C-35 | パスパラメータ対応 | E-07 | ○ |
| C-36 | 正規表現ルーティング | E-07 | ○ |
| C-37 | フィールド型変換 | E-10 | ○ |
| C-38 | 必須パラメータ検証 | E-10 | ○ |
| C-39 | 日付フォーマット設定 | E-10 | ○ |
| C-40 | カスタム例外 | E-11 | ○ |
| C-41 | 例外JSON変換 | E-11 | ○ |
| C-42 | 割り込み例外 | E-01 | ○ |
| C-43 | HTTPステータス定義 | E-12 | ○ |
| C-44 | MIMEタイプ定義 | E-12 | ○ |
| C-45 | MIMEタイプ判定 | E-14 | ○ |
| C-46 | ファイル処理 | E-14 | ○ |
| C-47 | バージョン取得 | E-02 | ○ |
| C-48 | セッション登録 | E-13 | ○ |
| C-49 | セッション取得 | E-13 | ○ |
| C-50 | Console プロバイダー | E-05 | ○ |
| C-51 | VCL プロバイダー | E-01 | ○ |
| C-52 | CGI プロバイダー | E-01 | ○ |
| C-53 | ISAPI プロバイダー | E-01 | ○ |
| C-54 | Apache プロバイダー | E-01 | ○ |
| C-55 | Daemon プロバイダー | E-01 | ○ |
| C-56 | Lazarus対応 | E-01, E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全ての機能についてソースコードから根拠を確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HTTPルーティング機能（GET/POST/PUT/DELETE/PATCH/HEAD/ALL）が正しく動作するか実行確認
- [ ] ミドルウェア機能が期待通りに動作するか確認
- [ ] リクエスト/レスポンス処理機能が仕様通りか確認
- [ ] 各プロバイダー（Console, VCL, CGI, ISAPI, Apache, Daemon）の動作確認
- [ ] Lazarus/Free Pascal環境での互換性確認
- [ ] SSL/TLS設定が正しく機能するか確認
