# 機能設計書 11-クエリパラメータ取得

## 概要

本ドキュメントは、Horse WebフレームワークにおけるURLクエリパラメータ取得機能の設計を記述する。THorseRequest.Queryメソッドによる実装を対象とする。

### 本機能の処理概要

この機能は、HTTPリクエストのURLに含まれるクエリパラメータ（?key=value形式）を取得し、アプリケーション内で利用可能にする。

**業務上の目的・背景**：Webアプリケーションでは、検索条件やフィルタリング条件、ページネーション情報など、多くのパラメータをURLクエリストリングとして受け取る。この機能により、クライアントから送信されたクエリパラメータを簡単に取得し、ビジネスロジックで活用できる。RESTful APIの設計において、GET リクエストでのパラメータ受け渡しの標準的な手法として不可欠な機能である。

**機能の利用シーン**：検索APIでのキーワード取得、一覧表示APIでのページ番号・表示件数の取得、フィルタリング条件の受け取り、ソート順序の指定など、GET リクエストを中心とした多くの場面で利用される。

**主要な処理内容**：
1. HTTPリクエストオブジェクトからクエリフィールドを抽出
2. キーと値のペアを内部辞書に格納
3. 同一キーで複数の値がある場合はカンマ区切りで連結
4. THorseCoreParamオブジェクトとして返却し、型変換や必須検証を提供

**関連システム・外部連携**：Delphiの標準WebライブラリであるTWebRequest（Delphi）またはTRequest（Free Pascal）から生のクエリフィールドを取得し、Horse独自のパラメータ処理クラスでラップする。

**権限による制御**：本機能自体は認証・認可の制御を行わない。クエリパラメータの内容に基づくアクセス制御は、アプリケーション側のミドルウェアやハンドラで実装する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

データ取得処理 / パラメータ解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AKey | string | Yes | 取得したいクエリパラメータのキー名 | なし（大文字小文字を区別しない比較） |

### 入力データソース

HTTPリクエストのクエリストリング（URL中の?以降の部分）。TWebRequest.QueryFields（Delphi）またはTRequest.QueryFields（Free Pascal）から取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | THorseCoreParam | クエリパラメータを格納したパラメータオブジェクト |
| Items[key] | string | 指定キーに対応する値（存在しない場合は空文字列） |
| Count | Integer | パラメータの総数 |

### 出力先

呼び出し元のコールバック関数に返却

## 処理フロー

### 処理シーケンス

```
1. Query メソッドの呼び出し
   └─ FQueryがnilかチェック
2. InitializeQuery の実行（初回アクセス時のみ）
   └─ THorseCoreParam オブジェクトの生成
   └─ Required(False) で必須検証を無効化
3. QueryFields のループ処理
   └─ 各パラメータを "=" で分割
   └─ キーと値を抽出
4. 重複キーの処理
   └─ 既存キーがある場合はカンマで値を連結
   └─ 新規キーの場合はそのまま追加
5. THorseCoreParam オブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Query メソッド呼び出し] --> B{FQuery が nil?}
    B -->|Yes| C[InitializeQuery 実行]
    B -->|No| G[FQuery を返却]
    C --> D[THorseCoreParam 生成]
    D --> E[QueryFields をループ]
    E --> F{キーが既存?}
    F -->|Yes| H[カンマ区切りで値を連結]
    F -->|No| I[新規キーとして追加]
    H --> J{次のパラメータあり?}
    I --> J
    J -->|Yes| E
    J -->|No| G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-11-01 | 遅延初期化 | クエリパラメータは最初のアクセス時に1回だけ初期化される | Query メソッドの初回呼び出し時 |
| BR-11-02 | 大文字小文字非区別 | キー名の比較は大文字小文字を区別しない | パラメータ取得時 |
| BR-11-03 | 重複キーの連結 | 同一キーで複数の値がある場合、カンマで連結 | パラメータ解析時 |
| BR-11-04 | デフォルト非必須 | クエリパラメータはデフォルトで必須検証が無効 | パラメータオブジェクト生成時 |

### 計算ロジック

クエリパラメータの解析ロジック：
```
1. "=" の最初の出現位置を取得（LEqualFirstPos）
2. キー = Copy(LItem, 1, LEqualFirstPos - 1)
3. 値 = Copy(LItem, LEqualFirstPos + 1, Length(LItem))
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | EHorseException | Field.Required設定後に存在しないキーをAsString等で取得 | 必須フィールドを必ず送信するか、Required(False)を使用 |
| 400 | BadRequest | 型変換エラー（AsInteger等で数値以外を取得） | 正しい形式のパラメータを送信 |

### リトライ仕様

リトライ処理は不要（即座に結果を返す同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ内処理のみ）

## パフォーマンス要件

- パラメータ解析は O(n) の計算量（n = クエリパラメータ数）
- 遅延初期化により不要な場合の処理を回避
- 内部辞書によるO(1)のキー検索

## セキュリティ考慮事項

- クエリパラメータはURLに含まれるため、サーバーログに記録される可能性がある
- 機密情報（パスワード、トークン等）はクエリパラメータで送信すべきでない
- SQLインジェクション対策はアプリケーション側で実施する必要がある

## 備考

Free Pascal (FPC) と Delphi の両方に対応した条件コンパイルを使用している。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パラメータを格納するデータ構造の理解が最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | THorseCoreParam クラスの構造、THorseList 型（TDictionary<string, string>）の定義 |
| 1-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | THorseCoreParamField クラスによる型変換メソッド群 |

**読解のコツ**: THorseListは`TDictionary<string, string>`の型エイリアスであり、キーと値のペアを格納する。FParamsフィールドがこの辞書を保持する。

#### Step 2: エントリーポイントを理解する

リクエストオブジェクトからクエリパラメータにアクセスする入口を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequest.Query メソッドがエントリーポイント |

**主要処理フロー**:
1. **307-312行目**: Query メソッド - FQueryがnilの場合にInitializeQueryを呼び出す遅延初期化パターン
2. **243-259行目**: InitializeQuery メソッド - 実際のクエリパラメータ解析処理

#### Step 3: パラメータ解析処理を理解する

クエリストリングの解析ロジックを詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Request.pas | `src/Horse.Request.pas` | InitializeQuery メソッドの実装 |

**主要処理フロー**:
- **248行目**: THorseCoreParam.Create でパラメータオブジェクトを生成
- **249-258行目**: QueryFieldsをループし、キーと値を抽出
- **251-253行目**: "="位置でキーと値を分割
- **254-257行目**: 重複キーの処理（カンマ連結）

#### Step 4: パラメータ値の取得と型変換を理解する

取得したパラメータを実際に利用する際の型変換処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | Field メソッドによる THorseCoreParamField の生成 |
| 4-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | AsString, AsInteger 等の型変換メソッド |

**主要処理フロー**:
- **99-126行目** (Horse.Core.Param.pas): Field メソッドでフィールドオブジェクトを生成
- **277-284行目** (Horse.Core.Param.Field.pas): AsString による文字列取得
- **176-189行目** (Horse.Core.Param.Field.pas): AsInteger による整数変換

### プログラム呼び出し階層図

```
THorseRequest.Query
    │
    ├─ InitializeQuery（初回のみ）
    │      ├─ THorseCoreParam.Create
    │      │      └─ THorseList.Create（TDictionary生成）
    │      └─ FWebRequest.QueryFields ループ処理
    │
    └─ THorseCoreParam を返却
           │
           ├─ Items[key] : 直接値取得
           ├─ Field(key) : フィールドオブジェクト取得
           │      └─ THorseCoreParamField
           │             ├─ AsString
           │             ├─ AsInteger
           │             ├─ AsBoolean
           │             └─ ...
           └─ ContainsKey(key) : キー存在確認
```

### データフロー図

```
[入力]                      [処理]                         [出力]

HTTP Request URL
  ?name=value&page=1   ──▶ THorseRequest.Query       ──▶ THorseCoreParam
                              │
                              ├─ InitializeQuery
                              │     │
                              │     ├─ "=" で分割
                              │     └─ Dictionary に格納
                              │
                              └─ THorseCoreParam 返却
                                        │
                                        ├─ Items['name'] ──▶ "value"
                                        ├─ Items['page'] ──▶ "1"
                                        └─ Field('page').AsInteger ──▶ 1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequest クラス、Query メソッドの実装 |
| Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | ソース | THorseCoreParam クラス、パラメータ管理 |
| Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | ソース | THorseCoreParamField クラス、型変換 |
| Horse.Core.Param.Config.pas | `src/Horse.Core.Param.Config.pas` | ソース | パラメータ設定（日付フォーマット等） |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | 共通型定義、THTTPStatus等 |
| Horse.Exception.pas | `src/Horse.Exception.pas` | ソース | EHorseException 例外クラス |
