# 機能設計書 12-パスパラメータ取得

## 概要

本ドキュメントは、Horse WebフレームワークにおけるURLパスに埋め込まれたパラメータを取得する機能の設計を記述する。THorseRequest.Paramsメソッドによる実装を対象とする。

### 本機能の処理概要

この機能は、URLパスに埋め込まれたパラメータ（/:id形式）を取得し、アプリケーション内で利用可能にする。RESTful APIでリソースの識別子を取得する際に使用される。

**業務上の目的・背景**：RESTful APIの設計において、リソースの識別はURLパスで行うことが標準的である。例えば `/users/:id` のようなエンドポイントで、`:id` 部分に実際のユーザーIDが入る。この機能により、URLに埋め込まれた動的なパラメータを簡単に取得でき、リソースの特定や操作が可能になる。これはCRUD操作やリソースベースのAPI設計において不可欠な機能である。

**機能の利用シーン**：特定リソースの取得（GET /users/:id）、リソースの更新（PUT /products/:id）、リソースの削除（DELETE /orders/:id）、ネストされたリソースのアクセス（GET /users/:userId/orders/:orderId）など、RESTful APIのほぼ全ての操作で利用される。

**主要な処理内容**：
1. ルーティングエンジンがURLパスを解析し、パラメータを抽出
2. 抽出されたパラメータをTHorseCoreParamオブジェクトに格納
3. ハンドラ内でParams.Items['id']等でアクセス可能
4. 必須パラメータとして扱い、存在しない場合は例外発生

**関連システム・外部連携**：THorseRouterTreeクラスがURLパスのマッチングとパラメータ抽出を担当。抽出されたパラメータはTHorseRequestオブジェクトに渡される。

**権限による制御**：本機能自体は認証・認可の制御を行わない。パスパラメータの値に基づくアクセス制御は、アプリケーション側のミドルウェアやハンドラで実装する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

データ取得処理 / パラメータ解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AKey | string | Yes | 取得したいパスパラメータ名（コロンなし） | なし（大文字小文字を区別しない比較） |

### 入力データソース

URLパス（ルート定義の `:param` 部分に対応する実際の値）。THorseRouterTreeがパスマッチング時に抽出し、THorseRequest.Paramsに格納。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | THorseCoreParam | パスパラメータを格納したパラメータオブジェクト |
| Items[key] | string | 指定キーに対応する値（存在しない場合は空文字列） |
| Count | Integer | パラメータの総数 |

### 出力先

呼び出し元のコールバック関数に返却

## 処理フロー

### 処理シーケンス

```
1. ルート定義時に /:param 形式でパスパラメータを指定
   └─ 例: THorse.Get('/users/:id', DoGetUser)
2. リクエスト受信時にルーティングエンジンがパスをマッチ
   └─ /users/123 がマッチし、id=123 を抽出
3. 抽出されたパラメータを THorseCoreParam に格納
4. Params メソッドの呼び出し
   └─ FParamsがnilかチェック
5. InitializeParams の実行（初回アクセス時のみ）
   └─ Required(True) で必須検証を有効化
6. THorseCoreParam オブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[ルート定義 /:param] --> B[リクエスト受信]
    B --> C[ルーティングエンジンがパスマッチ]
    C --> D[パラメータ抽出 id=123]
    D --> E[THorseRequest 生成]
    E --> F[Params メソッド呼び出し]
    F --> G{FParams が nil?}
    G -->|Yes| H[InitializeParams 実行]
    G -->|No| I[FParams を返却]
    H --> J[THorseCoreParam 生成]
    J --> K[Required True 設定]
    K --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-12-01 | 遅延初期化 | パスパラメータは最初のアクセス時に1回だけ初期化される | Params メソッドの初回呼び出し時 |
| BR-12-02 | 大文字小文字非区別 | キー名の比較は大文字小文字を区別しない | パラメータ取得時 |
| BR-12-03 | 必須パラメータ | パスパラメータはデフォルトで必須検証が有効 | パラメータオブジェクト生成時 |
| BR-12-04 | コロンプレフィックス | ルート定義では `:` で始まる部分がパラメータ | ルート登録時 |

### 計算ロジック

パスパラメータのマッチングロジック（THorseRouterTree内）：
```
1. ルート定義のパスを "/" で分割
2. 各セグメントが ":" で始まる場合はパラメータとして扱う
3. リクエストパスの対応するセグメントの値を抽出
4. パラメータ名（コロン除去）と値のペアを Dictionary に格納
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | EHorseException | 必須のパスパラメータにアクセスしたが値が空 | 正しいURLでリクエスト |
| 400 | BadRequest | 型変換エラー（AsInteger等で数値以外を取得） | 正しい形式のパラメータを送信 |

### リトライ仕様

リトライ処理は不要（即座に結果を返す同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ内処理のみ）

## パフォーマンス要件

- パラメータ取得は O(1)〜O(n) の計算量（キー検索）
- 遅延初期化により不要な場合の処理を回避
- ルーティング時のパラメータ抽出はパスセグメント数に比例

## セキュリティ考慮事項

- パスパラメータは URL に含まれるため、アクセスログに記録される
- 数値IDの場合、連番推測攻撃に注意（UUIDの使用を推奨）
- パスパラメータを直接SQLクエリに使用しない（SQLインジェクション対策）

## 備考

パスパラメータはクエリパラメータと異なり、デフォルトで必須（Required=True）として扱われる。これは、パスパラメータが存在しない場合は通常ルートがマッチしないためである。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パラメータを格納するデータ構造の理解が最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | THorseCoreParam クラスの構造、Required メソッド |
| 1-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | THorseCoreParamField クラスによる型変換 |

**読解のコツ**: パスパラメータはクエリパラメータと同じTHorseCoreParamクラスを使用するが、初期化時に`Required(True)`が設定される点が異なる。

#### Step 2: エントリーポイントを理解する

リクエストオブジェクトからパスパラメータにアクセスする入口を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequest.Params メソッドがエントリーポイント |

**主要処理フロー**:
1. **300-305行目**: Params メソッド - FParamsがnilの場合にInitializeParamsを呼び出す
2. **238-241行目**: InitializeParams メソッド - Required(True)で必須検証を有効化

#### Step 3: ルーティングエンジンを理解する

パスパラメータの抽出はルーティング時に行われる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.RouterTree.pas | `src/Horse.Core.RouterTree.pas` | パスマッチングとパラメータ抽出のロジック |

**主要処理フロー**:
- ルート定義時に `:param` 形式を認識
- リクエスト時にパスを分割し、パラメータ部分を抽出
- 抽出した値をTHorseRequest.Params.Dictionaryに格納

#### Step 4: パラメータ値の取得と型変換を理解する

取得したパラメータを実際に利用する際の型変換処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | GetItem, ContainsKey メソッド |
| 4-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | AsString, AsInteger の必須検証付き処理 |

**主要処理フロー**:
- **179-189行目** (Horse.Core.Param.pas): GetItem による値取得
- **277-284行目** (Horse.Core.Param.Field.pas): AsString で必須検証実行

### プログラム呼び出し階層図

```
ルート定義 THorse.Get('/users/:id', Handler)
    │
    └─ THorseRouterTree.RegisterRoute
           └─ `:id` をパラメータとして認識

リクエスト処理 GET /users/123
    │
    ├─ THorseRouterTree.GetCallback
    │      ├─ パスマッチング /users/123 ⟷ /users/:id
    │      └─ パラメータ抽出 id=123
    │
    └─ THorseRequest.Params
           │
           ├─ InitializeParams（初回のみ）
           │      └─ Required(True) 設定
           │
           └─ THorseCoreParam 返却
                  │
                  ├─ Items['id'] ──▶ "123"
                  └─ Field('id').AsInteger ──▶ 123
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ルート定義
  /users/:id          ──▶ THorseRouterTree           ──▶ パラメータ定義
                              │
リクエスト                      │
  GET /users/123       ──▶ パスマッチング             ──▶ id=123 抽出
                              │
                              ├─ THorseRequest.Params
                              │     │
                              │     └─ Required(True)
                              │
                              └─ THorseCoreParam 返却
                                        │
                                        ├─ Items['id'] ──▶ "123"
                                        └─ Field('id').AsInteger ──▶ 123
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequest クラス、Params メソッドの実装 |
| Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | ソース | THorseCoreParam クラス、パラメータ管理 |
| Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | ソース | THorseCoreParamField クラス、型変換 |
| Horse.Core.RouterTree.pas | `src/Horse.Core.RouterTree.pas` | ソース | ルーティングエンジン、パラメータ抽出 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | MatchRoute関数、パスマッチングユーティリティ |
| Horse.Exception.pas | `src/Horse.Exception.pas` | ソース | EHorseException 例外クラス |
