# 機能設計書 13-ヘッダー取得

## 概要

本ドキュメントは、Horse WebフレームワークにおけるHTTPリクエストヘッダーを取得する機能の設計を記述する。THorseRequest.Headersメソッドによる実装を対象とする。

### 本機能の処理概要

この機能は、HTTPリクエストに含まれるヘッダー情報（Content-Type、Authorization、User-Agent等）を取得し、アプリケーション内で利用可能にする。

**業務上の目的・背景**：HTTPヘッダーは認証情報（Authorizationヘッダー）、コンテンツタイプの指定、キャッシュ制御、クライアント識別など、多くの重要な情報を含む。この機能により、クライアントから送信されたヘッダー情報を取得し、認証・認可処理、コンテンツネゴシエーション、トラッキングなどの高度な処理が可能になる。APIの認証やセキュリティ実装において必須の機能である。

**機能の利用シーン**：Bearer認証のトークン取得、Content-Type確認によるリクエスト形式の判定、Accept-Languageによる多言語対応、User-Agentによるクライアント識別、X-Forwarded-Forによる実クライアントIP取得、カスタムヘッダーによるアプリケーション固有の情報受け取りなど。

**主要な処理内容**：
1. HTTPリクエストオブジェクトからヘッダー一覧を抽出
2. プロバイダー種別（Console、VCL、CGI、Apache、ISAPI）に応じた取得方法を選択
3. 標準ヘッダーとカスタムヘッダーを統合
4. THorseCoreParamオブジェクトとして返却

**関連システム・外部連携**：Delphiの標準WebライブラリであるTWebRequest/TRequest、Indyライブラリ（TIdHTTPRequestInfo）、Apache/IIS固有のAPI等からヘッダー情報を取得する。

**権限による制御**：本機能自体は認証・認可の制御を行わない。取得したヘッダー（Authorization等）を使用した認証処理は、アプリケーション側のミドルウェアで実装する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

データ取得処理 / ヘッダー解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AKey | string | Yes | 取得したいヘッダー名 | なし（大文字小文字を区別しない比較） |

### 入力データソース

HTTPリクエストヘッダー。取得元はプロバイダー種別により異なる：
- Console/VCL: TIdHTTPRequestInfo.RawHeaders（Indyライブラリ）
- CGI: 環境変数（HTTP_*プレフィックス）
- Apache: Prequest_rec^.headers_in
- ISAPI: ALL_RAWフィールド
- FPC: TFPHTTPConnectionRequest.CustomHeaders

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | THorseCoreParam | ヘッダーを格納したパラメータオブジェクト |
| Items[key] | string | 指定キーに対応するヘッダー値（存在しない場合は空文字列） |
| Count | Integer | ヘッダーの総数 |

### 出力先

呼び出し元のコールバック関数に返却

## 処理フロー

### 処理シーケンス

```
1. Headers メソッドの呼び出し
   └─ FHeadersがnilかチェック
2. THorseCoreParamHeader.GetHeaders の呼び出し
   └─ プロバイダー種別の判定
3. プロバイダー固有のヘッダー取得処理
   └─ Console/VCL: Indy経由でRawHeaders取得
   └─ CGI: 環境変数からHTTP_*を抽出
   └─ Apache: apr_table経由で取得
   └─ ISAPI: ALL_RAWフィールドから取得
   └─ FPC: CustomHeadersとTHeader列挙を使用
4. ヘッダー名と値のペアをDictionaryに格納
5. THorseCoreParam オブジェクトを生成して返却
   └─ Required(False) で必須検証を無効化
```

### フローチャート

```mermaid
flowchart TD
    A[Headers メソッド呼び出し] --> B{FHeaders が nil?}
    B -->|Yes| C[GetHeaders 呼び出し]
    B -->|No| K[FHeaders を返却]
    C --> D{プロバイダー種別}
    D -->|Console/VCL| E[Indy RawHeaders取得]
    D -->|CGI| F[環境変数から取得]
    D -->|Apache| G[apr_table から取得]
    D -->|ISAPI| H[ALL_RAW から取得]
    D -->|FPC| I[CustomHeaders + THeader取得]
    E --> J[THorseCoreParam 生成]
    F --> J
    G --> J
    H --> J
    I --> J
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-13-01 | 遅延初期化 | ヘッダーは最初のアクセス時に1回だけ初期化される | Headers メソッドの初回呼び出し時 |
| BR-13-02 | 大文字小文字非区別 | ヘッダー名の比較は大文字小文字を区別しない | ヘッダー取得時 |
| BR-13-03 | デフォルト非必須 | ヘッダーはデフォルトで必須検証が無効 | パラメータオブジェクト生成時 |
| BR-13-04 | プロバイダー依存 | ヘッダー取得方法はプロバイダー種別により異なる | ヘッダー取得時 |
| BR-13-05 | CGIヘッダー正規化 | CGIの環境変数形式（HTTP_CONTENT_TYPE）を標準形式（Content-Type）に変換 | CGIモード時 |

### 計算ロジック

CGIヘッダー名の正規化ロジック：
```
1. HTTP_プレフィックスを除去
2. アンダースコアをハイフンに変換
3. 各単語の先頭を大文字化
例: HTTP_CONTENT_TYPE → Content-Type
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 例外なし | 存在しないヘッダーを取得 | 空文字列を返す（例外は発生しない） |

### リトライ仕様

リトライ処理は不要（即座に結果を返す同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ内処理のみ）

## パフォーマンス要件

- ヘッダー解析は O(n) の計算量（n = ヘッダー数）
- 遅延初期化により不要な場合の処理を回避
- 内部辞書によるO(1)のキー検索

## セキュリティ考慮事項

- Authorizationヘッダーには認証トークン等の機密情報が含まれる可能性
- ヘッダー情報をログに出力する際は、機密ヘッダーをマスクすることを推奨
- X-Forwarded-For等のヘッダーは偽装可能なため、信頼できるプロキシ経由の場合のみ使用

## 備考

プロバイダー種別によりヘッダー取得の実装が大きく異なる。条件コンパイルディレクティブ（HORSE_APACHE、HORSE_CGI、HORSE_ISAPI）により適切な実装が選択される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘッダーを格納するデータ構造の理解が最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | THorseCoreParam クラスの構造 |
| 1-2 | Horse.Core.Param.Header.pas | `src/Horse.Core.Param.Header.pas` | THorseCoreParamHeader クラスの定義 |

**読解のコツ**: THorseCoreParamHeaderはクラスメソッドGetHeadersを持ち、プロバイダー種別に応じたヘッダー取得処理を行う。

#### Step 2: エントリーポイントを理解する

リクエストオブジェクトからヘッダーにアクセスする入口を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequest.Headers メソッドがエントリーポイント |

**主要処理フロー**:
1. **137-147行目**: Headers メソッド - FHeadersがnilの場合にGetHeadersを呼び出す
2. **143行目**: THorseCoreParamHeader.GetHeaders でヘッダー取得
3. **144行目**: Required(False) で必須検証を無効化

#### Step 3: プロバイダー別のヘッダー取得処理を理解する

プロバイダー種別に応じたヘッダー取得の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.Param.Header.pas | `src/Horse.Core.Param.Header.pas` | GetHeaders、GetHeadersList メソッド |

**主要処理フロー**:
- **57-89行目**: GetHeaders - ヘッダー一覧を取得してDictionaryに格納
- **114-185行目**: GetHeadersList - プロバイダー別の生ヘッダー取得
- **137-138行目**: ISAPI - ALL_RAWフィールドから取得
- **139-151行目**: Apache - apr_tableから取得
- **152-172行目**: CGI - 環境変数から取得
- **173-179行目**: Console/VCL - Indy経由で取得
- **94-110行目**: FPC - CustomHeadersとTHeader列挙から取得

#### Step 4: CGIヘッダー名の正規化を理解する

CGIモードでのヘッダー名変換処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Core.Param.Header.pas | `src/Horse.Core.Param.Header.pas` | NormalizeEnvVarHeaderName メソッド |

**主要処理フロー**:
- **190-201行目**: HTTP_プレフィックス除去、アンダースコアをハイフンに変換、各単語の先頭大文字化

### プログラム呼び出し階層図

```
THorseRequest.Headers
    │
    ├─ THorseCoreParamHeader.GetHeaders
    │      │
    │      ├─ GetHeadersList（プロバイダー別）
    │      │      │
    │      │      ├─ ISAPI: GetFieldByName('ALL_RAW')
    │      │      ├─ Apache: apr_table経由
    │      │      ├─ CGI: 環境変数 + NormalizeEnvVarHeaderName
    │      │      ├─ Console/VCL: Indy RawHeaders
    │      │      └─ FPC: CustomHeaders + THeader列挙
    │      │
    │      └─ Dictionary にヘッダー格納
    │
    └─ THorseCoreParam.Create(LParam).Required(False)
           │
           ├─ Items[key] : 直接値取得
           └─ Field(key) : フィールドオブジェクト取得
```

### データフロー図

```
[入力]                           [処理]                         [出力]

HTTP Request Headers
  Authorization: Bearer xxx  ──▶ THorseRequest.Headers    ──▶ THorseCoreParam
  Content-Type: application/json   │
  User-Agent: Mozilla/5.0          ├─ GetHeaders
                                   │     │
                                   │     ├─ プロバイダー判定
                                   │     ├─ 生ヘッダー取得
                                   │     └─ Dictionary 格納
                                   │
                                   └─ THorseCoreParam 返却
                                             │
                                             ├─ Items['Authorization']
                                             │      └─ "Bearer xxx"
                                             └─ Items['Content-Type']
                                                    └─ "application/json"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequest クラス、Headers メソッドの実装 |
| Horse.Core.Param.Header.pas | `src/Horse.Core.Param.Header.pas` | ソース | THorseCoreParamHeader クラス、プロバイダー別ヘッダー取得 |
| Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | ソース | THorseCoreParam クラス、パラメータ管理 |
| Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | ソース | THorseCoreParamField クラス、型変換 |
| Horse.Rtti.pas | `src/Horse.Rtti.pas` | ソース | RTTIヘルパー、Console/VCLでのFRequestInfo取得 |
| Horse.Rtti.Helper.pas | `src/Horse.Rtti.Helper.pas` | ソース | RTTIユーティリティ |
| Horse.EnvironmentVariables.pas | `src/Horse.EnvironmentVariables.pas` | ソース | CGI環境変数取得 |
