# 機能設計書 14-Cookie取得

## 概要

本ドキュメントは、Horse WebフレームワークにおけるHTTPリクエストのCookieを取得する機能の設計を記述する。THorseRequest.Cookieメソッドによる実装を対象とする。

### 本機能の処理概要

この機能は、HTTPリクエストに含まれるCookie情報を取得し、アプリケーション内で利用可能にする。セッション管理やユーザー設定の保持に使用される。

**業務上の目的・背景**：CookieはステートレスなHTTPプロトコルにおいて、クライアント側に状態を保存するための標準的な仕組みである。この機能により、セッションID、ユーザー設定、トラッキング情報などをクライアントから受け取ることができる。認証セッションの維持、ユーザープリファレンスの保持、A/Bテストのグループ分けなど、多くのWeb機能の基盤となる。

**機能の利用シーン**：セッションIDの取得による認証状態の確認、言語設定やテーマ設定の読み取り、ショッピングカート情報の取得、リメンバーミー機能のトークン確認、CSRF対策トークンの検証など。

**主要な処理内容**：
1. HTTPリクエストオブジェクトからCookieフィールドを抽出
2. 各Cookie値を"="で分割してキーと値のペアを取得
3. THorseCoreParamオブジェクトに格納
4. 必須検証を無効化して返却

**関連システム・外部連携**：Delphiの標準WebライブラリであるTWebRequest.CookieFields（Delphi）またはTRequest.CookieFields（Free Pascal）からCookie情報を取得する。

**権限による制御**：本機能自体は認証・認可の制御を行わない。取得したCookie（セッションID等）を使用した認証処理は、アプリケーション側のミドルウェアで実装する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

データ取得処理 / Cookie解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AKey | string | Yes | 取得したいCookie名 | なし（大文字小文字を区別しない比較） |

### 入力データソース

HTTPリクエストのCookieヘッダー。TWebRequest.CookieFields（Delphi）またはTRequest.CookieFields（Free Pascal）から取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | THorseCoreParam | Cookieを格納したパラメータオブジェクト |
| Items[key] | string | 指定キーに対応するCookie値（存在しない場合は空文字列） |
| Count | Integer | Cookieの総数 |

### 出力先

呼び出し元のコールバック関数に返却

## 処理フロー

### 処理シーケンス

```
1. Cookie メソッドの呼び出し
   └─ FCookieがnilかチェック
2. InitializeCookie の実行（初回アクセス時のみ）
   └─ THorseCoreParam オブジェクトの生成
   └─ Required(False) で必須検証を無効化
3. CookieFields のループ処理
   └─ 各Cookieを "=" で分割
   └─ キー(インデックス0)と値(インデックス1)を抽出
4. Dictionary に格納（AddOrSetValue）
5. THorseCoreParam オブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Cookie メソッド呼び出し] --> B{FCookie が nil?}
    B -->|Yes| C[InitializeCookie 実行]
    B -->|No| H[FCookie を返却]
    C --> D[THorseCoreParam 生成]
    D --> E[CookieFields をループ]
    E --> F["=で分割してKey/Value取得"]
    F --> G[Dictionary に格納]
    G --> I{次のCookieあり?}
    I -->|Yes| E
    I -->|No| H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | 遅延初期化 | Cookieは最初のアクセス時に1回だけ初期化される | Cookie メソッドの初回呼び出し時 |
| BR-14-02 | 大文字小文字非区別 | Cookie名の比較は大文字小文字を区別しない | Cookie取得時 |
| BR-14-03 | デフォルト非必須 | Cookieはデフォルトで必須検証が無効 | パラメータオブジェクト生成時 |
| BR-14-04 | 等号分割 | Cookie値は最初の"="で分割 | Cookie解析時 |
| BR-14-05 | 上書き動作 | 同名のCookieがある場合は後の値で上書き | AddOrSetValue使用 |

### 計算ロジック

Cookieの解析ロジック：
```
1. CookieFieldsの各要素を取得
2. "=" でSplit
3. 配列[0] がキー、配列[1] が値
4. Dictionary.AddOrSetValue(key, value)
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 例外なし | 存在しないCookieを取得 | 空文字列を返す（例外は発生しない） |

### リトライ仕様

リトライ処理は不要（即座に結果を返す同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ内処理のみ）

## パフォーマンス要件

- Cookie解析は O(n) の計算量（n = Cookie数）
- 遅延初期化により不要な場合の処理を回避
- 内部辞書によるO(1)のキー検索

## セキュリティ考慮事項

- Cookieにはセッション情報等の機密データが含まれる可能性がある
- HttpOnly属性のCookieはJavaScriptからアクセス不可（サーバー側では取得可能）
- Secure属性のCookieはHTTPS接続でのみ送信される
- CSRF攻撃対策として、重要な操作にはCSRFトークンの検証を推奨

## 備考

Cookieの解析は単純な"="分割を使用している。RFC6265に完全準拠した複雑なCookie値（セミコロン区切りの属性など）の処理は、下位のWebライブラリが担当する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Cookieを格納するデータ構造の理解が最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | THorseCoreParam クラスの構造、THorseList 型 |

**読解のコツ**: Cookieもクエリパラメータやヘッダーと同じTHorseCoreParamクラスを使用。統一されたインターフェースで値にアクセスできる。

#### Step 2: エントリーポイントを理解する

リクエストオブジェクトからCookieにアクセスする入口を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequest.Cookie メソッドがエントリーポイント |

**主要処理フロー**:
1. **105-110行目**: Cookie メソッド - FCookieがnilの場合にInitializeCookieを呼び出す
2. **222-236行目**: InitializeCookie メソッド - 実際のCookie解析処理

#### Step 3: Cookie解析処理を理解する

Cookieの解析ロジックを詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Request.pas | `src/Horse.Request.pas` | InitializeCookie メソッドの実装 |

**主要処理フロー**:
- **222-223行目**: 定数定義 KEY=0, VALUE=1
- **230行目**: THorseCoreParam.Create で空のDictionaryを作成
- **231行目**: CookieFieldsをforループで処理
- **233行目**: "="でSplit
- **234行目**: AddOrSetValueでKey/Valueを格納

#### Step 4: パラメータ値の取得と型変換を理解する

取得したCookieを実際に利用する際のアクセス方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | GetItem、ContainsKey メソッド |
| 4-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | AsString、AsInteger等の型変換 |

**主要処理フロー**:
- **179-189行目** (Horse.Core.Param.pas): GetItem による大文字小文字非区別の検索
- **66-76行目** (Horse.Core.Param.pas): ContainsKey での存在確認

### プログラム呼び出し階層図

```
THorseRequest.Cookie
    │
    ├─ InitializeCookie（初回のみ）
    │      ├─ THorseCoreParam.Create(THorseList.Create)
    │      ├─ Required(False)
    │      └─ FWebRequest.CookieFields ループ処理
    │             ├─ Split(['='])
    │             └─ AddOrSetValue(Key, Value)
    │
    └─ THorseCoreParam を返却
           │
           ├─ Items[key] : 直接値取得
           ├─ Field(key) : フィールドオブジェクト取得
           │      └─ AsString / AsInteger / ...
           └─ ContainsKey(key) : 存在確認
```

### データフロー図

```
[入力]                          [処理]                         [出力]

HTTP Request Cookie Header
  Cookie: session=abc123;     ──▶ THorseRequest.Cookie     ──▶ THorseCoreParam
          lang=ja                    │
                                     ├─ InitializeCookie
                                     │     │
                                     │     ├─ Split("=")
                                     │     │     session=abc123
                                     │     │     lang=ja
                                     │     │
                                     │     └─ Dictionary 格納
                                     │
                                     └─ THorseCoreParam 返却
                                               │
                                               ├─ Items['session'] ──▶ "abc123"
                                               └─ Items['lang'] ──▶ "ja"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequest クラス、Cookie メソッドの実装 |
| Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | ソース | THorseCoreParam クラス、パラメータ管理 |
| Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | ソース | THorseCoreParamField クラス、型変換 |
| Horse.Core.Param.Config.pas | `src/Horse.Core.Param.Config.pas` | ソース | パラメータ設定（日付フォーマット等） |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | 共通型定義 |
