# 機能設計書 15-ContentFields取得

## 概要

本ドキュメントは、Horse WebフレームワークにおけるフォームデータやマルチパートデータのContentFieldsを取得する機能の設計を記述する。THorseRequest.ContentFieldsメソッドによる実装を対象とする。

### 本機能の処理概要

この機能は、HTTPリクエストのボディに含まれるフォームデータ（application/x-www-form-urlencoded）やマルチパートフォームデータ（multipart/form-data）を解析し、アプリケーション内で利用可能にする。ファイルアップロードを含むフォーム送信の処理に使用される。

**業務上の目的・背景**：Webフォームからのデータ送信、特にファイルアップロードを伴う場合は、リクエストボディの解析が必要である。この機能により、HTMLフォームから送信されたテキストフィールド、選択値、アップロードファイルなどを簡単に取得できる。管理画面での一括データ登録、画像アップロード機能、CSV/Excelインポート機能など、多くの業務機能の基盤となる。

**機能の利用シーン**：ユーザー登録フォームの処理、プロフィール画像のアップロード、ドキュメントファイルのインポート、複数フィールドを持つ複雑なフォームの処理、CSVファイルのアップロードとインポートなど。

**主要な処理内容**：
1. Content-Typeの確認（multipart/form-data または application/x-www-form-urlencoded）
2. 対応するContent-Typeの場合のみ処理を実行
3. アップロードファイルをストリームとして取得・格納
4. テキストフィールドをキー・値のペアとして取得・格納
5. THorseCoreParamオブジェクトとして返却

**関連システム・外部連携**：Delphiの標準WebライブラリであるTWebRequest.ContentFields/Filesから生データを取得する。

**権限による制御**：本機能自体は認証・認可の制御を行わない。アップロードされたファイルの種類・サイズ制限などは、アプリケーション側で実装する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能はAPI機能であり、直接関連する画面はない |

## 機能種別

データ取得処理 / フォームデータ解析 / ファイルアップロード処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AKey | string | Yes | 取得したいフィールド名 | なし（大文字小文字を区別しない比較） |

### 入力データソース

HTTPリクエストボディ。以下のContent-Typeをサポート：
- multipart/form-data（ファイルアップロードを含むフォーム）
- application/x-www-form-urlencoded（通常のフォーム送信）

TWebRequest.ContentFields（テキストフィールド）およびTWebRequest.Files（アップロードファイル）から取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | THorseCoreParam | フォームフィールドを格納したパラメータオブジェクト |
| Items[key] | string | 指定キーに対応するテキスト値（存在しない場合は空文字列） |
| Field(key).AsStream | TStream | 指定キーに対応するアップロードファイルのストリーム |
| Count | Integer | フィールドの総数 |

### 出力先

呼び出し元のコールバック関数に返却

## 処理フロー

### 処理シーケンス

```
1. ContentFields メソッドの呼び出し
   └─ FContentFieldsがnilかチェック
2. InitializeContentFields の実行（初回アクセス時のみ）
   └─ THorseCoreParam オブジェクトの生成
   └─ Required(False) で必須検証を無効化
3. CanLoadContentFields による Content-Type 確認
   └─ IsMultipartForm: multipart/form-data かチェック
   └─ IsFormURLEncoded: application/x-www-form-urlencoded かチェック
4. 対応していないContent-Typeの場合は空のパラメータを返却
5. Files のループ処理（ファイルアップロード）
   └─ AddStream でストリームを格納
6. ContentFields のループ処理（テキストフィールド）
   └─ Name/Value を抽出して Dictionary に格納
7. THorseCoreParam オブジェクトを返却
```

### フローチャート

```mermaid
flowchart TD
    A[ContentFields メソッド呼び出し] --> B{FContentFields が nil?}
    B -->|Yes| C[InitializeContentFields 実行]
    B -->|No| L[FContentFields を返却]
    C --> D[THorseCoreParam 生成]
    D --> E{CanLoadContentFields?}
    E -->|No| L
    E -->|Yes| F[Files をループ]
    F --> G[AddStream でファイル格納]
    G --> H[ContentFields をループ]
    H --> I{IsMultipartForm?}
    I -->|Yes| J[multipart 形式で Name/Value 抽出]
    I -->|No| K[標準形式で Name/Value 抽出]
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-15-01 | 遅延初期化 | ContentFieldsは最初のアクセス時に1回だけ初期化される | ContentFields メソッドの初回呼び出し時 |
| BR-15-02 | Content-Type制限 | multipart/form-data と application/x-www-form-urlencoded のみ処理 | フォームデータ取得時 |
| BR-15-03 | デフォルト非必須 | フィールドはデフォルトで必須検証が無効 | パラメータオブジェクト生成時 |
| BR-15-04 | ファイル優先処理 | アップロードファイルはテキストフィールドより先に処理 | フォームデータ解析時 |
| BR-15-05 | 上書き動作 | 同名フィールドがある場合は後の値で上書き | AddOrSetValue使用 |
| BR-15-06 | 空キーの除外 | キー名が空の場合はDictionaryに追加しない | フィールド解析時 |

### 計算ロジック

Content-Typeの判定ロジック：
```
1. IsMultipartForm: ContentType が "multipart/form-data" で始まるか（前方一致）
2. IsFormURLEncoded: ContentType が "application/x-www-form-urlencoded" で始まるか
3. CanLoadContentFields: IsMultipartForm OR IsFormURLEncoded
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 例外なし | 存在しないフィールドを取得 | 空文字列を返す（例外は発生しない） |
| - | 例外なし | 対応していないContent-Type | 空のパラメータオブジェクトを返す |

### リトライ仕様

リトライ処理は不要（即座に結果を返す同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ内処理のみ）

## パフォーマンス要件

- フォームフィールド解析は O(n) の計算量（n = フィールド数 + ファイル数）
- 遅延初期化により不要な場合の処理を回避
- ファイルストリームはメモリにバッファリングされる

## セキュリティ考慮事項

- アップロードファイルのサイズ制限を設けることを推奨
- ファイルタイプの検証（拡張子だけでなくマジックバイトも確認）
- アップロード先ディレクトリのパストラバーサル攻撃対策
- ウイルススキャンの実施を推奨

## 備考

Delphiのバージョンによりマルチパートフォームの解析方法が異なる。CompilerVersion <= 31.0（Tokyo以前）では独自の解析処理が必要。Tokyo以降およびFPCではContentFields.Names/ValueFromIndexで直接アクセス可能。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ContentFieldsを格納するデータ構造の理解が最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | THorseCoreParam クラス、AddStream メソッド |
| 1-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | THorseCoreParamField、AsStream メソッド |

**読解のコツ**: ContentFieldsはテキストフィールドとファイルストリームの両方を格納できる。FFilesがストリーム用、FParamsがテキスト用のDictionary。

#### Step 2: エントリーポイントを理解する

リクエストオブジェクトからContentFieldsにアクセスする入口を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Request.pas | `src/Horse.Request.pas` | THorseRequest.ContentFields メソッドがエントリーポイント |

**主要処理フロー**:
1. **98-103行目**: ContentFields メソッド - FContentFieldsがnilの場合にInitializeContentFieldsを呼び出す
2. **169-220行目**: InitializeContentFields メソッド - 実際のフォームデータ解析処理

#### Step 3: Content-Type判定処理を理解する

フォームデータの種類を判定するロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Request.pas | `src/Horse.Request.pas` | IsMultipartForm、IsFormURLEncoded、CanLoadContentFields メソッド |

**主要処理フロー**:
- **93-96行目**: CanLoadContentFields - IsMultipartForm OR IsFormURLEncoded
- **261-276行目**: IsFormURLEncoded - application/x-www-form-urlencoded の判定
- **278-293行目**: IsMultipartForm - multipart/form-data の判定

#### Step 4: フォームデータ解析処理を理解する

フォームフィールドとファイルの解析ロジックを詳細に理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Request.pas | `src/Horse.Request.pas` | InitializeContentFields の詳細実装 |

**主要処理フロー**:
- **179行目**: THorseCoreParam.Create + Required(False)
- **180-181行目**: CanLoadContentFieldsで対応Content-Typeかチェック
- **183-184行目**: Files（アップロードファイル）をループしてAddStream
- **186-219行目**: ContentFieldsをループしてName/Value抽出
- **188-206行目**: IsMultipartFormの場合の特殊処理（Delphiバージョン依存）

#### Step 5: ストリーム取得を理解する

アップロードファイルの取得方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | AddStream、NewField メソッド |
| 5-2 | Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | AsStream メソッド |

**主要処理フロー**:
- **128-135行目** (Horse.Core.Param.pas): AddStream - FFilesにストリーム格納
- **191-207行目** (Horse.Core.Param.pas): NewField - FFilesにキーがあればストリーム用のFieldを生成
- **264-275行目** (Horse.Core.Param.Field.pas): AsStream - ストリームを返却

### プログラム呼び出し階層図

```
THorseRequest.ContentFields
    │
    ├─ InitializeContentFields（初回のみ）
    │      │
    │      ├─ THorseCoreParam.Create + Required(False)
    │      │
    │      ├─ CanLoadContentFields
    │      │      ├─ IsMultipartForm
    │      │      └─ IsFormURLEncoded
    │      │
    │      ├─ Files ループ（ファイルアップロード）
    │      │      └─ AddStream(FieldName, Stream)
    │      │
    │      └─ ContentFields ループ（テキストフィールド）
    │             └─ Dictionary.AddOrSetValue(Name, Value)
    │
    └─ THorseCoreParam を返却
           │
           ├─ Items[key] : テキスト値取得
           ├─ Field(key).AsStream : ファイルストリーム取得
           └─ Field(key).SaveToFile : ファイル保存
```

### データフロー図

```
[入力]                               [処理]                         [出力]

HTTP Request Body
  Content-Type: multipart/form-data  ──▶ THorseRequest.ContentFields ──▶ THorseCoreParam
  ------boundary                          │
  name="title"                            ├─ CanLoadContentFields
  value="My Title"                        │     └─ multipart? ──▶ Yes
  ------boundary                          │
  name="file"                             ├─ Files ループ
  filename="doc.pdf"                      │     └─ AddStream("file", TStream)
  [binary data]                           │
  ------boundary--                        ├─ ContentFields ループ
                                          │     └─ Dictionary["title"] = "My Title"
                                          │
                                          └─ THorseCoreParam 返却
                                                    │
                                                    ├─ Items['title'] ──▶ "My Title"
                                                    └─ Field('file').AsStream ──▶ TStream
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Request.pas | `src/Horse.Request.pas` | ソース | THorseRequest クラス、ContentFields メソッドの実装 |
| Horse.Core.Param.pas | `src/Horse.Core.Param.pas` | ソース | THorseCoreParam クラス、AddStream メソッド |
| Horse.Core.Param.Field.pas | `src/Horse.Core.Param.Field.pas` | ソース | THorseCoreParamField クラス、AsStream、SaveToFile |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | TMimeTypes（MultiPartFormData、ApplicationXWWWFormURLEncoded） |
