# 機能設計書 17-テキストレスポンス送信

## 概要

本ドキュメントは、Horse Webフレームワークにおける文字列レスポンスを送信する機能の設計を記述する。THorseResponse.Sendメソッドによる実装を対象とする。

### 本機能の処理概要

この機能は、HTTPレスポンスとして文字列データをクライアントに送信する。JSONレスポンス、プレーンテキスト、HTMLなど、様々なテキストベースのレスポンスに使用される。

**業務上の目的・背景**：WebAPIの最も基本的な機能として、クライアントにテキストデータを返すことは不可欠である。この機能により、APIレスポンス（JSON）、エラーメッセージ、静的なテキストコンテンツなどを簡単にクライアントに返すことができる。REST APIのレスポンス、Webhookの応答、ヘルスチェックエンドポイントなど、ほぼすべてのHTTPハンドラで使用される基本機能である。

**機能の利用シーン**：REST APIでのJSON応答、エラーメッセージの返却、HTMLコンテンツの直接返却、プレーンテキストの返却、ヘルスチェック応答（"OK"や"pong"など）。

**主要な処理内容**：
1. 文字列コンテンツをWebResponseのContentプロパティに設定
2. メソッドチェーン用に自身（THorseResponse）を返却
3. オブジェクト版SendではFContentにオブジェクトを格納（後処理用）

**関連システム・外部連携**：Delphiの標準WebライブラリであるTWebResponse.Content（Delphi）またはTResponse.Content（Free Pascal）にコンテンツを設定する。

**権限による制御**：本機能自体は認証・認可の制御を行わない。レスポンス内容は呼び出し元のハンドラで決定する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | VCLメインフォーム | 補助機能 | /pingエンドポイントでRes.Send('pong')によりテキストレスポンスを返却 |
| 2 | VCL-SSLメインフォーム | 補助機能 | /pingエンドポイントでRes.Send('securite pong')によりテキストレスポンスを返却 |
| 3 | Windowsサービスメイン | 補助機能 | /pingエンドポイントでRes.Send('pong')によりテキストレスポンスを返却 |
| 4 | LCLメインフォーム | 補助機能 | DoPingコールバックでRes.Send('pong')によりテキストレスポンスを返却 |
| 5 | デーモンメイン | 補助機能 | Pingコールバックでres.Send('pong')によりテキストレスポンスを返却 |
| 7 | Webモジュール | 主機能 | HandlerActionでTHorseResponseを生成しレスポンスを処理 |

## 機能種別

レスポンス処理 / データ送信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AContent | string | Yes | 送信するテキストコンテンツ | なし |

### 入力データソース

ハンドラ内で生成された文字列データ（JSON文字列、HTMLテキスト、エラーメッセージ等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | THorseResponse | メソッドチェーン用の自身への参照 |
| FWebResponse.Content | string | 送信されるテキストコンテンツ |

### 出力先

HTTPレスポンスボディとしてクライアントに送信

## 処理フロー

### 処理シーケンス

```
1. Send メソッドの呼び出し
   └─ AContent（文字列）を受け取る
2. FWebResponse.Content への代入
   └─ Delphi: TWebResponse.Content
   └─ FPC: TResponse.Content
3. Self（THorseResponse）を返却
   └─ メソッドチェーンのサポート
4. HTTPレスポンスとしてクライアントに送信
   └─ プロバイダーが実際の送信を実行
```

### フローチャート

```mermaid
flowchart TD
    A[Send メソッド呼び出し] --> B[FWebResponse.Content に代入]
    B --> C[Self を返却]
    C --> D{メソッドチェーン?}
    D -->|Yes| E[次のメソッド呼び出し]
    D -->|No| F[ハンドラ終了]
    E --> F
    F --> G[プロバイダーがレスポンス送信]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-17-01 | メソッドチェーン | Sendは自身を返却し、Status等との連鎖呼び出しが可能 | 常時 |
| BR-17-02 | Content-Type自動設定なし | Content-Typeは自動設定されない（明示的な設定が必要） | 常時 |
| BR-17-03 | 複数回呼び出し | Sendを複数回呼ぶと最後の値が使用される | 常時 |
| BR-17-04 | デフォルトステータス | ステータスコードのデフォルトは200 OK | Create時に設定 |

### 計算ロジック

特になし（単純な代入処理）

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 例外なし | 通常の使用では例外は発生しない | - |

### リトライ仕様

リトライ処理は不要（即座に結果を返す同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ内処理のみ）

## パフォーマンス要件

- 文字列代入は O(1) の計算量
- 大量のテキストを送信する場合はストリーミング送信を検討

## セキュリティ考慮事項

- レスポンスに含める内容のエスケープはアプリケーション側の責任
- HTMLを返す場合はXSS対策としてユーザー入力のサニタイズが必要
- 機密情報の漏洩に注意

## 備考

Send<T>メソッドのオーバーロード版は、オブジェクトをFContentに格納する。これは後処理（JSONシリアライズ等）のために使用される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

レスポンスオブジェクトの構造の理解が最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Response.pas | `src/Horse.Response.pas` | THorseResponse クラスの構造、FWebResponse フィールド |

**読解のコツ**: FWebResponseはDelphi/FPCの標準Webレスポンスオブジェクトへの参照。SendメソッドはこのオブジェクトのContentプロパティに値を設定する。

#### Step 2: エントリーポイントを理解する

Sendメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Response.pas | `src/Horse.Response.pas` | Send(const AContent: string) メソッド |

**主要処理フロー**:
1. **107-111行目**: Send(string) - FWebResponse.Content := AContent
2. **113-117行目**: Send<T>(AContent) - FContent := AContent（オブジェクト格納）

#### Step 3: レスポンスの初期化を理解する

THorseResponseの生成時の初期化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Response.pas | `src/Horse.Response.pas` | Create コンストラクタ |

**主要処理フロー**:
- **86-93行目**: Create - FWebResponse参照の保持、デフォルトステータス200の設定

#### Step 4: 関連メソッドとの連携を理解する

メソッドチェーンで使用される他のメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Response.pas | `src/Horse.Response.pas` | Status, ContentType メソッド |

**主要処理フロー**:
- **141-145行目**: Status(THTTPStatus) - ステータスコード設定
- **80-84行目**: ContentType - Content-Type設定
- すべてのメソッドが Self を返却してメソッドチェーンをサポート

### プログラム呼び出し階層図

```
THorseResponse.Send(AContent: string)
    │
    ├─ FWebResponse.Content := AContent
    │
    └─ Result := Self（メソッドチェーン用）

使用例:
Res.Status(200).ContentType('application/json').Send('{"status":"ok"}')
    │
    ├─ Status(200): FWebResponse.StatusCode := 200; Result := Self
    │
    ├─ ContentType('...'): FWebResponse.ContentType := '...'; Result := Self
    │
    └─ Send('...'): FWebResponse.Content := '...'; Result := Self
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ハンドラ内
  JSON文字列生成      ──▶ THorseResponse.Send        ──▶ HTTP Response
  '{"result":"ok"}'          │
                             ├─ FWebResponse.Content := AContent
                             │
                             └─ プロバイダー経由でクライアントに送信
                                    │
                                    └─ HTTP/1.1 200 OK
                                       Content-Type: application/json

                                       {"result":"ok"}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | THorseResponse クラス、Send メソッドの実装 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | THTTPStatus、TMimeTypes 定義 |
| samples/delphi/vcl/src/Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | サンプル | Send使用例（/pingエンドポイント） |
| samples/lazarus/lcl/src/views.main.pas | `samples/lazarus/lcl/src/views.main.pas` | サンプル | Send使用例（DoPingコールバック） |

### 使用例

```pascal
// 基本的な使用
Res.Send('Hello World');

// ステータスコードと組み合わせ
Res.Status(THTTPStatus.Created).Send('Resource created');

// Content-Typeと組み合わせ（JSON）
Res.ContentType('application/json').Send('{"message":"success"}');

// メソッドチェーン
Res
  .Status(200)
  .ContentType('application/json')
  .Send('{"status":"ok"}');

// エラーレスポンス
Res.Status(THTTPStatus.BadRequest).Send('Invalid request');
```
