# 機能設計書 25-Content-Type設定

## 概要

本ドキュメントは、HorseフレームワークにおけるHTTPレスポンスのContent-Type設定機能の設計を記述する。THorseResponse.ContentTypeメソッドを使用して、レスポンスのMIMEタイプを設定する機能について詳述する。

### 本機能の処理概要

**業務上の目的・背景**：HTTP通信において、Content-Typeヘッダーはレスポンスボディのデータ形式をクライアントに伝える重要な役割を持つ。適切なContent-Type設定により、ブラウザはコンテンツを正しく解釈・表示し、APIクライアントは受信データを適切にパースできる。本機能により、開発者はレスポンスのMIMEタイプを簡潔に設定できる。

**機能の利用シーン**：JSON APIレスポンスでapplication/jsonを設定、XMLレスポンスでapplication/xmlを設定、プレーンテキストでtext/plainを設定、カスタムコンテンツタイプの設定、バイナリデータのMIMEタイプ指定などで使用される。

**主要な処理内容**：
1. Content-Type文字列を受け取る
2. FWebResponseのContentTypeプロパティに値を設定する
3. 自身のインスタンスを返却してメソッドチェーンを可能にする

**関連システム・外部連携**：本機能はHTTPプロトコルの標準的なContent-Type仕様に従う。設定されたContent-TypeはHTTPレスポンスヘッダーとしてクライアントに送信される。

**権限による制御**：本機能自体に権限制御機能は含まれない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面に直接関連しない（APIレスポンス機能） |

## 機能種別

HTTP制御機能 / ヘッダー操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AContentType | string | Yes | MIMEタイプ文字列（例：application/json） | - |

### 入力データソース

アプリケーションコードからの直接指定。TMimeTypes列挙型のToStringメソッドと組み合わせて使用することも可能。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Content-Type Header | string | HTTPレスポンスのContent-Typeヘッダー |

### 出力先

HTTPレスポンスヘッダーとしてクライアントに送信

## 処理フロー

### 処理シーケンス

```
1. ContentTypeメソッド呼び出し
   └─ MIMEタイプ文字列を受け取る
2. ContentTypeプロパティ設定
   └─ FWebResponse.ContentTypeに値を代入
3. 自身のインスタンス返却
   └─ メソッドチェーンを可能にする
```

### フローチャート

```mermaid
flowchart TD
    A[ContentType呼び出し] --> B[AContentType受け取り]
    B --> C[FWebResponse.ContentType := AContentType]
    C --> D[Self返却]
    D --> E[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | フルーエントインターフェース | メソッドは自身のインスタンスを返却しメソッドチェーンを可能にする | 常時 |
| BR-25-02 | 直接プロパティ設定 | FWebResponseのContentTypeプロパティに直接値を設定 | 常時 |
| BR-25-03 | バリデーションなし | Content-Type値のバリデーションは行わない | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能ではデータベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本機能では明示的なエラー処理なし | - |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能ではトランザクション処理は発生しない。

## パフォーマンス要件

- 単純なプロパティ設定のため、処理は即座に完了する
- 追加のI/O処理は発生しない

## セキュリティ考慮事項

- Content-Typeの不適切な設定はセキュリティリスクになる可能性がある
- X-Content-Type-Options: nosniff ヘッダーと併用することを推奨
- MIMEスニッフィング攻撃を防ぐため、適切なContent-Type設定が重要

## 備考

- TMimeTypes列挙型（Horse.Commons.pas）のToStringメソッドと組み合わせて使用可能
- SendFileやRenderメソッドでは自動的にContent-Typeが設定されるため、通常は手動設定不要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MIMEタイプの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | TMimeTypes列挙型（89-106行目）で定義されたMIMEタイプを確認 |
| 1-2 | Horse.Commons.pas | `src/Horse.Commons.pas` | TMimeTypesHelper.ToString（258-296行目）でMIMEタイプの文字列変換を確認 |

**読解のコツ**: TMimeTypes列挙型には一般的なMIMEタイプが定義されており、ToStringヘルパーで実際のMIMEタイプ文字列に変換される。例：`TMimeTypes.ApplicationJSON.ToString` は `'application/json'` を返す。

#### Step 2: エントリーポイントを理解する

ContentType機能の宣言を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Response.pas | `src/Horse.Response.pas` | ContentTypeメソッドの宣言（46行目） |

**主要処理フロー**:
1. **46行目**: `function ContentType(const AContentType: string): THorseResponse; virtual;`

#### Step 3: ContentType実装の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Response.pas | `src/Horse.Response.pas` | ContentTypeメソッドの実装部分（80-84行目） |

**主要処理フロー**:
- **80-84行目**: ContentType実装

```pascal
function THorseResponse.ContentType(const AContentType: string): THorseResponse;
begin
  FWebResponse.ContentType := AContentType;
  Result := Self;
end;
```

**実装の詳細説明**:
- **82行目**: FWebResponseのContentTypeプロパティに直接値を代入
- **83行目**: メソッドチェーン用に自身を返却

#### Step 4: 関連するMIMEタイプ定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | TMimeTypes列挙型の全定義 |

```pascal
TMimeTypes = (
  MultiPartFormData,
  ApplicationXWWWFormURLEncoded,
  ApplicationJSON,
  ApplicationOctetStream,
  ApplicationXML,
  ApplicationJavaScript,
  ApplicationPDF,
  ApplicationTypeScript,
  ApplicationZIP,
  TextPlain,
  TextCSS,
  TextCSV,
  TextHTML,
  ImageJPEG,
  ImagePNG,
  ImageGIF,
  Download);
```

### プログラム呼び出し階層図

```
THorseResponse.ContentType(ContentTypeString)
    │
    └─ FWebResponse.ContentType := ContentTypeString
           │
           └─ TWebResponse/TResponse のプロパティ設定
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Content-Type文字列 ───▶ ContentType代入 ───▶ HTTPレスポンスヘッダー
                              │
                              ▼
                        Self返却 ───▶ メソッドチェーン継続
```

### TMimeTypes使用例

```pascal
// TMimeTypes列挙型を使用した例
Res.ContentType(TMimeTypes.ApplicationJSON.ToString);  // application/json
Res.ContentType(TMimeTypes.TextHTML.ToString);         // text/html
Res.ContentType(TMimeTypes.TextPlain.ToString);        // text/plain

// 文字列を直接指定する例
Res.ContentType('application/json; charset=utf-8');
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | ContentTypeメソッドの実装 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | TMimeTypes列挙型とヘルパー |
| Web.HTTPApp | Delphi標準ライブラリ | 外部ライブラリ | TWebResponse.ContentType（Delphi環境） |
| HTTPDefs | FPC標準ライブラリ | 外部ライブラリ | TResponse.ContentType（FPC環境） |
