# 機能設計書 26-サーバー起動

## 概要

本ドキュメントは、HorseフレームワークにおけるHTTPサーバー起動機能の設計を記述する。THorseProvider.Listenメソッドを使用して、HTTPサーバーを起動しリクエスト待機を開始する機能について詳述する。

### 本機能の処理概要

**業務上の目的・背景**：Webアプリケーションを実行するためには、HTTPサーバーを起動してクライアントからのリクエストを受け付ける必要がある。本機能はHorseフレームワークの中核となる機能であり、設定されたポートとホストでHTTPサーバーを起動し、登録されたルートに基づいてリクエストを処理する準備を整える。

**機能の利用シーン**：アプリケーション起動時のHTTPサーバー開始、GUIアプリケーションでのスタートボタン押下時、Windowsサービス開始時、Linuxデーモン起動時などで使用される。

**主要な処理内容**：
1. ポートとホストの設定を確認・適用する
2. TIdHTTPWebBrokerBridgeインスタンスを生成・設定する
3. SSL/TLS設定がある場合は適用する
4. サーバーをアクティブ化してリスニングを開始する
5. OnListenコールバックを実行する

**関連システム・外部連携**：Indy（TIdHTTPWebBrokerBridge）をベースとしたHTTPサーバー実装を使用。SSL/TLSを使用する場合はOpenSSLライブラリとの連携が必要。

**権限による制御**：ポートのバインドにはOSレベルの権限が必要な場合がある（1024番以下のポートなど）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | VCLメインフォーム | 主機能 | Startボタン押下時にTHorse.Listenを呼び出してHTTPサーバーを起動 |
| 2 | VCL-SSLメインフォーム | 主機能 | Startボタン押下時にTHorse.Listenを呼び出してHTTPSサーバーを起動 |
| 3 | Windowsサービスメイン | 主機能 | ServiceStart時にTHorse.Listenを呼び出してHTTPサーバーを起動 |
| 4 | LCLメインフォーム | 主機能 | Startボタン押下時にTHorse.Listenを呼び出してHTTPサーバーを起動 |
| 5 | デーモンメイン | 主機能 | DataModuleStart時に別スレッドでTHorse.Listen(9000)を呼び出してHTTPサーバーを起動 |

## 機能種別

サーバー制御機能 / 起動処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| APort | Integer | No | リスニングポート番号（デフォルト：9000） | 正の整数 |
| AHost | string | No | リスニングホスト（デフォルト：0.0.0.0） | 有効なIPアドレスまたはホスト名 |
| ACallbackListen | TProc | No | サーバー起動時に実行されるコールバック | - |
| ACallbackStopListen | TProc | No | サーバー停止時に実行されるコールバック | - |

### 入力データソース

アプリケーションコードからの直接指定、または事前に設定されたプロパティ値

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FRunning | Boolean | サーバー実行状態フラグ（True: 実行中） |

### 出力先

内部状態の更新、OnListenコールバックの実行

## 処理フロー

### 処理シーケンス

```
1. ポート・ホストのデフォルト値設定
   └─ 未設定の場合はDEFAULT_PORT(9000)、DEFAULT_HOST(0.0.0.0)を使用
2. TIdHTTPWebBrokerBridgeインスタンスの取得・生成
   └─ GetDefaultHTTPWebBrokerでシングルトン取得
3. WebRequestHandlerの設定
   └─ WebModuleClassを登録
4. MaxConnections設定の適用
   └─ 指定されている場合のみ適用
5. SSL/TLS設定の適用
   └─ IOHandleSSLが設定されている場合のみ
6. バインディング設定
   └─ ホストがデフォルト以外の場合にBindingsを設定
7. サーバーのアクティブ化
   └─ Active := True, StartListening
8. 状態更新とコールバック実行
   └─ FRunning := True, DoOnListen
9. コンソールモードの場合はイベント待機
   └─ FEvent.WaitForでブロッキング待機
```

### フローチャート

```mermaid
flowchart TD
    A[Listen呼び出し] --> B{ポート設定済み?}
    B -->|No| C[DEFAULT_PORT使用]
    B -->|Yes| D{ホスト設定済み?}
    C --> D
    D -->|No| E[DEFAULT_HOST使用]
    D -->|Yes| F[HTTPWebBroker取得]
    E --> F
    F --> G[WebModuleClass設定]
    G --> H{MaxConnections > 0?}
    H -->|Yes| I[MaxConnections適用]
    H -->|No| J{SSL設定あり?}
    I --> J
    J -->|Yes| K[SSL IOHandler設定]
    J -->|No| L{Host != DEFAULT?}
    K --> L
    L -->|Yes| M[Bindings設定]
    L -->|No| N[Active := True]
    M --> N
    N --> O[StartListening]
    O --> P[FRunning := True]
    P --> Q[DoOnListen]
    Q --> R{IsConsole?}
    R -->|Yes| S[Event待機ループ]
    R -->|No| T[終了]
    S --> T
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | デフォルトポート | ポート未指定時はDEFAULT_PORT(9000)を使用 | ポート <= 0 の場合 |
| BR-26-02 | デフォルトホスト | ホスト未指定時はDEFAULT_HOST(0.0.0.0)を使用 | ホストが空の場合 |
| BR-26-03 | シングルトンブリッジ | TIdHTTPWebBrokerBridgeはシングルトンで管理 | 常時 |
| BR-26-04 | SSL自動設定 | IOHandleSSLが設定されていれば自動的にSSL有効化 | IOHandleSSL != nil |
| BR-26-05 | コンソールブロッキング | コンソールアプリではイベント待機でブロッキング | IsConsole = True |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能ではデータベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | ポートが既に使用中の場合 | 別のポートを指定する |
| - | Exception | バインドに失敗した場合 | ホスト設定を確認する |
| - | Exception | SSL証明書が見つからない場合 | 証明書パスを確認する |

### リトライ仕様

リトライ機能は実装されていない。エラー発生時は呼び出し元で適切に処理する必要がある。

## トランザクション仕様

本機能ではトランザクション処理は発生しない。

## パフォーマンス要件

- サーバー起動は通常1秒以内に完了する
- MaxConnectionsで同時接続数を制限可能
- ListenQueueでバックログ数を設定可能

## セキュリティ考慮事項

- HTTPSを使用する場合はSSL/TLS設定が必要
- 本番環境では0.0.0.0ではなく特定のIPアドレスにバインドすることを推奨
- 不要なポートの公開を避けるためファイアウォール設定を確認
- SSL証明書のパスワード管理に注意

## 備考

- 複数のListenオーバーロードが存在し、用途に応じて選択可能
- VCL/LCL環境ではGUIスレッドでリスニングが行われる
- Console環境ではイベント待機でメインスレッドをブロック

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

定数とプロバイダー抽象クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Constants.pas | `src/Horse.Constants.pas` | DEFAULT_HOST, DEFAULT_PORT定数の定義（10-11行目） |
| 1-2 | Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | THorseProviderAbstractクラスとOnListen/OnStopListenの定義（19-35行目） |

**読解のコツ**: 定数ファイルでデフォルト値を確認した後、抽象プロバイダークラスでListen/StopListenの基本構造を理解する。

#### Step 2: エントリーポイントを理解する

Consoleプロバイダーの実装を確認する（最も一般的な使用形態）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | THorseProviderクラスのプロパティ定義（15-64行目） |
| 2-2 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | Listenメソッドのオーバーロード宣言（57-61行目） |

**主要処理フロー**:
1. **57行目**: `class procedure Listen; overload; override;` - 引数なしのListen
2. **58行目**: `class procedure Listen(const APort: Integer; const AHost: string = '0.0.0.0'; const ACallbackListen: TProc = nil; const ACallbackStopListen: TProc = nil);` - フル引数版

#### Step 3: InternalListen実装の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | InternalListenメソッドの実装（174-238行目） |

**主要処理フロー**:
- **180-184行目**: ポート・ホストのデフォルト値設定
- **186-187行目**: HTTPWebBrokerとWebModuleClass設定
- **189-193行目**: MaxConnections設定
- **198-199行目**: SSL設定の適用
- **200行目**: ListenQueue設定
- **202-208行目**: Bindings設定
- **210-213行目**: サーバーアクティブ化
- **214-215行目**: FRunning設定とDoOnListen呼び出し
- **217-221行目**: コンソールモードのイベント待機

#### Step 4: VCLプロバイダーの違いを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | InternalListen実装（169-213行目） |

**Consoleとの違い**:
- イベント待機ループがない（GUIアプリなので不要）
- それ以外の処理フローは基本的に同じ

#### Step 5: サンプル実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | VCLサンプルでのListen呼び出し（48-52行目） |

```pascal
procedure TFrmVCL.Start;
begin
  // Need to set "HORSE_VCL" compilation directive
  THorse.Listen(StrToInt(edtPort.Text));
end;
```

### プログラム呼び出し階層図

```
THorse.Listen(Port)
    │
    └─ THorseProvider.Listen(Port, Host, CallbackListen, CallbackStopListen)
           │
           ├─ SetPort(Port)
           ├─ SetHost(Host)
           ├─ SetOnListen(CallbackListen)
           ├─ SetOnStopListen(CallbackStopListen)
           │
           └─ InternalListen
                  │
                  ├─ GetDefaultHTTPWebBroker
                  │      └─ TIdHTTPWebBrokerBridge.Create
                  │
                  ├─ WebRequestHandler.WebModuleClass設定
                  │
                  ├─ MaxConnections設定（任意）
                  │
                  ├─ InitServerIOHandlerSSLOpenSSL（SSL使用時）
                  │      └─ TIdServerIOHandlerSSLOpenSSL.Create
                  │
                  ├─ Bindings設定（Host != DEFAULT_HOST時）
                  │
                  ├─ LIdHTTPWebBrokerBridge.Active := True
                  ├─ LIdHTTPWebBrokerBridge.StartListening
                  │
                  ├─ FRunning := True
                  └─ DoOnListen
```

### データフロー図

```
[入力]                       [処理]                           [出力]

Port設定 ─────────▶ デフォルト値確認
Host設定 ─────────▶        │
CallbackListen ──▶         ▼
                    HTTPWebBroker生成
                           │
                           ▼
                    WebModule設定
                           │
                           ▼
                    MaxConnections適用
                           │
                           ▼
                    SSL設定適用（任意）
                           │
                           ▼
                    Bindings設定
                           │
                           ▼
                    サーバーアクティブ化 ───▶ FRunning = True
                           │
                           ▼
                    DoOnListen ───▶ CallbackListen実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | ソース | Consoleプロバイダー実装 |
| Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | ソース | VCLプロバイダー実装 |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | デフォルト定数定義 |
| Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | ソース | SSL設定実装 |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModule実装 |
| Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | サンプル | VCLサンプル実装 |
