# 機能設計書 28-ポート設定

## 概要

本ドキュメントは、HorseフレームワークにおけるHTTPサーバーのリスニングポート設定機能の設計を記述する。THorseProvider.Portプロパティを使用して、サーバーがリクエストを受け付けるポート番号を設定する機能について詳述する。

### 本機能の処理概要

**業務上の目的・背景**：HTTPサーバーを起動する際、どのポートでリクエストを受け付けるかは重要な設定項目である。開発環境と本番環境で異なるポートを使用したり、複数のサービスを同一サーバーで稼働させる際にポート分離が必要になったりする。本機能により、開発者はサーバーのリスニングポートを柔軟に設定できる。

**機能の利用シーン**：サーバー起動前のポート設定、GUIアプリケーションでのポート番号入力、設定ファイルからのポート読み込み、環境変数からのポート取得などで使用される。

**主要な処理内容**：
1. ポート番号（Integer値）を受け取る
2. クラス変数FPortに値を格納する
3. 次回のListen呼び出し時に設定されたポートが使用される

**関連システム・外部連携**：設定されたポートはListen時にTIdHTTPWebBrokerBridgeのDefaultPortおよびBindingsに反映される。

**権限による制御**：1024番以下のポート（ウェルノウンポート）を使用する場合は管理者権限が必要な場合がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | VCLメインフォーム | 補助機能 | edtPortテキストボックスで入力されたポート番号をサーバー起動時に使用 |
| 2 | VCL-SSLメインフォーム | 補助機能 | edtPortスピンエディットで入力されたポート番号をサーバー起動時に使用 |
| 4 | LCLメインフォーム | 補助機能 | edtPortテキストボックスで入力されたポート番号をサーバー起動時に使用 |
| 5 | デーモンメイン | 補助機能 | ポート9000をハードコードしてサーバー起動時に使用 |

## 機能種別

サーバー設定機能 / プロパティ操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AValue | Integer | Yes | ポート番号（1-65535） | 正の整数 |

### 入力データソース

アプリケーションコードからの直接指定、GUI入力、設定ファイル、環境変数など

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| FPort | Integer | 設定されたポート番号 |

### 出力先

クラス変数FPortへの格納

## 処理フロー

### 処理シーケンス

```
1. Portプロパティへの値設定
   └─ SetPortメソッドが呼び出される
2. FPort変数への代入
   └─ クラス変数FPortに値を格納
3. Listen時にポートが使用される
   └─ InternalListenでFPort値を参照
```

### フローチャート

```mermaid
flowchart TD
    A[Port := Value] --> B[SetPort呼び出し]
    B --> C[FPort := AValue]
    C --> D[設定完了]
    D --> E[Listen呼び出し時]
    E --> F{FPort > 0?}
    F -->|Yes| G[FPort使用]
    F -->|No| H[DEFAULT_PORT使用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-28-01 | デフォルトポート | ポートが0以下の場合はDEFAULT_PORT(9000)を使用 | Listen時 |
| BR-28-02 | 静的プロパティ | Portはクラスプロパティとして実装されている | 常時 |
| BR-28-03 | Listen前設定 | ポートはListen呼び出し前に設定する必要がある | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能ではデータベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | 指定ポートが既に使用中 | Listen時に発生、別のポートを指定 |
| - | Exception | 権限不足でポートをバインドできない | 管理者権限で実行または別ポート使用 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

本機能ではトランザクション処理は発生しない。

## パフォーマンス要件

- プロパティ設定のみのため、処理は即座に完了する

## セキュリティ考慮事項

- ウェルノウンポート（0-1023）の使用には注意が必要
- ファイアウォールで不要なポートをブロックすることを推奨
- 本番環境では標準的なHTTP(80)/HTTPS(443)ポートの使用を検討

## 備考

- Portプロパティはクラスプロパティのため、インスタンス化不要で設定可能
- Listenメソッドの引数でもポート指定可能（その場合はプロパティ設定は不要）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

定数とクラス変数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Constants.pas | `src/Horse.Constants.pas` | DEFAULT_PORT定数の定義（11行目） |
| 1-2 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | FPortクラス変数の定義（17行目） |

**読解のコツ**: DEFAULT_PORT = 9000が定義されており、ポート未設定時のフォールバック値として使用される。

#### Step 2: プロパティ宣言を理解する

Portプロパティの宣言を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | Portプロパティの宣言（51行目） |

**主要処理フロー**:
1. **51行目**: `class property Port: Integer read GetPort write SetPort;`

#### Step 3: Getter/Setter実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | GetPort/SetPort実装（118-122行目、319-322行目） |

**主要処理フロー**:
- **118-122行目**: GetDefaultPort実装

```pascal
class function THorseProvider.GetDefaultPort: Integer;
begin
  Result := DEFAULT_PORT;
end;
```

- **153-156行目**: GetPort実装

```pascal
class function THorseProvider.GetPort: Integer;
begin
  Result := FPort;
end;
```

- **319-322行目**: SetPort実装

```pascal
class procedure THorseProvider.SetPort(const AValue: Integer);
begin
  FPort := AValue;
end;
```

#### Step 4: Listen時のポート使用を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | InternalListenでのポート参照（180-181行目） |

```pascal
if FPort <= 0 then
  FPort := GetDefaultPort;
```

#### Step 5: サンプル実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | VCLサンプルでのポート使用（48-52行目） |

```pascal
procedure TFrmVCL.Start;
begin
  // Need to set "HORSE_VCL" compilation directive
  THorse.Listen(StrToInt(edtPort.Text));
end;
```

### プログラム呼び出し階層図

```
THorse.Port := 8080
    │
    └─ THorseProvider.SetPort(8080)
           │
           └─ FPort := 8080

THorse.Port（取得）
    │
    └─ THorseProvider.GetPort
           │
           └─ Result := FPort

THorse.Listen
    │
    └─ InternalListen
           │
           ├─ FPort <= 0 チェック
           │      └─ GetDefaultPort（9000）
           │
           └─ LIdHTTPWebBrokerBridge.DefaultPort := FPort
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ポート番号 ───────▶ SetPort
                         │
                         ▼
                   FPort := AValue ───▶ クラス変数に格納
                                               │
                                               ▼
                                         Listen呼び出し
                                               │
                                               ▼
                                         DefaultPort設定
                                               │
                                               ▼
                                         サーバー起動
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | DEFAULT_PORT定数定義 |
| Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | ソース | ConsoleプロバイダーのPort実装 |
| Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | ソース | VCLプロバイダーのPort実装 |
| Main.Form.pas | `samples/delphi/vcl/src/Main.Form.pas` | サンプル | VCLサンプル実装 |
| Views.Main.pas | `samples/lazarus/lcl/src/views.main.pas` | サンプル | LCLサンプル実装 |
