# 機能設計書 31-SSL/TLS設定

## 概要

本ドキュメントは、Horseフレームワークにおける SSL/TLS 暗号化通信設定機能の詳細設計を記載したものである。THorseProviderIOHandleSSL クラスを中心として、HTTPS通信に必要な証明書やSSLバージョンなどの設定を管理する機能について説明する。

### 本機能の処理概要

**業務上の目的・背景**：Web APIやWebアプリケーションにおいて、クライアントとサーバー間の通信を暗号化し、データの盗聴・改ざんを防止する必要がある。特に個人情報や機密情報を扱うシステムでは、HTTPS通信は必須のセキュリティ要件となる。本機能は、開発者がHorseフレームワーク上でSSL/TLS暗号化通信を簡単に設定できるようにするための機能である。

**機能の利用シーン**：本機能は、以下のようなシーンで利用される。
- 本番環境でHTTPSサーバーを起動する際のSSL証明書設定
- 開発環境で自己署名証明書を使用したテスト環境の構築
- セキュリティ要件に基づいたSSL/TLSバージョンの指定
- パスワード保護された秘密鍵を使用する際のパスワードコールバック設定

**主要な処理内容**：
1. 秘密鍵ファイル（KeyFile）のパス設定
2. 公開鍵証明書ファイル（CertFile）のパス設定
3. ルート証明書ファイル（RootCertFile）のパス設定
4. SSL/TLSバージョン（Method, SSLVersions）の設定
5. DHパラメータファイル（DHParamsFile）の設定
6. 暗号スイートリスト（CipherList）の設定
7. 秘密鍵パスワード取得コールバック（OnGetPassword）の設定
8. SSL機能の有効/無効（Active）の制御

**関連システム・外部連携**：本機能はIndy（IdSSLOpenSSL）コンポーネントと連携し、OpenSSLライブラリを使用してSSL/TLS通信を実現する。libeay32.dll および ssleay32.dll ライブラリが実行環境に必要となる。

**権限による制御**：SSL/TLS設定自体には権限制御はないが、秘密鍵ファイルへのアクセス権限が必要となる。また、パスワード保護された秘密鍵を使用する場合は、OnGetPasswordコールバックを通じてパスワードを提供する必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | VCL-SSLメインフォーム | 主画面 | THorse.IOHandleSSLで秘密鍵・公開鍵・パスワード・SSLバージョンを設定 |

## 機能種別

設定処理 / セキュリティ設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| KeyFile | string | Yes | 秘密鍵ファイルのパス | ファイル存在チェック |
| CertFile | string | Yes | 公開鍵証明書ファイルのパス | ファイル存在チェック |
| RootCertFile | string | No | ルート証明書ファイルのパス | ファイル存在チェック |
| DHParamsFile | string | No | DHパラメータファイルのパス | ファイル存在チェック |
| CipherList | string | No | 使用する暗号スイートのリスト | なし |
| Method | TIdSSLVersion | No | 使用するSSLバージョン（単一） | 列挙型チェック |
| SSLVersions | TIdSSLVersions | No | 使用するSSLバージョン（複数） | セット型チェック |
| OnGetPassword | TPasswordEvent | No | パスワード取得用コールバック | なし |
| Active | Boolean | No | SSL機能の有効/無効 | なし |

### 入力データソース

- ファイルシステム上のSSL証明書ファイル（.key, .crt, .pem形式）
- アプリケーション設定またはUIからの設定値
- パスワード入力（コールバック経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IHorseProviderIOHandleSSL | Interface | 設定されたSSL設定オブジェクトへのインターフェース参照 |

### 出力先

HTTPサーバープロバイダー（THorseProvider系クラス）に対してSSL設定を適用

## 処理フロー

### 処理シーケンス

```
1. THorseProviderIOHandleSSL.Newでインスタンス生成
   └─ コンストラクタでデフォルト値設定（Active=True, Method=DEF_SSLVERSION, SSLVersions=DEF_SSLVERSIONS）
2. KeyFile(パス)で秘密鍵ファイルパスを設定
   └─ FKeyFileフィールドにパスを格納
3. CertFile(パス)で公開鍵証明書ファイルパスを設定
   └─ FCertFileフィールドにパスを格納
4. SSLVersions([バージョンセット])でSSLバージョンを設定
   └─ FSSLVersionsフィールドにバージョンセットを格納
5. OnGetPassword(コールバック)でパスワード取得処理を設定（オプション）
   └─ FOnGetPasswordフィールドにコールバックを格納
6. Active(True)でSSL機能を有効化
   └─ FActiveフィールドをTrueに設定
7. THorse.Listenでサーバー起動時にSSL設定が適用される
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[THorseProviderIOHandleSSL.New]
    B --> C[KeyFileパス設定]
    C --> D[CertFileパス設定]
    D --> E{RootCertFile必要?}
    E -->|Yes| F[RootCertFileパス設定]
    E -->|No| G{DHParamsFile必要?}
    F --> G
    G -->|Yes| H[DHParamsFileパス設定]
    G -->|No| I{CipherList必要?}
    H --> I
    I -->|Yes| J[CipherList設定]
    I -->|No| K[SSLVersions設定]
    J --> K
    K --> L{パスワード保護あり?}
    L -->|Yes| M[OnGetPassword設定]
    L -->|No| N[Active設定]
    M --> N
    N --> O[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-31-01 | 必須証明書 | 秘密鍵と公開鍵証明書は必須である | HTTPS通信を行う場合 |
| BR-31-02 | SSLバージョン | TLS 1.2以上を推奨する | 本番環境での運用時 |
| BR-31-03 | OpenSSLライブラリ | libeay32.dll, ssleay32.dllが実行ファイルと同じフォルダに必要 | SSL機能使用時 |
| BR-31-04 | デフォルト有効化 | Active未指定時はデフォルトでSSL有効（True） | インスタンス生成時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

本機能ではデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | 指定された証明書ファイルが存在しない | 正しいファイルパスを指定する |
| - | OpenSSLエラー | OpenSSLライブラリがロードできない | libeay32.dll, ssleay32.dllを配置する |
| - | 証明書形式エラー | 証明書ファイルの形式が不正 | PEM形式の有効な証明書を使用する |
| - | パスワードエラー | 秘密鍵のパスワードが不正 | 正しいパスワードを設定する |

### リトライ仕様

エラー発生時のリトライは行わない。設定を修正して再度サーバー起動を試行する。

## トランザクション仕様

トランザクション処理は行わない（設定処理のみ）。

## パフォーマンス要件

- SSL/TLS設定処理はサーバー起動時に1回のみ実行される
- 証明書ファイルの読み込みは起動時に行われ、以降はキャッシュされる

## セキュリティ考慮事項

- 秘密鍵ファイルへのアクセス権限を適切に制限すること
- パスワード保護された秘密鍵を使用することを推奨
- 自己署名証明書は本番環境では使用しないこと
- TLS 1.2以上の使用を推奨（TLS 1.0, 1.1は非推奨）
- 暗号スイートの選定は最新のセキュリティ基準に従うこと

## 備考

- 開発・テスト用の自己署名証明書は以下のコマンドで生成可能：
  `openssl req -x509 -nodes -days 365 -newkey rsa:2048 -keyout cert.key -out cert.crt`
- 本番環境ではLet's Encryptなどの正式な認証局から発行された証明書を使用すること

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SSL/TLS設定のインターフェース定義から始める。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Provider.IOHandleSSL.Contract.pas | `src/Horse.Provider.IOHandleSSL.Contract.pas` | IHorseProviderIOHandleSSLインターフェースで定義されるメソッド群を確認 |

**読解のコツ**:
- Delphiのインターフェース定義は `interface` セクションにメソッドシグネチャが列挙される
- `overload` キーワードは同名メソッドの複数定義（getter/setter パターン）を示す
- `TIdSSLVersion`, `TIdSSLVersions`, `TPasswordEvent` はIndy (IdSSLOpenSSL) の型

**主要処理フロー**:
- **14-33行目**: IHorseProviderIOHandleSSLインターフェースの定義
- **15-16行目**: Active プロパティのgetter/setter
- **17-18行目**: CertFile プロパティのgetter/setter
- **21-22行目**: KeyFile プロパティのgetter/setter
- **25-26行目**: SSLVersions プロパティのgetter/setter
- **31-32行目**: OnGetPassword コールバックのgetter/setter

#### Step 2: 実装クラスを理解する

インターフェースを実装する具象クラスの詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | THorseProviderIOHandleSSLクラスの実装詳細を確認 |

**主要処理フロー**:
- **14-46行目**: THorseProviderIOHandleSSLクラスの定義
- **16-24行目**: プライベートフィールド（FKeyFile, FCertFile, FMethod等）
- **83-88行目**: コンストラクタでデフォルト値設定（FActive=True, FMethod=DEF_SSLVERSION）
- **123-126行目**: Newファクトリメソッドでインスタンス生成
- **101-105行目**: KeyFileセッターのフルーエントインターフェース実装
- **155-159行目**: SSLVersionsセッターのフルーエントインターフェース実装
- **128-132行目**: OnGetPasswordセッターでコールバック設定

**読解のコツ**:
- 各メソッドは`Result := Self`を返すフルーエントインターフェースパターン
- これによりメソッドチェーン（`.KeyFile(...).CertFile(...).Active(True)`）が可能

#### Step 3: 使用例を理解する

実際の利用コードで設定方法を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Main.Form.pas | `samples/delphi/vcl-ssl/src/Main.Form.pas` | SSL設定の具体的な使用例 |

**主要処理フロー**:
- **89-94行目**: THorse.IOHandleSSLを使ったSSL設定のチェーン呼び出し
- **90行目**: KeyFile で秘密鍵ファイルを設定
- **91行目**: CertFile で公開鍵証明書を設定
- **92行目**: OnGetPassword でパスワードコールバックを設定
- **93行目**: SSLVersions で [sslvTLSv1_2] を指定
- **94行目**: Active(True) でSSL有効化
- **73-76行目**: OnGetPasswordコールバック実装（テキストボックスからパスワード取得）

### プログラム呼び出し階層図

```
THorse（メインクラス）
    │
    ├─ IOHandleSSL プロパティ
    │      └─ THorseProviderIOHandleSSL.New
    │             ├─ KeyFile(パス) → FKeyFile設定
    │             ├─ CertFile(パス) → FCertFile設定
    │             ├─ RootCertFile(パス) → FRootCertFile設定
    │             ├─ DHParamsFile(パス) → FDHParamsFile設定
    │             ├─ CipherList(リスト) → FCipherList設定
    │             ├─ Method(バージョン) → FMethod設定
    │             ├─ SSLVersions(セット) → FSSLVersions設定
    │             ├─ OnGetPassword(コールバック) → FOnGetPassword設定
    │             └─ Active(フラグ) → FActive設定
    │
    └─ Listen(ポート)
           └─ プロバイダーでSSL設定を適用してHTTPSサーバー起動
```

### データフロー図

```
[入力]                    [処理]                         [出力]

証明書ファイルパス ───▶ THorseProviderIOHandleSSL ───▶ IHorseProviderIOHandleSSL
（秘密鍵、公開鍵、                    │                    （設定済みインターフェース）
 ルート証明書等）                     │
                                      │
SSLバージョン設定 ─────────────────────┤
                                      │
パスワードコールバック ───────────────┤
                                      │
Active フラグ ────────────────────────┘

                              │
                              ▼
                    THorseProvider系クラス
                              │
                              ▼
                       HTTPSサーバー起動
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.IOHandleSSL.Contract.pas | `src/Horse.Provider.IOHandleSSL.Contract.pas` | ソース | IHorseProviderIOHandleSSLインターフェース定義 |
| Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | ソース | THorseProviderIOHandleSSL実装クラス |
| Main.Form.pas | `samples/delphi/vcl-ssl/src/Main.Form.pas` | サンプル | VCLアプリでのSSL設定使用例 |
| Horse.Provider.VCL.pas | `src/Horse.Provider.VCL.pas` | ソース | VCLプロバイダー（SSL設定を適用） |
| Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | ソース | Consoleプロバイダー（SSL設定を適用） |
