# 機能設計書 32-ルートグループ化

## 概要

本ドキュメントは、Horseフレームワークにおけるルートグループ化機能の詳細設計を記載したものである。THorseCoreGroup クラスを使用して、共通のプレフィックスを持つ複数のルートを論理的にグループ化し、コードの整理とメンテナンス性を向上させる機能について説明する。

### 本機能の処理概要

**業務上の目的・背景**：大規模なWebアプリケーションやREST APIでは、多数のエンドポイントを管理する必要がある。例えば、ユーザー管理関連のエンドポイント（/api/users, /api/users/:id, /api/users/profile 等）を論理的にグループ化することで、コードの可読性を高め、ルーティング設定の重複を削減し、保守性を向上させることができる。本機能は、共通のURLプレフィックスを持つルートをグループとしてまとめて定義できるようにする。

**機能の利用シーン**：本機能は、以下のようなシーンで利用される。
- REST APIのバージョニング（/api/v1/..., /api/v2/...）
- リソース別のエンドポイント整理（/users/..., /products/..., /orders/...）
- 管理者用・一般ユーザー用のルート分離（/admin/..., /user/...）
- グループ単位でのミドルウェア適用

**主要な処理内容**：
1. ルートグループの作成（THorseCore.Group）
2. 共通プレフィックスの設定（Prefix メソッド）
3. グループ内でのルート定義（Get, Post, Put, Delete, Patch, Head, All）
4. グループ内でのミドルウェア登録（Use メソッド）
5. グループ内でのルートオブジェクト定義（Route メソッド）
6. コールバックの追加（AddCallback, AddCallbacks）
7. グループ終了と親オブジェクトへの復帰（End メソッド）

**関連システム・外部連携**：ルートグループは THorseCore のルーティングシステムと連携し、THorseRouterTree に登録されたルート定義に基づいてHTTPリクエストを処理する。

**権限による制御**：ルートグループ自体に権限制御はないが、グループ単位でミドルウェアを適用することで、認証・認可処理を一括で設定することが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面に直接関連しない（API設計時に使用） |

## 機能種別

ルーティング設定 / コード構造化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| APrefix | string | No | グループの共通URLプレフィックス | 先頭・末尾の '/' は自動的にトリム |
| APath | string | Yes | ルートパス（プレフィックスに連結される） | なし |
| ACallback | THorseCallback / THorseCallbackRequestResponse / THorseCallbackRequest / THorseCallbackResponse | Yes | リクエスト処理コールバック | なし |
| ACallbacks | array of THorseCallback | No | 複数のコールバック（ミドルウェア等） | なし |
| AMiddleware | THorseCallback | No | ミドルウェアコールバック | なし |

### 入力データソース

- アプリケーション起動時のルート定義コード
- ミドルウェア関数
- コールバック関数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IHorseCoreGroup<T> | Interface | ルートグループインターフェース（フルーエントインターフェース） |
| T | class | 親オブジェクト（End メソッドで返却） |

### 出力先

THorseRouterTree（ルーティングツリー）にルート定義が登録される

## 処理フロー

### 処理シーケンス

```
1. THorseCore.Groupでグループインスタンス生成
   └─ THorseCoreGroup<THorseCore>.Create が呼ばれ、FHorseCoreにTHorseCoreインスタンスを格納
2. Prefix(プレフィックス文字列)でURLプレフィックスを設定
   └─ FPrefix に '/' + プレフィックス.Trim(['/']) を格納
3. 各種HTTPメソッド（Get, Post等）でルートを登録
   └─ NormalizePath でプレフィックス + パスを正規化し、THorseCore.Get等を呼び出し
4. Use(ミドルウェア)でグループ全体にミドルウェアを適用
   └─ NormalizePath('/') でプレフィックス付きパスにミドルウェアを登録
5. Route(パス)でルートオブジェクトを取得
   └─ THorseCore.Route を呼び出して IHorseCoreRoute を返却
6. End でグループを終了し、親オブジェクト（THorseCore）を返却
   └─ FHorseCore を T 型にキャストして返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[THorseCore.Group]
    B --> C[THorseCoreGroup.Create]
    C --> D{Prefix設定?}
    D -->|Yes| E[Prefix設定]
    D -->|No| F{ミドルウェア登録?}
    E --> F
    F -->|Yes| G[Use でミドルウェア登録]
    F -->|No| H{ルート定義?}
    G --> H
    H -->|Yes| I[Get/Post/Put等でルート登録]
    H -->|No| J{Route定義?}
    I --> K{追加ルート?}
    K -->|Yes| H
    K -->|No| J
    J -->|Yes| L[Route でルートオブジェクト取得]
    J -->|No| M[End で親オブジェクトに復帰]
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-32-01 | パス正規化 | プレフィックスとパスは自動的に正規化される（先頭・末尾の'/'がトリムされ、適切に連結） | すべてのルート登録時 |
| BR-32-02 | フルーエントAPI | 各メソッドはSelfを返却し、メソッドチェーンが可能 | 全メソッド |
| BR-32-03 | グループスコープ | グループ内で登録したミドルウェアは、グループ配下のルートにのみ適用 | Useメソッド使用時 |
| BR-32-04 | 親オブジェクト復帰 | End メソッドで親の THorseCore に戻り、通常のルート定義を継続可能 | グループ終了時 |

### 計算ロジック

**パス正規化ロジック（NormalizePath）**:
```
Result := FPrefix + '/' + APath.Trim(['/'])
```

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

本機能ではデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 実行時エラー | THorseCoreインスタンスが未生成の状態でGroup呼び出し | アプリケーション初期化を確認 |
| - | コンパイルエラー | 不正なコールバック型の指定 | 正しい型のコールバックを使用 |

### リトライ仕様

リトライは不要（設定時の一時的処理）。

## トランザクション仕様

トランザクション処理は行わない（設定処理のみ）。

## パフォーマンス要件

- ルートグループ設定はアプリケーション起動時に1回のみ実行
- グループ化はルーティングツリーの構造に影響を与えるが、実行時パフォーマンスへの影響は軽微

## セキュリティ考慮事項

- グループ単位でのミドルウェア適用により、認証・認可処理を一括設定可能
- 管理者用エンドポイントのグループ化により、権限管理を効率化

## 備考

- グループ化は論理的な整理のためのものであり、実行時には通常のルーティングと同様に処理される
- ネストされたグループ（グループ内グループ）は直接サポートされていないが、プレフィックスの組み合わせで実現可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ルートグループのインターフェース定義から始める。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Group.Contract.pas | `src/Horse.Core.Group.Contract.pas` | IHorseCoreGroup<T>インターフェースの全メソッド定義を確認 |

**読解のコツ**:
- ジェネリクス `<T: class>` により、親クラスの型を柔軟に指定可能
- 各HTTPメソッド（Get, Post等）は複数のオーバーロードを持つ
- `{$IFNDEF FPC}` は Delphi 専用コードを示す

**主要処理フロー**:
- **15-70行目**: IHorseCoreGroup<T>インターフェース定義
- **17行目**: Prefix メソッド定義
- **18行目**: Route メソッド定義
- **19-20行目**: AddCallback, AddCallbacks メソッド定義
- **21-24行目**: Use メソッドのオーバーロード群
- **31-68行目**: 各HTTPメソッド（Get, Post, Put, Head, Patch, Delete）のオーバーロード群
- **69行目**: End メソッド定義

#### Step 2: 実装クラスを理解する

インターフェースを実装する具象クラスの詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Core.Group.pas | `src/Horse.Core.Group.pas` | THorseCoreGroup<T>クラスの実装詳細を確認 |

**主要処理フロー**:
- **15-75行目**: THorseCoreGroup<T>クラス定義
- **17行目**: FHorseCore フィールド（親オブジェクト参照）
- **18行目**: FPrefix フィールド（URLプレフィックス）
- **19行目**: NormalizePath プライベートメソッド
- **214-217行目**: コンストラクタ（THorseCore.GetInstanceをFHorseCoreに格納）
- **219-223行目**: Prefix メソッド実装（'/' + APrefix.Trim(['/']])）
- **321-324行目**: NormalizePath メソッド実装（FPrefix + '/' + APath.Trim(['/'])）
- **88-91行目**: End メソッド実装（FHorseCore as T を返却）
- **93-103行目**: Get メソッド群の実装（THorseCore(FHorseCore).Get を呼び出し）
- **173-177行目**: AddCallback メソッド実装
- **236-240行目**: Use メソッド実装（ミドルウェア登録）
- **225-228行目**: Route メソッド実装

**読解のコツ**:
- 各メソッドは `THorseCore(FHorseCore).XXX(NormalizePath(APath), ACallback)` の形式で親クラスのメソッドを呼び出す
- `Result := Self` でフルーエントインターフェースを実現

#### Step 3: ルートオブジェクトとの連携を理解する

Route メソッドで返却される IHorseCoreRoute との連携を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.Route.Contract.pas | `src/Horse.Core.Route.Contract.pas` | IHorseCoreRoute<T>インターフェース定義 |

**主要処理フロー**:
- **13-60行目**: IHorseCoreRoute<T>インターフェース定義
- **15-16行目**: AddCallback, AddCallbacks メソッド
- **17-20行目**: All メソッドのオーバーロード群
- **21-59行目**: 各HTTPメソッドのオーバーロード群
- **59行目**: End メソッド

#### Step 4: コアクラスとの連携を理解する

グループからコアクラスへの呼び出し関係を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCore.Group メソッドと各ルート登録メソッド |

**主要処理フロー**:
- **200-203行目**: THorseCore.Group メソッド（InternalGroupを呼び出し）
- **239-242行目**: InternalGroup メソッド（THorseCoreGroup<THorseCore>.Create を返却）
- **300-304行目**: Get メソッド（RegisterRoute でルーティングツリーに登録）
- **205-212行目**: RegisterRoute メソッド（GetRoutes.RegisterRouteを呼び出し）

### プログラム呼び出し階層図

```
THorseCore.Group
    │
    └─ THorseCoreGroup<THorseCore>.Create
           │
           ├─ Prefix(プレフィックス文字列)
           │      └─ FPrefix = '/' + プレフィックス.Trim(['/'])
           │
           ├─ Get(パス, コールバック)
           │      └─ THorseCore.Get(NormalizePath(パス), コールバック)
           │             └─ THorseRouterTree.RegisterRoute
           │
           ├─ Post(パス, コールバック)
           │      └─ THorseCore.Post(NormalizePath(パス), コールバック)
           │
           ├─ Use(ミドルウェア)
           │      └─ THorseCore.Use(NormalizePath('/'), ミドルウェア)
           │             └─ THorseRouterTree.RegisterMiddleware
           │
           ├─ Route(パス)
           │      └─ THorseCore.Route(NormalizePath(パス))
           │             └─ THorseCoreRoute<THorseCore>.Create
           │
           └─ End
                  └─ FHorseCore as THorseCore
```

### データフロー図

```
[入力]                    [処理]                         [出力]

プレフィックス文字列 ───▶ Prefix メソッド ────────────▶ FPrefix設定
                              │
                              ▼
パス + コールバック ───▶ Get/Post/Put等 ─────────────▶ NormalizePath適用
                              │                             │
                              ▼                             ▼
                    THorseCore.XXX呼び出し ───▶ THorseRouterTree登録
                              │
                              ▼
ミドルウェア ───────────▶ Use メソッド ────────────────▶ ミドルウェア登録
                              │
                              ▼
                         End メソッド ────────────────▶ THorseCore返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Core.Group.Contract.pas | `src/Horse.Core.Group.Contract.pas` | ソース | IHorseCoreGroup<T>インターフェース定義 |
| Horse.Core.Group.pas | `src/Horse.Core.Group.pas` | ソース | THorseCoreGroup<T>実装クラス |
| Horse.Core.Route.Contract.pas | `src/Horse.Core.Route.Contract.pas` | ソース | IHorseCoreRoute<T>インターフェース定義 |
| Horse.Core.Route.pas | `src/Horse.Core.Route.pas` | ソース | THorseCoreRoute<T>実装クラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCore コアクラス |
| Horse.Callback.pas | `src/Horse.Callback.pas` | ソース | コールバック型定義 |
| Horse.Core.RouterTree.pas | `src/Horse.Core.RouterTree.pas` | ソース | ルーティングツリー実装 |
