# 機能設計書 33-ルート定義

## 概要

本ドキュメントは、Horseフレームワークにおけるルート定義機能の詳細設計を記載したものである。THorseCoreRoute クラスを使用して、特定のURLパスに対するルートオブジェクトを定義し、そのパスに対して複数のHTTPメソッドやコールバックをまとめて設定する機能について説明する。

### 本機能の処理概要

**業務上の目的・背景**：REST APIの設計において、同一のリソースパス（例：/users/:id）に対して、GETで取得、PUTで更新、DELETEで削除といった複数のHTTPメソッドを定義することが一般的である。本機能は、同一パスに対する複数のHTTPメソッド定義をまとめて記述できるようにし、コードの重複を削減してメンテナンス性を向上させる。

**機能の利用シーン**：本機能は、以下のようなシーンで利用される。
- 同一リソースに対する CRUD 操作の定義（GET/POST/PUT/DELETE）
- 特定パスへの複数ミドルウェアの適用
- パス単位でのルート設定のカプセル化
- フルーエントAPIによる直感的なルート定義

**主要な処理内容**：
1. 特定パスに対するルートオブジェクトの生成（THorseCore.Route）
2. 各種HTTPメソッドの登録（Get, Post, Put, Delete, Patch, Head, All）
3. コールバックの追加（AddCallback, AddCallbacks）
4. ルート定義の終了と親オブジェクトへの復帰（End メソッド）

**関連システム・外部連携**：ルート定義は THorseCore のルーティングシステムと連携し、THorseRouterTree に登録されたルート定義に基づいてHTTPリクエストを処理する。

**権限による制御**：ルート定義自体に権限制御はないが、コールバック内で認証・認可処理を実装することで、エンドポイント単位でのアクセス制御が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面に直接関連しない（API設計時に使用） |

## 機能種別

ルーティング設定 / API設計

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| APath | string | Yes | ルートパス | なし |
| ACallback | THorseCallback / THorseCallbackRequestResponse / THorseCallbackRequest / THorseCallbackResponse | Yes | リクエスト処理コールバック | なし |
| ACallbacks | TArray<THorseCallback> / array of THorseCallback | No | 複数のコールバック（ミドルウェア等） | なし |
| AMiddleware | THorseCallback | No | ミドルウェアコールバック | なし |

### 入力データソース

- アプリケーション起動時のルート定義コード
- コールバック関数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IHorseCoreRoute<T> | Interface | ルートオブジェクトインターフェース（フルーエントインターフェース） |
| T | class | 親オブジェクト（End メソッドで返却） |

### 出力先

THorseRouterTree（ルーティングツリー）にルート定義が登録される

## 処理フロー

### 処理シーケンス

```
1. THorseCore.Route(パス)でルートインスタンス生成
   └─ THorseCoreRoute<THorseCore>.Create(パス) が呼ばれ、FPathにパス、FHorseCoreにTHorseCoreインスタンスを格納
2. Get(コールバック)でGETメソッドのルートを登録
   └─ THorseCore(FHorseCore).Get(FPath, ACallback) を呼び出し
3. Post(コールバック)でPOSTメソッドのルートを登録
   └─ THorseCore(FHorseCore).Post(FPath, ACallback) を呼び出し
4. Put(コールバック)でPUTメソッドのルートを登録
   └─ THorseCore(FHorseCore).Put(FPath, ACallback) を呼び出し
5. Delete(コールバック)でDELETEメソッドのルートを登録
   └─ THorseCore(FHorseCore).Delete(FPath, ACallback) を呼び出し
6. All(コールバック)で全HTTPメソッドのルートを登録
   └─ THorseCore(FHorseCore).Use(FPath, ACallback) を呼び出し
7. End でルート定義を終了し、親オブジェクト（THorseCore）を返却
   └─ FHorseCore を T 型にキャストして返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[THorseCore.Route パス]
    B --> C[THorseCoreRoute.Create パス]
    C --> D{HTTPメソッド登録?}
    D -->|Get| E[Get コールバック登録]
    D -->|Post| F[Post コールバック登録]
    D -->|Put| G[Put コールバック登録]
    D -->|Delete| H[Delete コールバック登録]
    D -->|Patch| I[Patch コールバック登録]
    D -->|Head| J[Head コールバック登録]
    D -->|All| K[All 全メソッド登録]
    E --> L{追加登録?}
    F --> L
    G --> L
    H --> L
    I --> L
    J --> L
    K --> L
    L -->|Yes| D
    L -->|No| M[End で親オブジェクトに復帰]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | パス固定 | コンストラクタで指定されたパスは変更不可 | インスタンス生成時 |
| BR-33-02 | フルーエントAPI | 各メソッドはSelfを返却し、メソッドチェーンが可能 | 全メソッド |
| BR-33-03 | 複数メソッド登録 | 同一パスに対して複数のHTTPメソッドを登録可能 | 各メソッド呼び出し時 |
| BR-33-04 | 親オブジェクト復帰 | End メソッドで親の THorseCore に戻り、通常のルート定義を継続可能 | ルート定義終了時 |
| BR-33-05 | All メソッド | All メソッドはUse（ミドルウェア）として登録される | All呼び出し時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

本機能ではデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 実行時エラー | THorseCoreインスタンスが未生成の状態でRoute呼び出し | アプリケーション初期化を確認 |
| - | コンパイルエラー | 不正なコールバック型の指定 | 正しい型のコールバックを使用 |

### リトライ仕様

リトライは不要（設定時の一時的処理）。

## トランザクション仕様

トランザクション処理は行わない（設定処理のみ）。

## パフォーマンス要件

- ルート定義はアプリケーション起動時に1回のみ実行
- ルーティングツリーへの登録処理は高速

## セキュリティ考慮事項

- コールバック内で認証・認可処理を実装することで、エンドポイント単位でのアクセス制御が可能
- AddCallbackでミドルウェアを追加することで、共通のセキュリティ処理を適用可能

## 備考

- Route は Group と異なり、単一パスに対する定義をまとめるもの
- Group.Route(パス) を使用することで、グループプレフィックス付きのルートオブジェクトを生成可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ルートオブジェクトのインターフェース定義から始める。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Route.Contract.pas | `src/Horse.Core.Route.Contract.pas` | IHorseCoreRoute<T>インターフェースの全メソッド定義を確認 |

**読解のコツ**:
- ジェネリクス `<T: class>` により、親クラスの型を柔軟に指定可能
- 各HTTPメソッド（Get, Post等）は複数のオーバーロードを持つ（コールバック型の違い）
- `{$IFNDEF FPC}` は Delphi 専用コード、`{$IF (DEFINED(FPC) OR (CompilerVersion > 27.0))}` はFPC/新Delphi用

**主要処理フロー**:
- **13-60行目**: IHorseCoreRoute<T>インターフェース定義
- **15-16行目**: AddCallback, AddCallbacks メソッド
- **17-20行目**: All メソッドのオーバーロード群
- **21-26行目**: Get メソッドのオーバーロード群
- **27-32行目**: Put メソッドのオーバーロード群
- **33-38行目**: Head メソッドのオーバーロード群
- **39-44行目**: Post メソッドのオーバーロード群
- **45-58行目**: Patch, Delete メソッドのオーバーロード群
- **59行目**: End メソッド

#### Step 2: 実装クラスを理解する

インターフェースを実装する具象クラスの詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Core.Route.pas | `src/Horse.Core.Route.pas` | THorseCoreRoute<T>クラスの実装詳細を確認 |

**主要処理フロー**:
- **17-69行目**: THorseCoreRoute<T>クラス定義
- **19行目**: FPath フィールド（ルートパス）
- **20行目**: FHorseCore フィールド（親オブジェクト参照）
- **76-80行目**: コンストラクタ（FPathにパス、THorseCore.GetInstanceをFHorseCoreに格納）
- **82-85行目**: This メソッド（Self を返却）
- **105-108行目**: End メソッド実装（FHorseCore as T を返却）
- **87-91行目**: All メソッド実装（THorseCore.Use を呼び出し）
- **177-181行目**: Get メソッド実装（THorseCore.Get を呼び出し）
- **189-193行目**: Post メソッド実装（THorseCore.Post を呼び出し）
- **195-199行目**: Put メソッド実装（THorseCore.Put を呼び出し）
- **124-128行目**: Delete メソッド実装（THorseCore.Delete を呼び出し）
- **130-134行目**: Patch メソッド実装（THorseCore.Patch を呼び出し）
- **183-187行目**: Head メソッド実装（THorseCore.Head を呼び出し）
- **110-114行目**: AddCallback メソッド実装
- **201-208行目**: AddCallbacks メソッド実装

**読解のコツ**:
- 各メソッドは `THorseCore(FHorseCore).XXX(FPath, ACallback)` の形式で親クラスのメソッドを呼び出す
- `Result := Self` でフルーエントインターフェースを実現
- All メソッドは Get/Post等とは異なり、Use（ミドルウェア）として登録される

#### Step 3: コアクラスとの連携を理解する

ルートオブジェクトからコアクラスへの呼び出し関係を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCore.Route メソッドと各ルート登録メソッド |

**主要処理フロー**:
- **214-217行目**: THorseCore.Route メソッド（InternalRouteを呼び出し）
- **244-247行目**: InternalRoute メソッド（THorseCoreRoute<THorseCore>.Create を返却）
- **300-304行目**: Get メソッド（RegisterRoute でルーティングツリーに登録）
- **306-310行目**: Post メソッド
- **336-340行目**: Put メソッド
- **287-291行目**: Delete メソッド
- **329-333行目**: Patch メソッド
- **294-298行目**: Head メソッド
- **393-403行目**: Use メソッド（RegisterMiddleware でミドルウェアを登録）

### プログラム呼び出し階層図

```
THorseCore.Route(パス)
    │
    └─ THorseCoreRoute<THorseCore>.Create(パス)
           │
           ├─ Get(コールバック)
           │      └─ THorseCore.Get(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterRoute(mtGet, パス, コールバック)
           │
           ├─ Post(コールバック)
           │      └─ THorseCore.Post(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterRoute(mtPost, パス, コールバック)
           │
           ├─ Put(コールバック)
           │      └─ THorseCore.Put(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterRoute(mtPut, パス, コールバック)
           │
           ├─ Delete(コールバック)
           │      └─ THorseCore.Delete(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterRoute(mtDelete, パス, コールバック)
           │
           ├─ Patch(コールバック)
           │      └─ THorseCore.Patch(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterRoute(mtPatch, パス, コールバック)
           │
           ├─ Head(コールバック)
           │      └─ THorseCore.Head(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterRoute(mtHead, パス, コールバック)
           │
           ├─ All(コールバック)
           │      └─ THorseCore.Use(FPath, コールバック)
           │             └─ THorseRouterTree.RegisterMiddleware(パス, コールバック)
           │
           ├─ AddCallback(コールバック)
           │      └─ THorseCore.AddCallback(コールバック)
           │
           └─ End
                  └─ FHorseCore as THorseCore
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パス文字列 ─────────────▶ THorseCoreRoute.Create ─────▶ FPath設定
                              │
                              ▼
コールバック ───────────▶ Get/Post/Put等 ──────────────▶ THorseCore.XXX呼び出し
                              │                             │
                              ▼                             ▼
                    THorseRouterTree.RegisterRoute ──▶ ルーティングツリー登録
                              │
                              ▼
                         End メソッド ────────────────▶ THorseCore返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Core.Route.Contract.pas | `src/Horse.Core.Route.Contract.pas` | ソース | IHorseCoreRoute<T>インターフェース定義 |
| Horse.Core.Route.pas | `src/Horse.Core.Route.pas` | ソース | THorseCoreRoute<T>実装クラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCore コアクラス |
| Horse.Callback.pas | `src/Horse.Callback.pas` | ソース | コールバック型定義 |
| Horse.Core.RouterTree.pas | `src/Horse.Core.RouterTree.pas` | ソース | ルーティングツリー実装 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | TMethodType等の共通型定義 |
