# 機能設計書 34-プレフィックス設定

## 概要

本ドキュメントは、Horseフレームワークにおけるプレフィックス設定機能の詳細設計を記載したものである。IHorseCoreGroup インターフェースの Prefix メソッドを使用して、ルートグループに共通のURLプレフィックスを設定し、グループ内の全ルートに自動的に適用する機能について説明する。

### 本機能の処理概要

**業務上の目的・背景**：REST APIの設計において、バージョン管理（/api/v1, /api/v2）やリソースのカテゴリ分け（/admin, /public）など、URLパスに共通のプレフィックスを付与することが一般的である。本機能は、ルートグループに対して共通プレフィックスを1か所で設定することで、グループ内の全ルート定義に自動的にプレフィックスを適用し、コードの重複を削減してメンテナンス性を向上させる。

**機能の利用シーン**：本機能は、以下のようなシーンで利用される。
- APIバージョニング（/api/v1/users, /api/v1/products → prefix: '/api/v1'）
- 管理者用エンドポイントの分離（/admin/users, /admin/settings → prefix: '/admin'）
- マイクロサービスのパス分離（/service-a/..., /service-b/...）
- リソースカテゴリの整理（/public/..., /private/...）

**主要な処理内容**：
1. プレフィックス文字列の正規化（先頭・末尾の'/'をトリム）
2. プレフィックスの保存（FPrefixフィールド）
3. グループ内ルート定義時にプレフィックスを自動付与（NormalizePath）

**関連システム・外部連携**：本機能は THorseCoreGroup クラス内で実装され、グループ内の全ルート定義（Get, Post等）に影響を与える。

**権限による制御**：プレフィックス設定自体に権限制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面に直接関連しない（API設計時に使用） |

## 機能種別

ルーティング設定 / パス管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| APrefix | string | Yes | グループの共通URLプレフィックス | 先頭・末尾の '/' は自動的にトリム |

### 入力データソース

- アプリケーション起動時のルート定義コード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IHorseCoreGroup<T> | Interface | プレフィックスが設定されたルートグループインターフェース |

### 出力先

THorseCoreGroup のプライベートフィールド FPrefix に格納

## 処理フロー

### 処理シーケンス

```
1. THorseCore.Group.Prefix(プレフィックス文字列)を呼び出し
   └─ THorseCoreGroup<T>.Prefix メソッドが実行される
2. プレフィックス文字列の正規化
   └─ '/' + APrefix.Trim(['/']) で先頭に'/'を付け、前後の余分な'/'を除去
3. FPrefixフィールドに正規化されたプレフィックスを格納
4. 以降のルート定義（Get, Post等）でNormalizePathを通じてプレフィックスが適用される
   └─ NormalizePath: FPrefix + '/' + APath.Trim(['/'])
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[Prefix メソッド呼び出し]
    B --> C[入力: プレフィックス文字列]
    C --> D[先頭・末尾の / をトリム]
    D --> E[先頭に / を付与]
    E --> F[FPrefix に格納]
    F --> G[Result := Self を返却]
    G --> H[終了]

    subgraph NormalizePath適用時
    I[ルート定義 Get/Post等] --> J[NormalizePath 呼び出し]
    J --> K[FPrefix + / + パス.Trim]
    K --> L[結合されたパスでルート登録]
    end
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-01 | パス正規化 | プレフィックスは '/' + APrefix.Trim(['/']) の形式に正規化される | Prefix呼び出し時 |
| BR-34-02 | プレフィックス結合 | ルート定義時はプレフィックス + '/' + パス の形式で結合される | Get/Post等呼び出し時 |
| BR-34-03 | フルーエントAPI | PrefixメソッドはSelfを返却し、メソッドチェーンが可能 | Prefix呼び出し時 |
| BR-34-04 | 空プレフィックス | プレフィックスが空の場合、'/' のみとなる | 空文字列指定時 |

### 計算ロジック

**プレフィックス正規化（Prefix メソッド）**:
```pascal
FPrefix := '/' + APrefix.Trim(['/']);
```

**パス正規化（NormalizePath メソッド）**:
```pascal
Result := FPrefix + '/' + APath.Trim(['/']);
```

**例**:
- Prefix('/api/v1') → FPrefix = '/api/v1'
- Prefix('api/v1/') → FPrefix = '/api/v1'
- Prefix('/api/v1/') → FPrefix = '/api/v1'
- NormalizePath('/users') with FPrefix='/api/v1' → '/api/v1/users'

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

本機能ではデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | なし | 本機能ではエラーは発生しない | - |

### リトライ仕様

リトライは不要。

## トランザクション仕様

トランザクション処理は行わない（設定処理のみ）。

## パフォーマンス要件

- プレフィックス設定はアプリケーション起動時に1回のみ実行
- 文字列操作のみのため、パフォーマンスへの影響は軽微

## セキュリティ考慮事項

- プレフィックス設定自体にはセキュリティ上の考慮事項はない
- 管理者用パスの分離にプレフィックスを使用する場合は、ミドルウェアで認証・認可を実装すること

## 備考

- Prefix は Group 作成後すぐに呼び出すことが推奨される
- Prefix を後から変更しても、既に登録されたルートには影響しない
- THorseRouterTree の Prefix メソッドは別機能であり、本機能とは独立している

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェース定義を理解する

プレフィックス設定のインターフェース定義から始める。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Core.Group.Contract.pas | `src/Horse.Core.Group.Contract.pas` | IHorseCoreGroup<T>インターフェースのPrefixメソッド定義を確認 |

**読解のコツ**:
- Prefixメソッドは入力として文字列を受け取り、IHorseCoreGroup<T>を返却するフルーエントインターフェース

**主要処理フロー**:
- **17行目**: `function Prefix(const APrefix: string): IHorseCoreGroup<T>;` - Prefixメソッドのシグネチャ

#### Step 2: 実装を理解する

Prefixメソッドの実装詳細を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Core.Group.pas | `src/Horse.Core.Group.pas` | THorseCoreGroup<T>.Prefixメソッドの実装を確認 |

**主要処理フロー**:
- **18行目**: `FPrefix: string;` - プレフィックスを保持するプライベートフィールド
- **219-223行目**: Prefixメソッド実装
  - **221行目**: `Result := Self;` - フルーエントインターフェースの返却
  - **222行目**: `FPrefix := '/' + APrefix.Trim(['/']);` - プレフィックスの正規化と格納

**読解のコツ**:
- `APrefix.Trim(['/'])` は文字列の先頭と末尾から'/'を除去
- `'/' + ...` で先頭に必ず'/'を付与

#### Step 3: NormalizePathとの連携を理解する

プレフィックスがルートパスにどう適用されるかを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Core.Group.pas | `src/Horse.Core.Group.pas` | NormalizePathメソッドの実装を確認 |

**主要処理フロー**:
- **321-324行目**: NormalizePath メソッド実装
  - **323行目**: `Result := FPrefix + '/' + APath.Trim(['/']);` - プレフィックスとパスの結合

**読解のコツ**:
- すべてのルート定義メソッド（Get, Post等）でNormalizePathが呼び出される
- 例: `THorseCore(FHorseCore).Get(NormalizePath(APath), ACallback);`

#### Step 4: ルート定義での使用例を理解する

各HTTPメソッド登録時のNormalizePath呼び出しを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Horse.Core.Group.pas | `src/Horse.Core.Group.pas` | Get, Post等のメソッドでのNormalizePath使用 |

**主要処理フロー**:
- **95-96行目**: Getメソッドでの使用例
  ```pascal
  THorseCore(FHorseCore).Get(NormalizePath(APath), ACallback);
  ```
- **115-116行目**: Postメソッドでの使用例
  ```pascal
  THorseCore(FHorseCore).Post(NormalizePath(APath), ACallback);
  ```
- **239行目**: Useメソッドでの使用例
  ```pascal
  THorseCore(FHorseCore).Use(NormalizePath('/'), ACallback);
  ```

### プログラム呼び出し階層図

```
THorseCore.Group
    │
    └─ THorseCoreGroup<T>.Create
           │
           └─ Prefix(プレフィックス文字列)
                  │
                  ├─ APrefix.Trim(['/']) で前後の'/'を除去
                  │
                  ├─ '/' + トリム済み文字列 で先頭に'/'を付与
                  │
                  └─ FPrefix に格納
                         │
                         └─ 以降のルート定義で使用
                                │
                                └─ NormalizePath(パス)
                                       │
                                       └─ FPrefix + '/' + パス.Trim(['/'])
```

### データフロー図

```
[入力]                    [処理]                         [出力]

プレフィックス文字列 ──▶ Prefix メソッド ─────────────▶ FPrefix設定
 例: '/api/v1/'            │                              │
                           │                              │
                           ▼                              ▼
                    Trim(['/']).Prefix('/')        '/api/v1'
                           │
                           ▼
                    ルート定義時 Get('/users', ...)
                           │
                           ▼
                    NormalizePath('/users')
                           │
                           ▼
                    FPrefix + '/' + 'users'
                           │
                           ▼
                    '/api/v1/users'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Core.Group.Contract.pas | `src/Horse.Core.Group.Contract.pas` | ソース | IHorseCoreGroup<T>インターフェース定義（Prefixメソッド含む） |
| Horse.Core.Group.pas | `src/Horse.Core.Group.pas` | ソース | THorseCoreGroup<T>実装（Prefix, NormalizePath） |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCore コアクラス（Group メソッド） |
| Horse.Core.RouterTree.pas | `src/Horse.Core.RouterTree.pas` | ソース | THorseRouterTree（独自のPrefixメソッドを持つ） |
