# 機能設計書 41-例外JSON変換

## 概要

本ドキュメントは、HorseフレームワークにおけるEHorseException例外クラスの例外情報をJSON形式に変換する機能について記述する。

### 本機能の処理概要

本機能は、HTTP例外処理において発生したエラー情報を構造化されたJSON形式に変換し、クライアントへの一貫したエラーレスポンスを提供する。

**業務上の目的・背景**：RESTful APIにおいて、エラーレスポンスは標準化されたJSON形式で返却することが求められる。本機能により、サーバーサイドで発生した例外をクライアントが解析しやすい形式に変換し、デバッグ情報やエラーの詳細をJSON構造で提供することで、APIの一貫性と保守性を向上させる。

**機能の利用シーン**：本機能は、HTTPリクエスト処理中に例外が発生した際に使用される。ミドルウェアやルートハンドラーでエラーが検出された場合、EHorseExceptionを生成し、ToJSONメソッドを呼び出すことでクライアントに返却するエラーレスポンスボディを構築する。APIクライアントはこのJSON形式のエラー情報を解析し、適切なエラーハンドリングを行うことができる。

**主要な処理内容**：
1. EHorseExceptionインスタンスの各プロパティ（type、title、code、error、hint、unit、detail）を取得
2. TJSONObjectを生成し、空でないプロパティのみをJSON要素として追加
3. Delphi/FPC両対応のコンパイラディレクティブにより適切なJSON文字列化メソッドを選択
4. JSON文字列を返却後、内部で生成したTJSONObjectを解放

**関連システム・外部連携**：本機能はHTTPレスポンス生成時に使用され、THorseResponseクラスと連携してContent-Type: application/jsonのエラーレスポンスを生成する。

**権限による制御**：本機能に権限による制御はない。例外発生時に常に利用可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Webモジュール | 参照画面 | 例外発生時にJSON形式でエラーレスポンスを構築 |
| 8 | Webモジュール | 参照画面 | 例外発生時にJSON形式でエラーレスポンスを構築（Lazarus版） |

## 機能種別

データ変換処理 / 例外処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FType | TMessageType | No | メッセージ種別（Default/Error/Warning/Information） | Default以外の場合のみJSON出力 |
| FTitle | string | No | エラータイトル | 空文字でない場合のみJSON出力 |
| FCode | Integer | No | エラーコード | 0以外の場合のみJSON出力 |
| FError | string | Yes | エラーメッセージ | 常にJSON出力 |
| FHint | string | No | ヒント情報 | 空文字でない場合のみJSON出力 |
| FUnit | string | No | 発生元ユニット名 | 空文字でない場合のみJSON出力 |
| FDetail | string | No | 詳細情報 | 空文字でない場合のみJSON出力 |

### 入力データソース

EHorseExceptionインスタンスの内部フィールド（FluentインターフェースまたはプロパティによりSet）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| type | string | メッセージ種別（Default以外の場合のみ） |
| title | string | エラータイトル（設定時のみ） |
| code | number | エラーコード（0以外の場合のみ） |
| error | string | エラーメッセージ（必須） |
| hint | string | ヒント情報（設定時のみ） |
| unit | string | 発生元ユニット名（設定時のみ） |
| detail | string | 詳細情報（設定時のみ） |

### 出力先

JSON文字列（string型）としてメソッド戻り値で返却

## 処理フロー

### 処理シーケンス

```
1. ToJSON メソッド呼び出し
   └─ ToJSONObject を呼び出してTJSONObjectを生成
2. ToJSONObject 内部処理
   └─ 新規 TJSONObject インスタンス生成
   └─ FType が Default でない場合、'type' キーを追加
   └─ FTitle が空でない場合、'title' キーを追加
   └─ FCode が 0 でない場合、'code' キーを追加
   └─ FError を 'error' キーとして追加（必須）
   └─ FHint が空でない場合、'hint' キーを追加
   └─ FUnit が空でない場合、'unit' キーを追加
   └─ FDetail が空でない場合、'detail' キーを追加
3. JSON文字列化
   └─ FPC: LJSON.AsJSON を使用
   └─ Delphi (>27.0): LJSON.ToJSON を使用
   └─ Delphi (<=27.0): LJSON.ToString を使用
4. TJSONObject の解放
5. JSON文字列を返却
```

### フローチャート

```mermaid
flowchart TD
    A[ToJSON 呼び出し] --> B[ToJSONObject 呼び出し]
    B --> C[TJSONObject 生成]
    C --> D{FType <> Default?}
    D -->|Yes| E[type 追加]
    D -->|No| F{FTitle 空でない?}
    E --> F
    F -->|Yes| G[title 追加]
    F -->|No| H{FCode <> 0?}
    G --> H
    H -->|Yes| I[code 追加]
    H -->|No| J[error 追加]
    I --> J
    J --> K{FHint 空でない?}
    K -->|Yes| L[hint 追加]
    K -->|No| M{FUnit 空でない?}
    L --> M
    M -->|Yes| N[unit 追加]
    M -->|No| O{FDetail 空でない?}
    N --> O
    O -->|Yes| P[detail 追加]
    O -->|No| Q[JSON文字列化]
    P --> Q
    Q --> R[TJSONObject 解放]
    R --> S[JSON文字列返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須フィールド | errorフィールドは常にJSON出力に含める | 常時 |
| BR-02 | 条件付きフィールド | 空文字または初期値のフィールドはJSON出力から除外する | 各フィールド評価時 |
| BR-03 | クロスプラットフォーム対応 | FPCとDelphiで異なるJSON生成APIを使用する | コンパイル時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | メモリ不足 | TJSONObject生成時にメモリ確保失敗 | 例外が上位に伝播 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

トランザクション処理なし

## パフォーマンス要件

- JSON生成処理は軽量であること
- 大量のエラー発生時もレスポンス時間に影響を与えないこと

## セキュリティ考慮事項

- エラー詳細情報（detail、unit）は本番環境では制限することを推奨
- スタックトレースなどの機密情報をJSONに含めないこと

## 備考

- ToJSONObjectメソッドは継承クラスでオーバーライド可能（virtual宣言）
- Fluentインターフェースにより、メソッドチェーンで例外を構築可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、例外クラスの構造と保持するデータを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | THTTPStatus列挙型とTMessageType列挙型の定義を確認 |

**読解のコツ**: Delphiの`{$SCOPEDENUMS ON}`により、列挙型はスコープ付きで参照される（例: TMessageType.Error）。

#### Step 2: エントリーポイントを理解する

例外クラスの定義とJSON変換メソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Exception.pas | `src/Horse.Exception.pas` | EHorseExceptionクラスの全体構造とToJSON/ToJSONObjectメソッド |

**主要処理フロー**:
1. **21-52行目**: EHorseExceptionクラス宣言、プライベートフィールドとパブリックメソッド
2. **63-68行目**: コンストラクタ - 初期値設定（FStatus = InternalServerError）
3. **164-174行目**: ToJSONメソッド - ToJSONObjectを呼び出しJSON文字列を生成
4. **176-199行目**: ToJSONObjectメソッド - 条件付きでJSON要素を追加

#### Step 3: JSON生成処理の詳細を理解する

JSON生成におけるクロスプラットフォーム対応の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Exception.pas | `src/Horse.Exception.pas` | コンパイラディレクティブによるFPC/Delphi分岐 |

**主要処理フロー**:
- **170行目**: `{$IF DEFINED(FPC)}LJSON.AsJSON{$ELSE}...` - プラットフォーム別JSON文字列化
- **181行目**: `Result.{$IF DEFINED(FPC)}Add{$ELSE}AddPair{$ENDIF}` - JSON要素追加の分岐
- **187行目**: `{$IF DEFINED(FPC)}TJSONIntegerNumber{$ELSE}TJSONNumber{$ENDIF}` - 数値型の分岐

### プログラム呼び出し階層図

```
EHorseException.ToJSON
    │
    ├─ EHorseException.ToJSONObject
    │      ├─ TJSONObject.Create
    │      ├─ TJSONObject.Add / AddPair（条件付きで複数回）
    │      └─ GetEnumName（TMessageType変換）
    │
    └─ TJSONObject.AsJSON / ToJSON / ToString
           └─ TJSONObject.Free
```

### データフロー図

```
[入力]                    [処理]                         [出力]

EHorseException     ───▶  ToJSONObject              ───▶  JSON文字列
  ├─ FType                  │                              {
  ├─ FTitle                 ├─ TJSONObject生成              "type": "...",
  ├─ FCode                  ├─ 条件チェック                   "title": "...",
  ├─ FError                 ├─ フィールド追加                  "code": N,
  ├─ FHint                  └─ JSON文字列化                   "error": "...",
  ├─ FUnit                                                   "hint": "...",
  └─ FDetail                                                 "unit": "...",
                                                             "detail": "..."
                                                            }
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Exception.pas | `src/Horse.Exception.pas` | ソース | EHorseExceptionクラス定義とToJSON実装 |
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | THTTPStatus、TMessageType列挙型定義 |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | 例外ハンドリングとレスポンス生成 |
