# 機能設計書 42-割り込み例外

## 概要

本ドキュメントは、Horseフレームワークにおけるコールバックチェーンを中断するための専用例外クラスEHorseCallbackInterruptedについて記述する。

### 本機能の処理概要

本機能は、ミドルウェアやルートハンドラーの処理チェーン中に、明示的に処理を中断させるための例外機構を提供する。

**業務上の目的・背景**：RESTful APIのミドルウェアパターンでは、リクエスト処理が複数のコールバック関数を順次実行する。認証失敗、バリデーションエラー、早期レスポンス返却など、後続の処理をスキップしてレスポンスを返却したい場面がある。本機能は、通常のエラー例外とは区別された「制御フロー用例外」を提供し、意図的なチェーン中断を実現する。

**機能の利用シーン**：本機能は以下のような場面で使用される。
- 認証ミドルウェアで認証失敗を検出した際に、後続のルートハンドラーを実行せずにエラーレスポンスを返却する
- バリデーションミドルウェアで入力検証エラーを検出した際
- キャッシュミドルウェアでキャッシュヒットした際に、本処理をスキップしてキャッシュレスポンスを返却する

**主要な処理内容**：
1. EHorseCallbackInterruptedインスタンスを生成（メッセージあり/なし）
2. 例外をraiseしてコールバックチェーンを中断
3. WebModuleのハンドラーで例外をキャッチし、処理を終了（エラーログ出力なし）

**関連システム・外部連携**：本機能はTHorseWebModuleおよびプロバイダー層と連携し、例外発生時の処理終了を制御する。

**権限による制御**：本機能に権限による制御はない。任意のコールバック内から発生可能である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | Webモジュール | 主機能 | EHorseCallbackInterrupted例外を捕捉してコールバックチェーンの中断を処理 |
| 8 | Webモジュール | 主機能 | EHorseCallbackInterrupted例外を捕捉してコールバックチェーンの中断を処理（Lazarus版） |

## 機能種別

例外処理 / 制御フロー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AMessage | string | No | 例外メッセージ | なし（空文字許可） |

### 入力データソース

コールバック関数内からの直接生成（raise文による発生）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Message | string | 例外メッセージ（継承元Exceptionより） |

### 出力先

例外オブジェクトとしてコールスタックを遡上

## 処理フロー

### 処理シーケンス

```
1. コールバック関数内でEHorseCallbackInterruptedをraise
   └─ Create または Create(AMessage) でインスタンス生成
2. 例外が発生し、コールスタックを遡上
3. WebModuleのハンドラーで例外をキャッチ
   └─ EHorseCallbackInterrupted型を識別
4. 通常のエラー処理をスキップし、現在のレスポンス状態で処理終了
5. HTTPレスポンスがクライアントに返却される
```

### フローチャート

```mermaid
flowchart TD
    A[コールバック実行開始] --> B{中断条件?}
    B -->|No| C[Next呼び出し]
    C --> D[次のコールバック]
    B -->|Yes| E[レスポンス設定]
    E --> F[raise EHorseCallbackInterrupted]
    F --> G[WebModuleで例外キャッチ]
    G --> H{例外型判定}
    H -->|EHorseCallbackInterrupted| I[正常終了として処理]
    H -->|その他| J[エラー処理]
    I --> K[レスポンス返却]
    J --> K
    D --> L[処理完了]
    L --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | チェーン中断 | EHorseCallbackInterruptedが発生すると後続のコールバックは実行されない | 例外発生時 |
| BR-02 | 非エラー扱い | 本例外はエラーログに記録されない | WebModuleでキャッチ時 |
| BR-03 | レスポンス保持 | 例外発生前に設定されたレスポンス内容は保持される | 例外発生時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 意図的中断 | raise EHorseCallbackInterrupted | WebModuleで正常処理として終了 |

### リトライ仕様

リトライ処理なし（制御フロー用例外のため）

## トランザクション仕様

トランザクション処理なし

## パフォーマンス要件

- 例外生成・発生のオーバーヘッドは最小限であること
- 高頻度の利用（キャッシュヒットなど）でもパフォーマンスに影響しないこと

## セキュリティ考慮事項

- 認証・認可ミドルウェアでの使用時、例外発生後に機密処理が実行されないことを確認すること

## 備考

- 本例外はSystem.SysUtils.Exceptionを直接継承している
- EHorseExceptionとは異なり、JSON変換機能を持たない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

割り込み例外クラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | EHorseCallbackInterruptedクラスの定義 |

**読解のコツ**: このクラスはSystem.SysUtils.Exceptionを直接継承しており、非常にシンプルな構造である。

#### Step 2: エントリーポイントを理解する

例外クラスの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | コンストラクタの2つのオーバーロード |

**主要処理フロー**:
1. **17-20行目**: クラス宣言 - Exceptionを継承、2つのコンストラクタ
2. **24-27行目**: パラメータなしコンストラクタ - 空文字でExceptionを初期化
3. **29-32行目**: メッセージ付きコンストラクタ - 指定メッセージでExceptionを初期化

#### Step 3: 利用箇所を理解する

例外がどこでキャッチされ処理されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | 例外ハンドリングのtry-except構造 |

**主要処理フロー**:
- WebModuleのリクエストハンドラ内でEHorseCallbackInterruptedを個別にキャッチ
- 通常の例外処理（エラーレスポンス生成）とは別扱いで処理終了

### プログラム呼び出し階層図

```
コールバック関数
    │
    └─ raise EHorseCallbackInterrupted.Create
           │
           └─ inherited Create(EmptyStr / AMessage)
                   │
                   └─ Exception.Create
                          │
                          ▼
                   [例外発生・伝播]
                          │
                          ▼
                   THorseWebModule.HandlerAction
                          │
                          └─ except on E: EHorseCallbackInterrupted
                                 └─ [正常終了処理]
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コールバック関数内    ───▶  EHorseCallbackInterrupted   ───▶  HTTPレスポンス
  └─ 中断判断                   │                            （設定済み内容）
  └─ レスポンス設定              └─ 例外発生
                                └─ WebModuleでキャッチ
                                └─ 処理終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Exception.Interrupted.pas | `src/Horse.Exception.Interrupted.pas` | ソース | EHorseCallbackInterruptedクラス定義 |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | 例外キャッチと処理終了 |
| Horse.Callback.pas | `src/Horse.Callback.pas` | ソース | コールバック型定義 |
