# 機能設計書 43-HTTPステータス定義

## 概要

本ドキュメントは、HorseフレームワークにおけるHTTPステータスコードの列挙型定義THTTPStatusについて記述する。

### 本機能の処理概要

本機能は、HTTP/1.1およびHTTP/2で定義される標準HTTPステータスコードをDelphi/FPCの列挙型として提供し、レスポンス生成時の型安全性とコード可読性を向上させる。

**業務上の目的・背景**：HTTPステータスコードは、クライアントとサーバー間の通信結果を示す重要な情報である。数値リテラル（200、404など）を直接使用すると、タイプミスや意味の不明瞭さが生じる。本機能により、ステータスコードを列挙型として定義することで、コンパイル時の型チェック、IDE補完による開発効率向上、コードの自己文書化を実現する。

**機能の利用シーン**：本機能は以下のような場面で使用される。
- THorseResponse.Statusメソッドでレスポンスステータスを設定する際
- EHorseException.Statusで例外のHTTPステータスを指定する際
- ミドルウェアやルートハンドラーでステータスに応じた分岐処理を行う際

**主要な処理内容**：
1. THTTPStatus列挙型の定義（1xx〜5xxの標準ステータスコード）
2. THTTPStatusHelper型ヘルパーによる整数変換機能
3. スコープ付き列挙型によるTHTTPStatus.OK形式でのアクセス

**関連システム・外部連携**：HTTPレスポンス生成、例外処理、ミドルウェア等フレームワーク全体で使用される。

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に依存しないユーティリティ機能 |

## 機能種別

定数定義 / ユーティリティ

## 入力仕様

### 入力パラメータ

入力パラメータなし（列挙型定義）

### 入力データソース

なし

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| THTTPStatus | 列挙型 | HTTPステータスコードを表す列挙型 |
| THTTPStatusHelper.ToInteger | Integer | ステータスコードの整数値 |

### 出力先

型定義としてコンパイル時に解決

## 処理フロー

### 処理シーケンス

```
1. THTTPStatus列挙値を指定
   └─ 例: THTTPStatus.OK
2. ToIntegerヘルパーメソッド呼び出し（必要に応じて）
   └─ Ord(Self) により列挙値を整数に変換
3. 整数値（例: 200）を返却
```

### フローチャート

```mermaid
flowchart TD
    A[THTTPStatus列挙値] --> B{整数値が必要?}
    B -->|Yes| C[ToIntegerメソッド呼び出し]
    C --> D[Ord関数で変換]
    D --> E[Integer値返却]
    B -->|No| F[列挙値として使用]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | スコープ付き列挙型 | THTTPStatus.OK形式でアクセスする必要がある | {$SCOPEDENUMS ON}有効時 |
| BR-02 | 値の直接代入 | 列挙値にHTTPステータスコード数値が直接代入されている | 列挙型定義 |
| BR-03 | 標準準拠 | RFC 7231等のHTTP標準に準拠したステータスコードを定義 | 常時 |

### 計算ロジック

```pascal
function THTTPStatusHelper.ToInteger: Integer;
begin
  Result := Ord(Self);  // 列挙値の序数値（=代入された整数値）を返却
end;
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

エラーケースなし（コンパイル時に型チェック）

### リトライ仕様

該当なし

## トランザクション仕様

トランザクション処理なし

## パフォーマンス要件

- 列挙型のため、実行時オーバーヘッドなし

## セキュリティ考慮事項

特になし

## 備考

- 定義されているステータスコード一覧：
  - 1xx: Continue(100), SwitchingProtocols(101), Processing(102)
  - 2xx: OK(200), Created(201), Accepted(202), NoContent(204)など
  - 3xx: MultipleChoices(300), MovedPermanently(301), Found(302)など
  - 4xx: BadRequest(400), Unauthorized(401), Forbidden(403), NotFound(404)など
  - 5xx: InternalServerError(500), NotImplemented(501), BadGateway(502)など

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HTTPステータス列挙型の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | THTTPStatus列挙型の完全な定義 |

**読解のコツ**: `{$SCOPEDENUMS ON}`ディレクティブにより、列挙値はスコープ付きでアクセスする必要がある（例: THTTPStatus.OK）。

#### Step 2: 型ヘルパーを理解する

列挙型のヘルパーメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | THTTPStatusHelper型ヘルパーの定義と実装 |

**主要処理フロー**:
1. **23行目**: `{$SCOPEDENUMS ON}` - スコープ付き列挙型の有効化
2. **24-87行目**: THTTPStatus列挙型定義 - 各ステータスコードに対応する整数値を代入
3. **115-117行目**: THTTPStatusHelper型ヘルパー宣言
4. **251-254行目**: ToIntegerメソッド実装 - Ord関数で整数変換

#### Step 3: 利用例を理解する

実際の使用パターンを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Response.pas | `src/Horse.Response.pas` | Statusメソッドでの使用例 |
| 3-2 | Horse.Exception.pas | `src/Horse.Exception.pas` | 例外でのステータス指定 |

### プログラム呼び出し階層図

```
アプリケーションコード
    │
    ├─ THorseResponse.Status(THTTPStatus.OK)
    │      └─ THTTPStatus.ToInteger
    │             └─ Ord(Self) = 200
    │
    └─ EHorseException.Status(THTTPStatus.NotFound)
           └─ FStatus := AValue
```

### データフロー図

```
[入力]                    [処理]                         [出力]

THTTPStatus.OK      ───▶  列挙型参照解決              ───▶  列挙値
       │                                                    │
       └──────────────▶  ToInteger                    ───▶  Integer (200)
                              │
                              └─ Ord(Self)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | THTTPStatus列挙型とヘルパー定義 |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | ステータス設定での使用 |
| Horse.Exception.pas | `src/Horse.Exception.pas` | ソース | 例外ステータス指定での使用 |

### 定義されている全ステータスコード

| カテゴリ | 列挙値 | 数値 | 説明 |
|---------|--------|------|------|
| 1xx | Continue | 100 | 継続 |
| 1xx | SwitchingProtocols | 101 | プロトコル切替 |
| 1xx | Processing | 102 | 処理中 |
| 2xx | OK | 200 | 成功 |
| 2xx | Created | 201 | 作成完了 |
| 2xx | Accepted | 202 | 受理 |
| 2xx | NonAuthoritativeInformation | 203 | 非権威的情報 |
| 2xx | NoContent | 204 | 内容なし |
| 2xx | ResetContent | 205 | 内容リセット |
| 2xx | PartialContent | 206 | 部分的内容 |
| 2xx | MultiStatus | 207 | 複数ステータス |
| 2xx | AlreadyReported | 208 | 既に報告済み |
| 2xx | IMUsed | 226 | IM使用 |
| 3xx | MultipleChoices | 300 | 複数選択 |
| 3xx | MovedPermanently | 301 | 恒久的移動 |
| 3xx | Found | 302 | 発見 |
| 3xx | SeeOther | 303 | 他を参照 |
| 3xx | NotModified | 304 | 未更新 |
| 3xx | UseProxy | 305 | プロキシ使用 |
| 3xx | TemporaryRedirect | 307 | 一時的リダイレクト |
| 3xx | PermanentRedirect | 308 | 恒久的リダイレクト |
| 4xx | BadRequest | 400 | 不正リクエスト |
| 4xx | Unauthorized | 401 | 未認証 |
| 4xx | PaymentRequired | 402 | 支払い要求 |
| 4xx | Forbidden | 403 | 禁止 |
| 4xx | NotFound | 404 | 未検出 |
| 4xx | MethodNotAllowed | 405 | メソッド不許可 |
| 4xx | NotAcceptable | 406 | 受理不可 |
| 4xx | ProxyAuthenticationRequired | 407 | プロキシ認証要求 |
| 4xx | RequestTimeout | 408 | リクエストタイムアウト |
| 4xx | Conflict | 409 | 競合 |
| 4xx | Gone | 410 | 消滅 |
| 4xx | LengthRequired | 411 | 長さ要求 |
| 4xx | PreconditionFailed | 412 | 前提条件失敗 |
| 4xx | PayloadTooLarge | 413 | ペイロード過大 |
| 4xx | RequestURITooLong | 414 | URI過長 |
| 4xx | UnsupportedMediaType | 415 | 非対応メディア |
| 4xx | RequestedRangeNotSatisfiable | 416 | 範囲不満足 |
| 4xx | ExpectationFailed | 417 | 期待失敗 |
| 4xx | Imateapot | 418 | ティーポット |
| 4xx | MisdirectedRequest | 421 | 誤送信リクエスト |
| 4xx | UnprocessableEntity | 422 | 処理不能エンティティ |
| 4xx | Locked | 423 | ロック中 |
| 4xx | FailedDependency | 424 | 依存関係失敗 |
| 4xx | UpgradeRequired | 426 | アップグレード要求 |
| 4xx | PreconditionRequired | 428 | 前提条件要求 |
| 4xx | TooManyRequests | 429 | リクエスト過多 |
| 4xx | RequestHeaderFieldsTooLarge | 431 | ヘッダ過大 |
| 4xx | ConnectionClosedWithoutResponse | 444 | レスポンスなし切断 |
| 4xx | UnavailableForLegalReasons | 451 | 法的理由で利用不可 |
| 4xx | ClientClosedRequest | 499 | クライアント切断 |
| 5xx | InternalServerError | 500 | サーバー内部エラー |
| 5xx | NotImplemented | 501 | 未実装 |
| 5xx | BadGateway | 502 | 不正ゲートウェイ |
| 5xx | ServiceUnavailable | 503 | サービス利用不可 |
| 5xx | GatewayTimeout | 504 | ゲートウェイタイムアウト |
| 5xx | HTTPVersionNotSupported | 505 | HTTPバージョン非対応 |
| 5xx | VariantAlsoNegotiates | 506 | バリアント交渉 |
| 5xx | InsufficientStorage | 507 | ストレージ不足 |
| 5xx | LoopDetected | 508 | ループ検出 |
| 5xx | NotExtended | 510 | 拡張なし |
| 5xx | NetworkAuthenticationRequired | 511 | ネットワーク認証要求 |
| 5xx | NetworkConnectTimeoutError | 599 | ネットワーク接続タイムアウト |
