# 機能設計書 44-MIMEタイプ定義

## 概要

本ドキュメントは、HorseフレームワークにおけるMIMEタイプの列挙型定義TMimeTypesについて記述する。

### 本機能の処理概要

本機能は、HTTPコンテンツタイプとして使用される一般的なMIMEタイプをDelphi/FPCの列挙型として提供し、レスポンスのContent-Type設定時の型安全性を実現する。

**業務上の目的・背景**：HTTPレスポンスでは、コンテンツの種類をContent-Typeヘッダーで指定する必要がある。MIMEタイプ文字列（"application/json"など）を直接記述すると、タイプミスや不整合が発生しやすい。本機能により、よく使用されるMIMEタイプを列挙型として定義し、ToStringヘルパーメソッドで正確な文字列を取得できるようにする。

**機能の利用シーン**：本機能は以下のような場面で使用される。
- THorseResponse.ContentTypeメソッドでレスポンスのMIMEタイプを設定する際
- ファイルダウンロード時のContent-Type判定
- リクエストのContent-Type検証

**主要な処理内容**：
1. TMimeTypes列挙型の定義（主要なMIMEタイプをカバー）
2. TMimeTypesHelper型ヘルパーによる文字列変換機能
3. 列挙値から標準MIMEタイプ文字列への変換

**関連システム・外部連携**：HTTPレスポンス生成、ファイル送信機能と連携。

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に依存しないユーティリティ機能 |

## 機能種別

定数定義 / ユーティリティ

## 入力仕様

### 入力パラメータ

入力パラメータなし（列挙型定義）

### 入力データソース

なし

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TMimeTypes | 列挙型 | MIMEタイプを表す列挙型 |
| TMimeTypesHelper.ToString | string | MIMEタイプ文字列 |

### 出力先

型定義としてコンパイル時に解決、ToStringメソッドで文字列変換

## 処理フロー

### 処理シーケンス

```
1. TMimeTypes列挙値を指定
   └─ 例: TMimeTypes.ApplicationJSON
2. ToStringヘルパーメソッド呼び出し
   └─ case文により対応する文字列を返却
3. MIMEタイプ文字列（例: 'application/json'）を返却
```

### フローチャート

```mermaid
flowchart TD
    A[TMimeTypes列挙値] --> B[ToStringメソッド呼び出し]
    B --> C{case Self of}
    C -->|ApplicationJSON| D["'application/json'"]
    C -->|TextHTML| E["'text/html'"]
    C -->|ImagePNG| F["'image/png'"]
    C -->|その他| G[対応する文字列]
    D --> H[文字列返却]
    E --> H
    F --> H
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | スコープ付き列挙型 | TMimeTypes.ApplicationJSON形式でアクセスする | {$SCOPEDENUMS ON}有効時 |
| BR-02 | 標準MIMEタイプ | RFC準拠の標準MIMEタイプ文字列を返却する | ToStringメソッド呼び出し時 |
| BR-03 | ダウンロード用MIME | Download列挙値は'application/x-download'を返却 | ファイルダウンロード時 |

### 計算ロジック

```pascal
function TMimeTypesHelper.ToString: string;
begin
  case Self of
    TMimeTypes.ApplicationJSON:
      Result := 'application/json';
    // ... 他の列挙値に対応
  end;
end;
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

エラーケースなし（コンパイル時に型チェック）

### リトライ仕様

該当なし

## トランザクション仕様

トランザクション処理なし

## パフォーマンス要件

- case文による分岐のため、オーバーヘッドは最小限

## セキュリティ考慮事項

特になし

## 備考

- 定義されているMIMEタイプ一覧：
  - マルチパート: MultiPartFormData
  - アプリケーション: ApplicationXWWWFormURLEncoded, ApplicationJSON, ApplicationOctetStream, ApplicationXML, ApplicationJavaScript, ApplicationPDF, ApplicationTypeScript, ApplicationZIP
  - テキスト: TextPlain, TextCSS, TextCSV, TextHTML
  - 画像: ImageJPEG, ImagePNG, ImageGIF
  - ダウンロード: Download

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

MIMEタイプ列挙型の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | TMimeTypes列挙型の完全な定義 |

**読解のコツ**: `{$SCOPEDENUMS ON}`ディレクティブにより、列挙値はスコープ付きでアクセスする必要がある。

#### Step 2: 型ヘルパーを理解する

列挙型のヘルパーメソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Commons.pas | `src/Horse.Commons.pas` | TMimeTypesHelper型ヘルパーのToString実装 |

**主要処理フロー**:
1. **89-106行目**: TMimeTypes列挙型定義 - 各MIMEタイプに対応する列挙値
2. **119-122行目**: TMimeTypesHelper型ヘルパー宣言
3. **258-296行目**: ToStringメソッド実装 - case文による文字列変換

#### Step 3: 利用例を理解する

実際の使用パターンを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Response.pas | `src/Horse.Response.pas` | ContentTypeメソッドでの使用例 |

### プログラム呼び出し階層図

```
アプリケーションコード
    │
    └─ THorseResponse.ContentType(TMimeTypes.ApplicationJSON)
           │
           └─ TMimeTypes.ToString
                  │
                  └─ case Self of ... → 'application/json'
```

### データフロー図

```
[入力]                       [処理]                         [出力]

TMimeTypes.ApplicationJSON ───▶  ToString                  ───▶  'application/json'
                                    │
                                    └─ case Self of
                                          └─ ApplicationJSON
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Commons.pas | `src/Horse.Commons.pas` | ソース | TMimeTypes列挙型とヘルパー定義 |
| Horse.Response.pas | `src/Horse.Response.pas` | ソース | ContentType設定での使用 |
| Horse.Core.Files.pas | `src/Horse.Core.Files.pas` | ソース | ファイル送信時のMIMEタイプ設定 |

### 定義されている全MIMEタイプ

| 列挙値 | MIME文字列 | 用途 |
|--------|-----------|------|
| MultiPartFormData | multipart/form-data | フォームデータ（ファイルアップロード） |
| ApplicationXWWWFormURLEncoded | application/x-www-form-urlencoded | フォームデータ（URLエンコード） |
| ApplicationJSON | application/json | JSONデータ |
| ApplicationOctetStream | application/octet-stream | バイナリデータ |
| ApplicationXML | application/xml | XMLデータ |
| ApplicationJavaScript | application/javascript | JavaScriptコード |
| ApplicationPDF | application/pdf | PDFドキュメント |
| ApplicationTypeScript | application/typescript | TypeScriptコード |
| ApplicationZIP | application/zip | ZIPアーカイブ |
| TextPlain | text/plain | プレーンテキスト |
| TextCSS | text/css | CSSスタイルシート |
| TextCSV | text/csv | CSVデータ |
| TextHTML | text/html | HTMLドキュメント |
| ImageJPEG | image/jpeg | JPEG画像 |
| ImagePNG | image/png | PNG画像 |
| ImageGIF | image/gif | GIF画像 |
| Download | application/x-download | ダウンロード用 |
