# 機能設計書 47-バージョン取得

## 概要

本ドキュメントは、Horseフレームワークのバージョン情報を取得するTHorseCore.Versionメソッドについて記述する。

### 本機能の処理概要

本機能は、Horseフレームワークの現在のバージョン番号を文字列として返却し、アプリケーションでのバージョン確認やログ出力に使用される。

**業務上の目的・背景**：フレームワークのバージョン管理は、デバッグ、互換性確認、運用ログ記録において重要である。本機能により、実行時にフレームワークバージョンを取得し、APIレスポンスへの埋め込みやサーバー起動ログへの出力が可能になる。

**機能の利用シーン**：本機能は以下のような場面で使用される。
- サーバー起動時のログにHorseバージョンを出力する際
- ヘルスチェックAPIでフレームワーク情報を返却する際
- デバッグ時のバージョン確認

**主要な処理内容**：
1. THorseCore.Versionクラスメソッドを呼び出し
2. Horse.Constants.HORSE_VERSION定数を返却

**関連システム・外部連携**：特になし（内部ユーティリティ機能）。

**権限による制御**：本機能に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に依存しないユーティリティ機能 |

## 機能種別

ユーティリティ / 情報取得

## 入力仕様

### 入力パラメータ

入力パラメータなし

### 入力データソース

なし

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Result | string | バージョン文字列（例: '3.1.9'） |

### 出力先

メソッド戻り値として返却

## 処理フロー

### 処理シーケンス

```
1. THorseCore.Version クラスメソッド呼び出し
2. HORSE_VERSION 定数値を返却
```

### フローチャート

```mermaid
flowchart TD
    A[THorseCore.Version 呼び出し] --> B[HORSE_VERSION 定数参照]
    B --> C["'3.1.9' 返却"]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 定数返却 | 常にHORSE_VERSION定数の値を返却する | 常時 |
| BR-02 | セマンティックバージョニング | バージョンはMajor.Minor.Patch形式 | 常時 |

### 計算ロジック

```pascal
class function THorseCore.Version: string;
begin
  Result := HORSE_VERSION;
end;
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

エラーケースなし

### リトライ仕様

該当なし

## トランザクション仕様

トランザクション処理なし

## パフォーマンス要件

- 定数参照のみのため、オーバーヘッドなし

## セキュリティ考慮事項

- バージョン情報の公開による脆弱性特定のリスクを考慮（公開APIでは非表示も検討）

## 備考

- 現在のバージョン: 3.1.9
- バージョンはHorse.Constants.pasに定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 定数定義を理解する

バージョン定数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Constants.pas | `src/Horse.Constants.pas` | HORSE_VERSION定数の定義 |

**読解のコツ**: 定数ファイルにはバージョン以外にもデフォルトホスト、デフォルトポートなどのフレームワーク設定が定義されている。

#### Step 2: メソッド実装を理解する

Versionメソッドの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Core.pas | `src/Horse.Core.pas` | THorseCore.Versionメソッド |

**主要処理フロー**:
1. **126行目**: Versionメソッド宣言 - `class function Version: string;`
2. **379-382行目**: Versionメソッド実装 - HORSE_VERSION定数を返却

#### Step 3: 定数ファイルの全体を理解する

関連する定数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Constants.pas | `src/Horse.Constants.pas` | 全定数の定義 |

**主要処理フロー**:
- **10行目**: `DEFAULT_HOST = '0.0.0.0'` - デフォルトホスト
- **11行目**: `DEFAULT_PORT = 9000` - デフォルトポート
- **12行目**: `START_RUNNING = 'Server is running on %s:%d'` - 起動メッセージフォーマット
- **13行目**: `HORSE_VERSION = '3.1.9'` - バージョン文字列

### プログラム呼び出し階層図

```
THorseCore.Version
    │
    └─ HORSE_VERSION (Horse.Constants)
           │
           └─ '3.1.9'
```

### データフロー図

```
[入力]                    [処理]                         [出力]

なし               ───▶  HORSE_VERSION 参照           ───▶  '3.1.9'
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | THorseCore.Versionメソッド実装 |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | HORSE_VERSION定数定義 |

### 定数一覧

| 定数名 | 値 | 説明 |
|--------|-----|------|
| DEFAULT_HOST | '0.0.0.0' | デフォルトリスニングホスト |
| DEFAULT_PORT | 9000 | デフォルトリスニングポート |
| START_RUNNING | 'Server is running on %s:%d' | サーバー起動メッセージ |
| HORSE_VERSION | '3.1.9' | フレームワークバージョン |
