# 機能設計書 50-Consoleプロバイダー

## 概要

本ドキュメントは、Horseフレームワークにおけるコンソールアプリケーション用HTTPサーバープロバイダーTHorseProviderについて記述する。

### 本機能の処理概要

本機能は、コンソールアプリケーションとしてHTTPサーバーを起動・停止するための基盤機能を提供し、スタンドアロンのWebサーバーアプリケーションを構築できるようにする。

**業務上の目的・背景**：Delphi/FPCでWebサービスを開発する際、コンソールアプリケーションとして動作するHTTPサーバーは、マイクロサービス、APIサーバー、開発用サーバーなど様々な用途で必要とされる。本機能により、TIdHTTPWebBrokerBridgeをラップした使いやすいAPIでHTTPサーバーの起動・停止・設定を行える。

**機能の利用シーン**：本機能は以下のような場面で使用される。
- コマンドラインAPIサーバーの構築
- 開発・テスト用のローカルサーバー起動
- マイクロサービスアーキテクチャでのサービス実装
- Dockerコンテナで動作するWebサービス

**主要な処理内容**：
1. ポート、ホスト、最大接続数などのサーバー設定
2. TIdHTTPWebBrokerBridgeによるHTTPリクエスト受信・処理
3. SSL/TLS設定によるHTTPS対応
4. イベントループによるリクエスト待機

**関連システム・外部連携**：THorseCore（ルーティング）、THorseWebModule（リクエスト処理）、Indyコンポーネント（HTTP通信基盤）と連携。

**権限による制御**：本機能に権限による制御はない。OSレベルのポートバインディング権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面に依存しないサーバー機能 |

## 機能種別

サーバー管理 / プロバイダー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| APort | Integer | No | リスニングポート番号 | デフォルト: 9000 |
| AHost | string | No | リスニングホスト | デフォルト: '0.0.0.0' |
| ACallbackListen | TProc | No | サーバー起動時コールバック | なし |
| ACallbackStopListen | TProc | No | サーバー停止時コールバック | なし |

### 入力データソース

アプリケーションコードからの直接呼び出し、またはプロパティ設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IsRunning | Boolean | サーバー稼働状態 |

### 出力先

HTTPレスポンスとしてネットワーク出力

## 処理フロー

### 処理シーケンス

```
1. プロパティ設定（オプション）
   └─ Port, Host, MaxConnections, IOHandleSSL など
2. THorseProvider.Listen 呼び出し
   └─ InternalListen 実行
      └─ デフォルト値設定（未設定の場合）
      └─ TIdHTTPWebBrokerBridge 取得/生成
      └─ WebModuleClass 登録
      └─ SSL/TLS設定（設定されている場合）
      └─ バインディング設定
      └─ サーバー起動（Active := True）
      └─ OnListenコールバック実行
      └─ イベントループ開始（コンソールの場合）
3. THorseProvider.StopListen 呼び出し（停止時）
   └─ InternalStopListen 実行
      └─ サーバー停止
      └─ OnStopListenコールバック実行
      └─ イベント通知
```

### フローチャート

```mermaid
flowchart TD
    A[Listen 呼び出し] --> B{ポート設定済み?}
    B -->|No| C[デフォルトポート 9000]
    B -->|Yes| D[設定ポート使用]
    C --> E{ホスト設定済み?}
    D --> E
    E -->|No| F[デフォルトホスト 0.0.0.0]
    E -->|Yes| G[設定ホスト使用]
    F --> H[HTTPWebBroker 取得]
    G --> H
    H --> I{SSL設定あり?}
    I -->|Yes| J[SSL初期化]
    I -->|No| K[バインディング設定]
    J --> K
    K --> L[サーバー起動]
    L --> M[OnListen コールバック]
    M --> N{コンソール?}
    N -->|Yes| O[イベントループ]
    N -->|No| P[終了]
    O --> Q{StopListen?}
    Q -->|Yes| R[サーバー停止]
    Q -->|No| O
    R --> S[OnStopListen コールバック]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトポート | 未設定時はポート9000を使用 | ポート未指定時 |
| BR-02 | デフォルトホスト | 未設定時は'0.0.0.0'（全インターフェース）を使用 | ホスト未指定時 |
| BR-03 | Keep-Alive | デフォルトでKeep-Alive接続が有効 | 初期化時 |
| BR-04 | シングルトン | TIdHTTPWebBrokerBridgeは遅延生成・シングルトン | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Exception | ポートが既に使用中 | 別ポートを指定 |
| - | Exception | StopListen呼び出し時にサーバー未起動 | 'Horse not listen'メッセージで例外発生 |
| - | SSL Error | SSL証明書ファイルが存在しない | 正しいパスを指定 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

トランザクション処理なし

## パフォーマンス要件

- 高スループットのHTTPリクエスト処理
- 同時接続数の制限設定が可能

## セキュリティ考慮事項

- SSL/TLS設定によるHTTPS対応
- ホストバインディングによるアクセス制限
- 認証処理のフック（OnAuthentication）

## 備考

- Delphi専用（FPC環境では別プロバイダーを使用）
- TIdHTTPWebBrokerBridgeはIndy HTTPサーバーコンポーネント
- initialization節でKeepConnectionAlive := Trueが設定される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス構造を理解する

プロバイダークラスの構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | THorseProviderクラス宣言（継承元含む） |

**読解のコツ**: `{$IF NOT DEFINED(FPC)}`によりDelphi専用であることに注意。FPC環境では別のプロバイダーを使用する。

#### Step 2: プロパティを理解する

サーバー設定プロパティを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | Host、Port、MaxConnections等のプロパティ |

**主要処理フロー**:
1. **17-24行目**: クラス変数宣言 - FPort、FHost、FRunning、FEvent等
2. **50-55行目**: プロパティ宣言 - Host、Port、MaxConnections、ListenQueue、KeepConnectionAlive、IOHandleSSL
3. **113-127行目**: デフォルト値取得メソッド

#### Step 3: Listen/StopListenを理解する

サーバー起動・停止処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | InternalListen、InternalStopListenメソッド |

**主要処理フロー**:
- **174-238行目**: InternalListen実装
  - **180-184行目**: デフォルト値設定
  - **186-193行目**: MaxConnections設定
  - **198-199行目**: SSL初期化
  - **202-208行目**: バインディング設定
  - **210-214行目**: サーバー起動
  - **217-221行目**: イベントループ
- **240-253行目**: InternalStopListen実装
  - **244-246行目**: サーバー停止
  - **248-249行目**: イベント通知

### プログラム呼び出し階層図

```
THorseProvider.Listen
    │
    ├─ SetPort / SetHost（オプション）
    │
    └─ InternalListen
           │
           ├─ GetDefaultHTTPWebBroker
           │      └─ TIdHTTPWebBrokerBridge.Create
           │
           ├─ WebRequestHandler.WebModuleClass := WebModuleClass
           │
           ├─ InitServerIOHandlerSSLOpenSSL（SSL設定時）
           │      └─ TIdServerIOHandlerSSLOpenSSL.Create
           │
           ├─ TIdHTTPWebBrokerBridge.Active := True
           │      └─ StartListening
           │
           ├─ DoOnListen（コールバック）
           │
           └─ GetDefaultEvent.WaitFor（イベントループ）

THorseProvider.StopListen
    │
    └─ InternalStopListen
           │
           ├─ GetDefaultHTTPWebBroker.StopListening
           │      └─ Active := False
           │
           ├─ DoOnStopListen（コールバック）
           │
           └─ GetDefaultEvent.SetEvent（イベント通知）
```

### データフロー図

```
[入力]                       [処理]                         [出力]

Port, Host            ───▶  プロパティ設定              ───▶  内部状態
    │                                                           │
    ▼                                                           ▼
Listen呼び出し        ───▶  TIdHTTPWebBrokerBridge     ───▶  HTTPサーバー起動
    │                          │                               │
    │                          └─ WebModule登録                 │
    │                                                           ▼
HTTPリクエスト        ───▶  WebModule処理              ───▶  HTTPレスポンス
    │
    ▼
StopListen呼び出し    ───▶  サーバー停止               ───▶  終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Console.pas | `src/Horse.Provider.Console.pas` | ソース | THorseProviderクラス定義と実装 |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | 基底プロバイダークラス |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | リクエスト処理WebModule |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | デフォルト値定数 |
| Horse.Provider.IOHandleSSL.pas | `src/Horse.Provider.IOHandleSSL.pas` | ソース | SSL設定クラス |

### 設定プロパティ一覧

| プロパティ | 型 | デフォルト | 説明 |
|-----------|-----|----------|------|
| Host | string | '0.0.0.0' | リスニングホスト（IPアドレス） |
| Port | Integer | 9000 | リスニングポート番号 |
| MaxConnections | Integer | 0 (無制限) | 最大同時接続数 |
| ListenQueue | Integer | IdListenQueueDefault | 接続待ちキューサイズ |
| KeepConnectionAlive | Boolean | True | Keep-Alive接続の有効化 |
| IOHandleSSL | IHorseProviderIOHandleSSL | nil | SSL/TLS設定 |
