# 機能設計書 56-Lazarus対応

## 概要

本ドキュメントは、Horse WebフレームワークにおけるFree Pascal/Lazarus環境での動作サポート機能の設計を記述する。

### 本機能の処理概要

Lazarus対応機能は、Horse WebフレームワークをFree Pascal Compiler（FPC）およびLazarus IDE環境で動作させるための機能を提供する。FPC条件コンパイルによりDelphi固有の機能をFPC互換コードに置き換え、クロスプラットフォーム（Windows, Linux, macOS）での動作を実現する。

**業務上の目的・背景**：Delphiはプロプライエタリな開発環境であり、ライセンスコストや特定プラットフォームへの制約がある。Free Pascal/Lazarusはオープンソースの開発環境であり、ライセンスコストなしでクロスプラットフォーム開発が可能。Lazarus対応により、より幅広い開発者コミュニティがHorseフレームワークを利用でき、Linux/macOSを含むマルチプラットフォームでのWebアプリケーション開発が可能になる。

**機能の利用シーン**：
- オープンソース開発環境を使用したい場合
- Delphiライセンスを持たない開発者がHorseを使用したい場合
- Linux/macOSネイティブアプリケーションを開発したい場合
- クロスコンパイルによるマルチプラットフォーム対応が必要な場合

**主要な処理内容**：
1. FPC条件コンパイルディレクティブによる環境検出
2. Delphi固有ユニット（System.*）のFPC互換ユニットへの置換
3. FPC固有のモード設定（{$MODE DELPHI}）によるDelphi互換性確保
4. LCL（Lazarus Component Library）プロバイダーの提供
5. FPC HTTP Server（TFPHTTPServer）ベースのHTTP処理
6. fpWeb/fpCGI等のFPC Web関連ユニットの活用
7. cthreadsユニットによるUnix環境でのスレッドサポート

**関連システム・外部連携**：
- Free Pascal Compiler（FPC）
- Lazarus IDE
- FPC HTTP Server（fphttpserver）
- FPC Web Framework（fpWeb, fpCGI, fpApache24）
- LCL（Lazarus Component Library）

**権限による制御**：Lazarus対応機能自体には権限制御機能はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | LCLメインフォーム | 主画面 | HORSE_LCLコンパイルディレクティブによりLazarus/LCL環境で動作 |
| 5 | デーモンメイン | 補助機能 | Lazarus環境でデーモンとして動作 |
| 6 | デーモンマネージャー | 補助機能 | Lazarus環境でデーモンマッパーとして動作 |
| 8 | Webモジュール | 補助機能 | FPC条件コンパイルによりLazarus環境で動作 |

## 機能種別

クロスプラットフォーム対応 / コンパイラ互換性

## 入力仕様

### 入力パラメータ

コンパイル時の条件コンパイルディレクティブで制御される。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| FPC | コンパイルディレクティブ | - | Free Pascal Compilerが自動定義 | FPCでコンパイル時に自動設定 |
| HORSE_LCL | コンパイルディレクティブ | No | LCLプロバイダーを使用する場合に定義 | - |
| HORSE_DAEMON | コンパイルディレクティブ | No | FPCデーモンプロバイダーを使用する場合に定義 | - |
| HORSE_CGI | コンパイルディレクティブ | No | FPC CGIプロバイダーを使用する場合に定義 | - |
| HORSE_APACHE | コンパイルディレクティブ | No | FPC Apacheプロバイダーを使用する場合に定義 | - |
| HORSE_FCGI | コンパイルディレクティブ | No | FPC FastCGIプロバイダーを使用する場合に定義 | - |

### 入力データソース

- コンパイル時のプロジェクト設定
- コマンドラインコンパイルオプション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行可能ファイル | Binary | FPCでコンパイルされた実行ファイル |
| 共有ライブラリ | .so/.dll | Apacheモジュール等の共有ライブラリ |

### 出力先

- ファイルシステム（コンパイル結果）

## 処理フロー

### 処理シーケンス

```
1. コンパイル開始
   └─ FPC が FPC ディレクティブを自動定義
2. Horse.pas 読み込み
   └─ {$IF DEFINED(FPC)} でFPCブランチを選択
3. プロバイダー選択
   └─ HORSE_LCL/HORSE_DAEMON/HORSE_CGI等に応じて適切なFPC版プロバイダーを使用
4. FPC固有ユニット読み込み
   └─ SysUtils, Classes (Delphiの System.* ではなく)
   └─ fphttpserver, fpHTTP, httpdefs 等
5. {$MODE DELPHI} 設定
   └─ Delphi互換モードを有効化
6. アプリケーション実行
   └─ FPC版プロバイダーによるHTTPサーバー起動
```

### フローチャート

```mermaid
flowchart TD
    A[コンパイル開始] --> B{FPC定義済み?}
    B -->|Yes| C[FPCブランチ選択]
    B -->|No| D[Delphiブランチ選択]
    C --> E{プロバイダー選択}
    E -->|HORSE_LCL| F[Horse.Provider.FPC.LCL]
    E -->|HORSE_DAEMON| G[Horse.Provider.FPC.Daemon]
    E -->|HORSE_CGI| H[Horse.Provider.FPC.CGI]
    E -->|HORSE_APACHE| I[Horse.Provider.FPC.Apache]
    E -->|HORSE_FCGI| J[Horse.Provider.FPC.FastCGI]
    E -->|その他| K[Horse.Provider.FPC.HTTPApplication]
    F --> L[LCL GUI アプリケーション]
    G --> M[デーモンプロセス]
    H --> N[CGI実行]
    I --> O[Apacheモジュール]
    J --> P[FastCGI実行]
    K --> Q[コンソールアプリケーション]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | FPC自動検出 | FPC でコンパイル時に FPC ディレクティブが自動定義される | FPCコンパイル時 |
| BR-56-02 | MODE DELPHI | FPC固有ユニットでは {$MODE DELPHI} を設定してDelphi互換性を確保 | FPC版ユニット |
| BR-56-03 | cthreads必須 | Unix環境でのスレッド使用時は cthreads ユニットが必要 | Unix + スレッド使用時 |
| BR-56-04 | プロバイダー優先順位 | HORSE_APACHE > HORSE_CGI > HORSE_FCGI > HORSE_DAEMON > HORSE_LCL の順で選択 | 複数ディレクティブ定義時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コンパイルエラー | cthreads未使用でスレッド使用（Unix） | uses節にcthreadsを追加 |
| - | コンパイルエラー | FPC非対応ユニット使用 | FPC互換ユニットに置換 |

### リトライ仕様

コンパイル時機能のためリトライは適用されない。

## トランザクション仕様

コンパイル時機能のためトランザクションは適用されない。

## パフォーマンス要件

- FPC版はDelphi版と同等のランタイムパフォーマンスを目指す
- TFPHTTPServer はスレッドプールベースで効率的なリクエスト処理

## セキュリティ考慮事項

- FPC版ではSSL/TLS対応が限定的（プロバイダーによる）
- 適切なファイルパーミッション設定が必要

## 備考

- FPC 3.0以降を推奨
- Lazarus 2.0以降を推奨
- 一部の機能はFPC版で未実装の場合がある
- クロスコンパイル時は対象プラットフォームのライブラリが必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: FPC条件コンパイルの基本構造を理解する

メインユニットでのFPC/Delphi分岐を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Horse.pas | `src/Horse.pas` | FPC条件コンパイルによるプロバイダー選択 |

**主要処理フロー**:
- **3-5行目**: `{$IF DEFINED(FPC)} {$MODE DELPHI}{$H+} {$ENDIF}` - FPC用モード設定
- **10-23行目**: FPC用uses節
  - 12行目: SysUtils（System.SysUtilsではなく）
  - 13行目: Horse.Provider.FPC.HTTPApplication
  - 14-23行目: 各プロバイダーの条件選択
- **69-110行目**: THorseProviderの型定義
  - 78-84行目: HORSE_CGI時のFPC/Delphi分岐
  - 90-96行目: HORSE_DAEMON時のFPC/Delphi分岐
  - 97-98行目: HORSE_LCL時（FPC専用）
  - 103-104行目: デフォルト時のFPC HTTPApplication使用

**読解のコツ**: `{$IF DEFINED(FPC)}` で囲まれたブロックはFPC専用、`{$ELSE}` 以降はDelphi専用。`{$MODE DELPHI}` はFPCにDelphi互換モードを指示する。

#### Step 2: FPC版プロバイダーの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.FPC.LCL.pas | `src/Horse.Provider.FPC.LCL.pas` | LCLプロバイダー実装 |
| 2-2 | Horse.Provider.FPC.HTTPApplication.pas | `src/Horse.Provider.FPC.HTTPApplication.pas` | HTTPアプリケーション基盤 |

**Horse.Provider.FPC.LCL.pas の主要処理フロー**:
- **3-5行目**: `{$IF DEFINED(FPC)} {$MODE DELPHI}{$H+} {$ENDIF}` - FPCモード設定
- **9行目**: `{$IF DEFINED(HORSE_LCL)}` - LCL専用条件
- **13-15行目**: fphttpapp, fphttpserver ユニット使用
- **26-45行目**: THTTPServerThread クラス定義
  - 32行目: FServer: TFPHTTPServer
  - 33行目: FHorse: THorseCore
- **47-78行目**: THorseProvider クラス定義（FHTTPServerThread使用）
- **220-227行目**: THTTPServerThread.Create
  - 224行目: FServer := TFPHTTPServer.Create(nil)
  - 225行目: FServer.OnRequest := OnRequest
  - 226行目: FHorse := THorseCore.GetInstance
- **251-263行目**: Execute - スレッド実行ループ
  - 257行目: FServer.Port := FPort
  - 258行目: FServer.Threaded := True
  - 260行目: FServer.Active := True
- **271-296行目**: OnRequest - リクエスト処理
  - 276-277行目: THorseRequest/THorseResponse 生成
  - 280行目: FHorse.Routes.Execute

#### Step 3: FPC版WebModuleを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.WebModule.pas | `src/Horse.WebModule.pas` | FPC/Delphi共通WebModule |

**主要処理フロー**:
- **3-5行目**: FPC モード設定
- **10-18行目**: FPC/Delphi用uses節分岐
  - 12-14行目: FPC用（httpdefs, fpHTTP, fpWeb）
  - 16-17行目: Delphi用（Web.HTTPApp）
- **22-27行目**: THorseWebModule クラス定義
  - 23-24行目: FPC用（TFPWebModule継承）
  - 26行目: Delphi用（TWebModule継承）
- **58-62行目**: リソースファイル分岐
  - 59行目: FPC用（Horse.WebModule.lfm）
  - 61行目: Delphi用（*.dfm）
- **80-85行目**: DoOnRequest（FPC専用オーバーライド）
- **112-115行目**: initialization（FPC専用）
  - 114行目: RegisterHTTPModule(THorseWebModule)

#### Step 4: 使用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | views.main.pas | `samples/lazarus/lcl/src/views.main.pas` | LCL使用例 |
| 4-2 | Samples.lpr | `samples/lazarus/lcl/Samples.lpr` | LCLプロジェクトファイル |

**views.main.pas の主要処理フロー**:
- **3行目**: `{$MODE DELPHI}{$H+}` - Delphiモード設定
- **7行目**: uses Horse - メインユニット使用
- **48-51行目**: FormCreate - THorse.Get でルート登録
- **60-64行目**: Start - THorse.Listen 呼び出し
  - 62行目: コメント「Need to set "HORSE_LCL" compilation directive」
- **66-69行目**: Stop - THorse.StopListen 呼び出し

### プログラム呼び出し階層図

```
Lazarus IDE / FPC コンパイル
    │
    └─ Horse.pas
           │
           ├─ {$IF DEFINED(FPC)} 検出
           │      └─ FPC版ユニット選択
           │
           └─ THorseProvider 型エイリアス
                  │
                  ├─ HORSE_LCL定義時
                  │      └─ Horse.Provider.FPC.LCL.THorseProvider
                  │             └─ THTTPServerThread
                  │                    └─ TFPHTTPServer
                  │
                  ├─ HORSE_DAEMON定義時
                  │      └─ Horse.Provider.FPC.Daemon.THorseProvider
                  │             └─ THTTPServerThread
                  │                    └─ TFPHTTPServer
                  │
                  ├─ HORSE_CGI定義時
                  │      └─ Horse.Provider.FPC.CGI.THorseProvider
                  │             └─ TCGIApplication (fpCGI)
                  │
                  ├─ HORSE_APACHE定義時
                  │      └─ Horse.Provider.FPC.Apache.THorseProvider
                  │             └─ TCustomApacheApplication (fpApache24)
                  │
                  ├─ HORSE_FCGI定義時
                  │      └─ Horse.Provider.FPC.FastCGI.THorseProvider
                  │
                  └─ デフォルト
                         └─ Horse.Provider.FPC.HTTPApplication.THorseProvider
```

### データフロー図

```
[コンパイル時]                    [実行時]

FPC コンパイラ           ┌─────────────────────────┐
    │                    │   条件コンパイル        │
    ├─ FPC定義 ─────────▶│   {$IF DEFINED(FPC)}    │
    │                    └───────────┬─────────────┘
    │                                │
    │                                ▼
    │                    ┌─────────────────────────┐
    ├─ HORSE_LCL等 ─────▶│   プロバイダー選択      │───────▶ 実行ファイル
    │   ディレクティブ   │   FPC版プロバイダー     │
    │                    └───────────┬─────────────┘
    │                                │
    │                                ▼
    │                    ┌─────────────────────────┐
    └─ ソースコード ────▶│   FPC固有ユニット       │
                         │   (fphttpserver等)      │
                         └─────────────────────────┘


[実行時]

HTTPリクエスト           ┌─────────────────────────┐
    │                    │   TFPHTTPServer         │
    │                    │   (FPC HTTP Server)     │
    ├─────────────────▶ └───────────┬─────────────┘
    │                                │
    │                                ▼
    │                    ┌─────────────────────────┐
    │                    │   THorseCore.Routes     │───────▶ HTTPレスポンス
    │                    │   (ルーティング実行)    │
    │                    └─────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.pas | `src/Horse.pas` | ソース | メインユニット、FPC/Delphi条件コンパイル |
| Horse.Provider.FPC.LCL.pas | `src/Horse.Provider.FPC.LCL.pas` | ソース | LCLプロバイダー（FPC版） |
| Horse.Provider.FPC.Daemon.pas | `src/Horse.Provider.FPC.Daemon.pas` | ソース | Daemonプロバイダー（FPC版） |
| Horse.Provider.FPC.CGI.pas | `src/Horse.Provider.FPC.CGI.pas` | ソース | CGIプロバイダー（FPC版） |
| Horse.Provider.FPC.Apache.pas | `src/Horse.Provider.FPC.Apache.pas` | ソース | Apacheプロバイダー（FPC版） |
| Horse.Provider.FPC.FastCGI.pas | `src/Horse.Provider.FPC.FastCGI.pas` | ソース | FastCGIプロバイダー（FPC版） |
| Horse.Provider.FPC.HTTPApplication.pas | `src/Horse.Provider.FPC.HTTPApplication.pas` | ソース | HTTPアプリケーション基盤（FPC版） |
| Horse.WebModule.pas | `src/Horse.WebModule.pas` | ソース | WebModule（FPC/Delphi共通） |
| Horse.Provider.Abstract.pas | `src/Horse.Provider.Abstract.pas` | ソース | プロバイダー抽象基底クラス |
| Horse.Core.pas | `src/Horse.Core.pas` | ソース | コア機能（ルーティング等） |
| views.main.pas | `samples/lazarus/lcl/src/views.main.pas` | サンプル | LCL使用例 |
| Samples.lpr | `samples/lazarus/lcl/Samples.lpr` | プロジェクト | LCLサンプルプロジェクト |
| Console.lpr | `samples/lazarus/console/Console.lpr` | プロジェクト | コンソールサンプルプロジェクト |
| CGI.lpr | `samples/lazarus/cgi/CGI.lpr` | プロジェクト | CGIサンプルプロジェクト |
| daemon.lpr | `samples/lazarus/daemon/daemon.lpr` | プロジェクト | Daemonサンプルプロジェクト |
| WinSvc.lpr | `samples/lazarus/winsvc/WinSvc.lpr` | プロジェクト | Windowsサービスサンプル |
