---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-リクエストボディ取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Request.pas` 45-47行目 - Body メソッドの宣言（3種類のオーバーロード）
- E-02: `src/Horse.Request.pas` 75-78行目 - Body: string 実装
- E-03: `src/Horse.Request.pas` 80-86行目 - Body(ABody: TObject) 実装
- E-04: `src/Horse.Request.pas` 88-91行目 - Body<T>: T 実装
- E-05: `src/Horse.Request.pas` 34行目 - FBody: TObject フィールド宣言
- E-06: `src/Horse.Request.pas` 28行目 - FWebRequest フィールド宣言
- E-07: `src/Horse.Request.pas` 118-135行目 - Destroy デストラクタ
- E-08: `src/Horse.Request.pas` 130-131行目 - FBody解放処理
- E-09: `src/Horse.Request.pas` 112-116行目 - Create コンストラクタ
- E-10: `src/Horse.Request.pas` 77行目 - FWebRequest.Content
- E-11: `src/Horse.Request.pas` 83-84行目 - 既存FBody解放処理
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 33-43行目 - Webモジュールでのリクエストボディ処理
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 11行目 - リクエストボディ取得の機能定義
- E-14: `src/Horse.Request.pas` 90行目 - T(FBody) キャスト
- E-15: `src/Horse.Request.pas` 85行目 - FBody := ABody
- E-16: `src/Horse.Request.pas` 46行目 - Body<T: class>: T ジェネリック制約（Delphi版）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRequest.Bodyメソッドでリクエストボディを取得できる | E-01, E-02, E-13 | ○ |
| C-02 | Bodyメソッドには3種類のオーバーロードがある | E-01 | ○ |
| C-03 | Body: stringはFWebRequest.Contentを返す | E-02, E-10 | ○ |
| C-04 | Body(ABody)で既存FBodyがあれば解放する | E-03, E-11 | ○ |
| C-05 | Body(ABody)でFBodyにオブジェクトを設定する | E-03, E-15 | ○ |
| C-06 | Body<T>は設定されたオブジェクトを型Tにキャストして返す | E-04, E-14 | ○ |
| C-07 | FBodyはTObject型のフィールド | E-05 | ○ |
| C-08 | FWebRequestはプラットフォーム依存（TWebRequest/TRequest） | E-06 | ○ |
| C-09 | DestroyデストラクタでFBodyが解放される | E-07, E-08 | ○ |
| C-10 | CreateコンストラクタでFWebRequestが設定される | E-09 | ○ |
| C-11 | 画面機能マッピングにWebモジュールが関連画面として定義 | E-12 | ○ |
| C-12 | Bodyメソッドは全バージョンで利用可能 | E-01（条件コンパイルなし） | ○ |
| C-13 | Body(ABody)はメソッドチェーン用にSelfを返す | E-03 (Result := Self) | ○ |
| C-14 | Body<T>のclass制約はDelphi版のみ | E-16 | ○ |
| C-15 | THorseSessionsがCreateで初期化される | E-09 | ○ |
| C-16 | リクエストボディ取得はリクエスト処理カテゴリ | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード上の根拠あり

## 6) レビュアーチェックリスト（最小）
- [x] Bodyメソッドのオーバーロード数が正しいか確認
- [x] FWebRequest.Contentが正しく参照されているか確認
- [x] 既存FBodyの解放処理が正確に記述されているか確認
- [x] Body<T>の型キャストが正確か確認
- [x] 画面機能マッピングのWebモジュール関連が正しいか確認
