---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-クエリパラメータ取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項（ログ記録）**：具体的なログ実装の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Request.pas` 307-312行目（Query メソッド）
- E-02: `src/Horse.Request.pas` 243-259行目（InitializeQuery メソッド）
- E-03: `src/Horse.Core.Param.pas` 23行目（THorseList型定義）
- E-04: `src/Horse.Core.Param.pas` 66-76行目（ContainsKey メソッド）
- E-05: `src/Horse.Core.Param.pas` 99-126行目（Field メソッド）
- E-06: `src/Horse.Core.Param.pas` 209-213行目（Required メソッド）
- E-07: `src/Horse.Core.Param.Field.pas` 277-284行目（AsString メソッド）
- E-08: `src/Horse.Core.Param.Field.pas` 176-189行目（AsInteger メソッド）
- E-09: `src/Horse.Core.Param.Field.pas` 391-398行目（RaiseHorseException）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 11行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRequest.Queryメソッドでクエリパラメータを取得 | E-01, E-10 | ○ |
| C-02 | 遅延初期化パターンを使用（初回アクセス時のみ初期化） | E-01 | ○ |
| C-03 | QueryFieldsをループしてパラメータを解析 | E-02 | ○ |
| C-04 | "="の位置でキーと値を分割 | E-02 (251-253行目) | ○ |
| C-05 | 同一キーで複数値がある場合はカンマで連結 | E-02 (254-257行目) | ○ |
| C-06 | THorseListはTDictionary<string, string>の型エイリアス | E-03 | ○ |
| C-07 | キー比較は大文字小文字を区別しない | E-04 (AnsiCompareText使用) | ○ |
| C-08 | デフォルトで必須検証は無効（Required False） | E-02 (248行目), E-06 | ○ |
| C-09 | Fieldメソッドで型変換オブジェクトを取得 | E-05 | ○ |
| C-10 | AsStringで文字列として値を取得 | E-07 | ○ |
| C-11 | AsIntegerで整数として値を取得 | E-08 | ○ |
| C-12 | 必須パラメータが存在しない場合にEHorseException発生 | E-07, E-09 | ○ |
| C-13 | 型変換エラー時に400 BadRequestを返す | E-08, E-09 | ○ |
| C-14 | DelphiとFree Pascal両対応（条件コンパイル） | E-01, E-02 | ○ |
| C-15 | TWebRequest.QueryFieldsから生のパラメータを取得 | E-02 (249行目) | ○ |
| C-16 | 存在しないキーを取得すると空文字列を返す | E-04 (179-188行目) | ○ |
| C-17 | パラメータ数はO(n)の計算量 | E-02 (ループ処理) | ○ |
| C-18 | クエリパラメータはサーバーログに記録される可能性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ログ記録に関する具体的な実装はHorseフレームワーク内には見当たらない
  - 候補：使用するWebサーバー（Apache/IIS）のログ設定 / アプリケーション側のログ実装 / フレームワーク外の設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティ考慮事項は一般的なWebセキュリティのベストプラクティスとして記載（実装の根拠ではないがドキュメントとして妥当）

## 6) レビュアーチェックリスト（最小）
- [ ] InitializeQueryメソッドのキー・値分割ロジックが正確に記述されているか確認
- [ ] 重複キーのカンマ連結動作が意図した仕様であるか確認
- [ ] 大文字小文字非区別の比較がAnsiCompareTextで実装されていることを確認
