---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-パスパラメータ取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ルーティングエンジンの詳細な動作**：RouterTreeの詳細なパラメータ抽出ロジックの検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Request.pas` 300-305行目（Params メソッド）
- E-02: `src/Horse.Request.pas` 238-241行目（InitializeParams メソッド）
- E-03: `src/Horse.Core.Param.pas` 209-213行目（Required メソッド）
- E-04: `src/Horse.Core.Param.pas` 66-76行目（ContainsKey メソッド、大文字小文字非区別）
- E-05: `src/Horse.Core.Param.pas` 179-189行目（GetItem メソッド）
- E-06: `src/Horse.Core.Param.Field.pas` 277-284行目（AsString メソッド、必須検証）
- E-07: `src/Horse.Core.Param.Field.pas` 391-398行目（RaiseHorseException）
- E-08: `src/Horse.Commons.pas` 164-217行目（MatchRoute関数、パスマッチング）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 12行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRequest.Paramsメソッドでパスパラメータを取得 | E-01, E-09 | ○ |
| C-02 | 遅延初期化パターンを使用 | E-01 | ○ |
| C-03 | InitializeParamsでRequired(True)を設定 | E-02, E-03 | ○ |
| C-04 | パスパラメータはデフォルトで必須検証が有効 | E-02 | ○ |
| C-05 | キー比較は大文字小文字を区別しない | E-04 | ○ |
| C-06 | 存在しないキーを取得すると空文字列を返す | E-05 | ○ |
| C-07 | Required設定時に値が空だとEHorseException発生 | E-06, E-07 | ○ |
| C-08 | /:param形式でパスパラメータを定義 | E-08 | ○ |
| C-09 | MatchRoute関数でパスマッチングを実行 | E-08 | ○ |
| C-10 | パスを"/"で分割してセグメント単位でマッチ | E-08 (172-178行目) | ○ |
| C-11 | ":"で始まる部分をパラメータとして認識 | E-08 (175-176行目) | ○ |
| C-12 | 正規表現を使用してパスマッチング | E-08 (200-206行目) | ○ |
| C-13 | DelphiとFree Pascal両対応 | E-01, E-08 | ○ |
| C-14 | ルーティング時にパラメータを抽出してDictionaryに格納 | **詳細実装要確認** | △ |
| C-15 | 型変換エラー時に400 BadRequestを返す | E-07 | ○ |
| C-16 | O(1)〜O(n)の計算量でパラメータ取得 | E-04, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- ルーティングエンジン（THorseRouterTree）内部でのパラメータ抽出とTHorseRequest.Params.Dictionaryへの格納処理の詳細
  - 候補：Horse.Core.RouterTree.pas のGetCallback関連メソッド / NextCaller関連処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MatchRoute関数の動作は確認できるが、実際のパラメータ値抽出とDictionaryへの格納処理はRouterTreeの詳細実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] InitializeParamsでRequired(True)が設定されていることを確認
- [ ] THorseRouterTree内でのパラメータ抽出・格納ロジックを追加確認
- [ ] MatchRoute関数の正規表現パターン生成が正しく動作することを確認
