---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ヘッダー取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Request.pas` 137-147行目（Headers メソッド）
- E-02: `src/Horse.Core.Param.Header.pas` 57-89行目（GetHeaders メソッド）
- E-03: `src/Horse.Core.Param.Header.pas` 114-185行目（GetHeadersList メソッド - Delphi版）
- E-04: `src/Horse.Core.Param.Header.pas` 94-110行目（GetHeadersList メソッド - FPC版）
- E-05: `src/Horse.Core.Param.Header.pas` 137-138行目（ISAPI実装）
- E-06: `src/Horse.Core.Param.Header.pas` 139-151行目（Apache実装）
- E-07: `src/Horse.Core.Param.Header.pas` 152-172行目（CGI実装）
- E-08: `src/Horse.Core.Param.Header.pas` 173-179行目（Console/VCL実装）
- E-09: `src/Horse.Core.Param.Header.pas` 190-201行目（NormalizeEnvVarHeaderName）
- E-10: `src/Horse.Core.Param.pas` 66-76行目（大文字小文字非区別の比較）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 13行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | THorseRequest.Headersメソッドでヘッダーを取得 | E-01, E-11 | ○ |
| C-02 | 遅延初期化パターンを使用 | E-01 | ○ |
| C-03 | THorseCoreParamHeader.GetHeadersを呼び出し | E-01 (143行目) | ○ |
| C-04 | Required(False)で必須検証を無効化 | E-01 (144行目) | ○ |
| C-05 | プロバイダー種別に応じた取得方法を選択 | E-02, E-03 | ○ |
| C-06 | ISAPIはALL_RAWフィールドから取得 | E-05 | ○ |
| C-07 | ApacheはPapr_table経由で取得 | E-06 | ○ |
| C-08 | CGIは環境変数HTTP_*から取得 | E-07 | ○ |
| C-09 | Console/VCLはIndy RawHeaders経由で取得 | E-08 | ○ |
| C-10 | FPCはCustomHeadersとTHeader列挙を使用 | E-04 | ○ |
| C-11 | CGIヘッダー名をHTTP_除去してハイフン形式に変換 | E-09 | ○ |
| C-12 | 各単語の先頭を大文字化 | E-09 (199行目) | ○ |
| C-13 | キー比較は大文字小文字を区別しない | E-10 | ○ |
| C-14 | ヘッダー名と値のペアをDictionaryに格納 | E-02 (71行目) | ○ |
| C-15 | FPCではTHeader列挙型で標準ヘッダーも取得 | E-04 (74-80行目) | ○ |
| C-16 | 存在しないヘッダーを取得すると空文字列を返す | E-10 | ○ |
| C-17 | DelphiとFree Pascal両対応（条件コンパイル） | E-02, E-03, E-04 | ○ |
| C-18 | RTTIを使用してFRequestInfoを取得（Console/VCL） | E-08 (174行目) | ○ |
| C-19 | NameValueSeparatorを":"に設定してパース | E-03 (135行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての実装パスがソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 各プロバイダー（ISAPI、Apache、CGI、Console/VCL、FPC）の実装パスが正しく記述されているか確認
- [ ] CGIヘッダー正規化のロジック（HTTP_除去、アンダースコア→ハイフン変換）が正確か確認
- [ ] RTTIを使用したFRequestInfo取得が動作することを確認
